/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import jline.CandidateListCompletionHandler;
import jline.CompletionHandler;
import jline.Completor;
import jline.ConsoleOperations;
import jline.CursorBuffer;
import jline.History;
import jline.Terminal;

public class ConsoleReader
implements ConsoleOperations {
    static final int TAB_WIDTH = 4;
    String prompt;
    private boolean useHistory;
    private boolean usePagination;
    public static final String CR = System.getProperty("line.separator");
    private static ResourceBundle loc = ResourceBundle.getBundle((class$jline$CandidateListCompletionHandler == null ? (class$jline$CandidateListCompletionHandler = ConsoleReader.class$("jline.CandidateListCompletionHandler")) : class$jline$CandidateListCompletionHandler).getName());
    public static SortedMap KEYMAP_NAMES;
    private final short[] keybindings;
    private boolean bellEnabled;
    private Character mask;
    private static final Character NULL_MASK;
    private int autoprintThreshhold;
    private final Terminal terminal;
    private CompletionHandler completionHandler;
    InputStream in;
    final Writer out;
    final CursorBuffer buf;
    static PrintWriter debugger;
    History history;
    final List completors;
    private Character echoCharacter;
    private Map triggeredActions;
    static /* synthetic */ Class class$jline$CandidateListCompletionHandler;

    public void addTriggeredAction(char c, ActionListener listener) {
        this.triggeredActions.put(new Character(c), listener);
    }

    public ConsoleReader() throws IOException {
        this(new FileInputStream(FileDescriptor.in), new PrintWriter(System.out));
    }

    public ConsoleReader(InputStream in, Writer out) throws IOException {
        this(in, out, null);
    }

    public ConsoleReader(InputStream in, Writer out, InputStream bindings) throws IOException {
        this(in, out, bindings, Terminal.getTerminal());
    }

    public ConsoleReader(InputStream in, Writer out, InputStream bindings, Terminal term) throws IOException {
        block9: {
            this.useHistory = true;
            this.usePagination = false;
            this.bellEnabled = true;
            this.mask = null;
            this.autoprintThreshhold = Integer.getInteger("jline.completion.threshold", 100);
            this.completionHandler = new CandidateListCompletionHandler();
            this.buf = new CursorBuffer();
            this.history = new History();
            this.completors = new LinkedList();
            this.echoCharacter = null;
            this.triggeredActions = new HashMap();
            this.terminal = term;
            this.setInput(in);
            this.out = out;
            if (bindings == null) {
                try {
                    String bindingFile = System.getProperty("jline.keybindings", new File(System.getProperty("user.home", ".jlinebindings.properties")).getAbsolutePath());
                    if (new File(bindingFile).isFile()) {
                        bindings = new FileInputStream(new File(bindingFile));
                    }
                }
                catch (Exception e) {
                    if (debugger == null) break block9;
                    e.printStackTrace(debugger);
                }
            }
        }
        if (bindings == null) {
            bindings = this.terminal.getDefaultBindings();
        }
        this.keybindings = new short[131070];
        Arrays.fill(this.keybindings, (short)-99);
        if (bindings != null) {
            Properties p2 = new Properties();
            p2.load(bindings);
            bindings.close();
            Iterator<Object> i = p2.keySet().iterator();
            while (i.hasNext()) {
                String val = (String)i.next();
                try {
                    Short code = new Short(val);
                    String op = p2.getProperty(val);
                    Short opval = (Short)KEYMAP_NAMES.get(op);
                    if (opval == null) continue;
                    this.keybindings[code.shortValue()] = opval;
                }
                catch (NumberFormatException nfe) {
                    this.consumeException(nfe);
                }
            }
        }
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setDebug(PrintWriter debugger) {
        ConsoleReader.debugger = debugger;
    }

    public void setInput(InputStream in) {
        this.in = in;
    }

    public InputStream getInput() {
        return this.in;
    }

    public String readLine() throws IOException {
        return this.readLine((String)null);
    }

    public String readLine(Character mask) throws IOException {
        return this.readLine(null, mask);
    }

    public void setBellEnabled(boolean bellEnabled) {
        this.bellEnabled = bellEnabled;
    }

    public boolean getBellEnabled() {
        return this.bellEnabled;
    }

    public int getTermwidth() {
        return Terminal.setupTerminal().getTerminalWidth();
    }

    public int getTermheight() {
        return Terminal.setupTerminal().getTerminalHeight();
    }

    public void setAutoprintThreshhold(int autoprintThreshhold) {
        this.autoprintThreshhold = autoprintThreshhold;
    }

    public int getAutoprintThreshhold() {
        return this.autoprintThreshhold;
    }

    int getKeyForAction(short logicalAction) {
        for (int i = 0; i < this.keybindings.length; ++i) {
            if (this.keybindings[i] != logicalAction) continue;
            return i;
        }
        return -1;
    }

    int clearEcho(int c) throws IOException {
        if (!this.terminal.getEcho()) {
            return 0;
        }
        int num = this.countEchoCharacters((char)c);
        this.back(num);
        this.drawBuffer(num);
        return num;
    }

    int countEchoCharacters(char c) {
        if (c == '\t') {
            int tabstop = 8;
            int position = this.getCursorPosition();
            return tabstop - position % tabstop;
        }
        return this.getPrintableCharacters(c).length();
    }

    StringBuffer getPrintableCharacters(char ch) {
        StringBuffer sbuff = new StringBuffer();
        if (ch >= ' ') {
            if (ch < '\u007f') {
                sbuff.append(ch);
            } else if (ch == '\u007f') {
                sbuff.append('^');
                sbuff.append('?');
            } else {
                sbuff.append('M');
                sbuff.append('-');
                if (ch >= '\u00a0') {
                    if (ch < '\u00ff') {
                        sbuff.append((char)(ch - 128));
                    } else {
                        sbuff.append('^');
                        sbuff.append('?');
                    }
                } else {
                    sbuff.append('^');
                    sbuff.append((char)(ch - 128 + 64));
                }
            }
        } else {
            sbuff.append('^');
            sbuff.append((char)(ch + 64));
        }
        return sbuff;
    }

    int getCursorPosition() {
        return (this.prompt == null ? 0 : this.prompt.length()) + this.buf.cursor;
    }

    public String readLine(String prompt) throws IOException {
        return this.readLine(prompt, null);
    }

    public void setDefaultPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getDefaultPrompt() {
        return this.prompt;
    }

    public String readLine(String prompt, Character mask) throws IOException {
        this.mask = mask;
        if (prompt != null) {
            this.prompt = prompt;
        }
        try {
            this.terminal.beforeReadLine(this, this.prompt, mask);
            if (this.prompt != null && this.prompt.length() > 0) {
                this.out.write(this.prompt);
                this.out.flush();
            }
            if (!this.terminal.isSupported()) {
                String string2 = this.readLine(this.in);
                return string2;
            }
            while (true) {
                int[] next2;
                if ((next2 = this.readBinding()) == null) {
                    String string3 = null;
                    return string3;
                }
                int c = next2[0];
                int code = next2[1];
                if (c == -1) {
                    String string4 = null;
                    return string4;
                }
                boolean success2 = true;
                switch (code) {
                    case -59: {
                        String string5;
                        if (this.buf.buffer.length() == 0) {
                            string5 = null;
                            return string5;
                        }
                    }
                    case -58: {
                        success2 = this.complete();
                        break;
                    }
                    case -1: {
                        success2 = this.setCursorPosition(0);
                        break;
                    }
                    case -7: {
                        success2 = this.killLine();
                        break;
                    }
                    case -8: {
                        success2 = this.clearScreen();
                        break;
                    }
                    case -15: {
                        success2 = this.resetLine();
                        break;
                    }
                    case -6: {
                        this.moveToEnd();
                        this.printNewline();
                        String string5 = this.finishBuffer();
                        return string5;
                    }
                    case -41: {
                        success2 = this.backspace();
                        break;
                    }
                    case -56: {
                        success2 = this.deleteCurrentCharacter();
                        break;
                    }
                    case -3: {
                        success2 = this.moveToEnd();
                        break;
                    }
                    case -4: {
                        success2 = this.moveCursor(-1) != 0;
                        break;
                    }
                    case -19: {
                        success2 = this.moveCursor(1) != 0;
                        break;
                    }
                    case -9: {
                        success2 = this.moveHistory(true);
                        break;
                    }
                    case -11: {
                        success2 = this.moveHistory(false);
                        break;
                    }
                    case -13: {
                        break;
                    }
                    case -60: {
                        success2 = this.paste();
                        break;
                    }
                    case -16: {
                        success2 = this.deletePreviousWord();
                        break;
                    }
                    case -43: {
                        success2 = this.previousWord();
                        break;
                    }
                    case -55: {
                        success2 = this.nextWord();
                        break;
                    }
                    case -61: {
                        success2 = this.history.moveToFirstEntry();
                        if (!success2) break;
                        this.setBuffer(this.history.current());
                        break;
                    }
                    case -62: {
                        success2 = this.history.moveToLastEntry();
                        if (!success2) break;
                        this.setBuffer(this.history.current());
                        break;
                    }
                    case -63: {
                        this.moveInternal(-this.buf.buffer.length());
                        this.killLine();
                        break;
                    }
                    case -48: {
                        this.buf.setOvertyping(!this.buf.isOvertyping());
                        break;
                    }
                    default: {
                        if (c != 0) {
                            ActionListener action = (ActionListener)this.triggeredActions.get(new Character((char)c));
                            if (action != null) {
                                action.actionPerformed(null);
                                break;
                            }
                            this.putChar(c, true);
                            break;
                        }
                        success2 = false;
                    }
                }
                if (!success2) {
                    this.beep();
                }
                this.flushConsole();
            }
        }
        finally {
            this.terminal.afterReadLine(this, this.prompt, mask);
        }
    }

    private String readLine(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int i;
        while ((i = in.read()) != -1 && i != 10 && i != 13) {
            buf.append((char)i);
        }
        return buf.toString();
    }

    private int[] readBinding() throws IOException {
        int c = this.readVirtualKey();
        if (c == -1) {
            return null;
        }
        int code = this.keybindings[c];
        if (debugger != null) {
            ConsoleReader.debug("    translated: " + c + ": " + code);
        }
        return new int[]{c, code};
    }

    private final boolean moveHistory(boolean next2) throws IOException {
        if (next2 && !this.history.next()) {
            return false;
        }
        if (!next2 && !this.history.previous()) {
            return false;
        }
        this.setBuffer(this.history.current());
        return true;
    }

    public boolean paste() throws IOException {
        Clipboard clipboard;
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            return false;
        }
        if (clipboard == null) {
            return false;
        }
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return false;
        }
        try {
            String value2;
            Object content = transferable.getTransferData(DataFlavor.plainTextFlavor);
            if (content == null) {
                try {
                    content = new DataFlavor().getReaderForText(transferable);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (content == null) {
                return false;
            }
            if (content instanceof Reader) {
                value2 = "";
                String line = null;
                BufferedReader read2 = new BufferedReader((Reader)content);
                while ((line = read2.readLine()) != null) {
                    if (value2.length() > 0) {
                        value2 = value2 + "\n";
                    }
                    value2 = value2 + line;
                }
            } else {
                value2 = content.toString();
            }
            if (value2 == null) {
                return true;
            }
            this.putString(value2);
            return true;
        }
        catch (UnsupportedFlavorException ufe) {
            if (debugger != null) {
                ConsoleReader.debug(ufe + "");
            }
            return false;
        }
    }

    public boolean killLine() throws IOException {
        int cp = this.buf.cursor;
        int len = this.buf.buffer.length();
        if (cp >= len) {
            return false;
        }
        int num = this.buf.buffer.length() - cp;
        this.clearAhead(num);
        for (int i = 0; i < num; ++i) {
            this.buf.buffer.deleteCharAt(len - i - 1);
        }
        return true;
    }

    public boolean clearScreen() throws IOException {
        if (!this.terminal.isANSISupported()) {
            return false;
        }
        this.printString("\u001b[2J");
        this.flushConsole();
        this.printString("\u001b[1;1H");
        this.flushConsole();
        this.redrawLine();
        return true;
    }

    private final boolean complete() throws IOException {
        Completor comp;
        if (this.completors.size() == 0) {
            return false;
        }
        LinkedList candidates = new LinkedList();
        String bufstr = this.buf.buffer.toString();
        int cursor = this.buf.cursor;
        int position = -1;
        Iterator i = this.completors.iterator();
        while (i.hasNext() && (position = (comp = (Completor)i.next()).complete(bufstr, cursor, candidates)) == -1) {
        }
        if (candidates.size() == 0) {
            return false;
        }
        return this.completionHandler.complete(this, candidates, position);
    }

    public CursorBuffer getCursorBuffer() {
        return this.buf;
    }

    public void printColumns(Collection stuff) throws IOException {
        if (stuff == null || stuff.size() == 0) {
            return;
        }
        int width = this.getTermwidth();
        int maxwidth = 0;
        Iterator i = stuff.iterator();
        while (i.hasNext()) {
            maxwidth = Math.max(maxwidth, i.next().toString().length());
        }
        StringBuffer line = new StringBuffer();
        int showLines = this.usePagination ? this.getTermheight() - 1 : Integer.MAX_VALUE;
        Iterator i2 = stuff.iterator();
        while (i2.hasNext()) {
            String cur = (String)i2.next();
            if (line.length() + maxwidth > width) {
                this.printString(line.toString().trim());
                this.printNewline();
                line.setLength(0);
                if (--showLines == 0) {
                    this.printString(loc.getString("display-more"));
                    this.flushConsole();
                    int c = this.readVirtualKey();
                    if (c == 13 || c == 10) {
                        showLines = 1;
                    } else if (c != 113) {
                        showLines = this.getTermheight() - 1;
                    }
                    this.back(loc.getString("display-more").length());
                    if (c == 113) break;
                }
            }
            this.pad(cur, maxwidth + 3, line);
        }
        if (line.length() > 0) {
            this.printString(line.toString().trim());
            this.printNewline();
            line.setLength(0);
        }
    }

    private final void pad(String toPad, int len, StringBuffer appendTo) {
        appendTo.append(toPad);
        for (int i = 0; i < len - toPad.length(); ++i) {
            appendTo.append(' ');
        }
    }

    public boolean addCompletor(Completor completor) {
        return this.completors.add(completor);
    }

    public boolean removeCompletor(Completor completor) {
        return this.completors.remove(completor);
    }

    public Collection getCompletors() {
        return Collections.unmodifiableList(this.completors);
    }

    final boolean resetLine() throws IOException {
        if (this.buf.cursor == 0) {
            return false;
        }
        this.backspaceAll();
        return true;
    }

    public final boolean setCursorPosition(int position) throws IOException {
        return this.moveCursor(position - this.buf.cursor) != 0;
    }

    private final void setBuffer(String buffer) throws IOException {
        if (buffer.equals(this.buf.buffer.toString())) {
            return;
        }
        int sameIndex = 0;
        int l1 = buffer.length();
        int l2 = this.buf.buffer.length();
        for (int i = 0; i < l1 && i < l2 && buffer.charAt(i) == this.buf.buffer.charAt(i); ++i) {
            ++sameIndex;
        }
        int diff = this.buf.buffer.length() - sameIndex;
        this.backspace(diff);
        this.killLine();
        this.buf.buffer.setLength(sameIndex);
        this.putString(buffer.substring(sameIndex));
    }

    public final void redrawLine() throws IOException {
        this.printCharacter(13);
        this.flushConsole();
        this.drawLine();
    }

    public final void drawLine() throws IOException {
        if (this.prompt != null) {
            this.printString(this.prompt);
        }
        this.printString(this.buf.buffer.toString());
        if (this.buf.length() != this.buf.cursor) {
            this.back(this.buf.length() - this.buf.cursor);
        }
    }

    public final void printNewline() throws IOException {
        this.printString(CR);
        this.flushConsole();
    }

    final String finishBuffer() {
        String str = this.buf.buffer.toString();
        if (str.length() > 0) {
            if (this.mask == null && this.useHistory) {
                this.history.addToHistory(str);
            } else {
                this.mask = null;
            }
        }
        this.history.moveToEnd();
        this.buf.buffer.setLength(0);
        this.buf.cursor = 0;
        return str;
    }

    public final void putString(String str) throws IOException {
        this.buf.write(str);
        this.printString(str);
        this.drawBuffer();
    }

    public final void printString(String str) throws IOException {
        this.printCharacters(str.toCharArray());
    }

    private final void putChar(int c, boolean print2) throws IOException {
        this.buf.write((char)c);
        if (print2) {
            if (this.mask == null) {
                this.printCharacter(c);
            } else if (this.mask.charValue() != '\u0000') {
                this.printCharacter(this.mask.charValue());
            }
            this.drawBuffer();
        }
    }

    private final void drawBuffer(int clear2) throws IOException {
        char[] chars = this.buf.buffer.substring(this.buf.cursor).toCharArray();
        if (this.mask != null) {
            Arrays.fill(chars, this.mask.charValue());
        }
        this.printCharacters(chars);
        this.clearAhead(clear2);
        this.back(chars.length);
        this.flushConsole();
    }

    private final void drawBuffer() throws IOException {
        this.drawBuffer(0);
    }

    private final void clearAhead(int num) throws IOException {
        if (num == 0) {
            return;
        }
        this.printCharacters(' ', num);
        this.flushConsole();
        this.back(num);
        this.flushConsole();
    }

    private final void back(int num) throws IOException {
        this.printCharacters('\b', num);
        this.flushConsole();
    }

    public final void beep() throws IOException {
        if (!this.getBellEnabled()) {
            return;
        }
        this.printCharacter(7);
        this.flushConsole();
    }

    private final void printCharacter(int c) throws IOException {
        if (c == 9) {
            char[] cbuf = new char[4];
            Arrays.fill(cbuf, ' ');
            this.out.write(cbuf);
            return;
        }
        this.out.write(c);
    }

    private final void printCharacters(char[] c) throws IOException {
        char[] cbuf;
        int len = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\t') {
                len += 4;
                continue;
            }
            ++len;
        }
        if (len == c.length) {
            cbuf = c;
        } else {
            cbuf = new char[len];
            int pos2 = 0;
            for (int i = 0; i < c.length; ++i) {
                if (c[i] == '\t') {
                    Arrays.fill(cbuf, pos2, pos2 + 4, ' ');
                    pos2 += 4;
                    continue;
                }
                cbuf[pos2] = c[i];
                ++pos2;
            }
        }
        this.out.write(cbuf);
    }

    private final void printCharacters(char c, int num) throws IOException {
        if (num == 1) {
            this.printCharacter(c);
        } else {
            char[] chars = new char[num];
            Arrays.fill(chars, c);
            this.printCharacters(chars);
        }
    }

    public final void flushConsole() throws IOException {
        this.out.flush();
    }

    private final int backspaceAll() throws IOException {
        return this.backspace(Integer.MAX_VALUE);
    }

    private final int backspace(int num) throws IOException {
        if (this.buf.cursor == 0) {
            return 0;
        }
        int count2 = 0;
        count2 = this.moveCursor(-1 * num) * -1;
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + count2);
        this.drawBuffer(count2);
        return count2;
    }

    public final boolean backspace() throws IOException {
        return this.backspace(1) == 1;
    }

    private final boolean moveToEnd() throws IOException {
        if (this.moveCursor(1) == 0) {
            return false;
        }
        while (this.moveCursor(1) != 0) {
        }
        return true;
    }

    private final boolean deleteCurrentCharacter() throws IOException {
        boolean success2;
        boolean bl = success2 = this.buf.buffer.length() > 0;
        if (!success2) {
            return false;
        }
        if (this.buf.cursor == this.buf.buffer.length()) {
            return false;
        }
        this.buf.buffer.deleteCharAt(this.buf.cursor);
        this.drawBuffer(1);
        return true;
    }

    private final boolean previousWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        return true;
    }

    private final boolean nextWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.moveCursor(1) != 0) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.moveCursor(1) != 0) {
        }
        return true;
    }

    private final boolean deletePreviousWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.backspace()) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.backspace()) {
        }
        return true;
    }

    public final int moveCursor(int num) throws IOException {
        int where = num;
        if (this.buf.cursor == 0 && where < 0) {
            return 0;
        }
        if (this.buf.cursor == this.buf.buffer.length() && where > 0) {
            return 0;
        }
        if (this.buf.cursor + where < 0) {
            where = -this.buf.cursor;
        } else if (this.buf.cursor + where > this.buf.buffer.length()) {
            where = this.buf.buffer.length() - this.buf.cursor;
        }
        this.moveInternal(where);
        return where;
    }

    public static void debug(String str) {
        if (debugger != null) {
            debugger.println(str);
            debugger.flush();
        }
    }

    private final void moveInternal(int where) throws IOException {
        this.buf.cursor += where;
        if (where < 0) {
            int len = 0;
            for (int i = this.buf.cursor; i < this.buf.cursor - where; ++i) {
                if (this.buf.getBuffer().charAt(i) == '\t') {
                    len += 4;
                    continue;
                }
                ++len;
            }
            char[] cbuf = new char[len];
            Arrays.fill(cbuf, '\b');
            this.out.write(cbuf);
            return;
        }
        if (this.buf.cursor == 0) {
            return;
        }
        if (this.mask == null) {
            this.printCharacters(this.buf.buffer.substring(this.buf.cursor - where, this.buf.cursor).toCharArray());
            return;
        }
        char c = this.mask.charValue();
        if (NULL_MASK.equals(this.mask)) {
            return;
        }
        this.printCharacters(c, Math.abs(where));
    }

    public final int readVirtualKey() throws IOException {
        int c = this.terminal.readVirtualKey(this.in);
        if (debugger != null) {
            ConsoleReader.debug("keystroke: " + c + "");
        }
        this.clearEcho(c);
        return c;
    }

    public final int readCharacter(char[] allowed) throws IOException {
        char c;
        Arrays.sort(allowed);
        while (Arrays.binarySearch(allowed, c = (char)this.readVirtualKey()) < 0) {
        }
        return c;
    }

    private final int delete(int num) throws IOException {
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + 1);
        this.drawBuffer(1);
        return 1;
    }

    public final boolean replace(int num, String replacement) {
        this.buf.buffer.replace(this.buf.cursor - num, this.buf.cursor, replacement);
        try {
            this.moveCursor(-num);
            this.drawBuffer(Math.max(0, num - replacement.length()));
            this.moveCursor(replacement.length());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public final boolean delete() throws IOException {
        return this.delete(1) == 1;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public History getHistory() {
        return this.history;
    }

    public void setCompletionHandler(CompletionHandler completionHandler) {
        this.completionHandler = completionHandler;
    }

    public CompletionHandler getCompletionHandler() {
        return this.completionHandler;
    }

    public void setEchoCharacter(Character echoCharacter) {
        this.echoCharacter = echoCharacter;
    }

    public Character getEchoCharacter() {
        return this.echoCharacter;
    }

    private void consumeException(Throwable e) {
    }

    private boolean isDelimiter(char c) {
        return !Character.isLetterOrDigit(c);
    }

    public void setUseHistory(boolean useHistory) {
        this.useHistory = useHistory;
    }

    public boolean getUseHistory() {
        return this.useHistory;
    }

    public void setUsePagination(boolean usePagination) {
        this.usePagination = usePagination;
    }

    public boolean getUsePagination() {
        return this.usePagination;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TreeMap<String, Short> names2 = new TreeMap<String, Short>();
        names2.put("MOVE_TO_BEG", new Short(-1));
        names2.put("MOVE_TO_END", new Short(-3));
        names2.put("PREV_CHAR", new Short(-4));
        names2.put("NEWLINE", new Short(-6));
        names2.put("KILL_LINE", new Short(-7));
        names2.put("PASTE", new Short(-60));
        names2.put("CLEAR_SCREEN", new Short(-8));
        names2.put("NEXT_HISTORY", new Short(-9));
        names2.put("PREV_HISTORY", new Short(-11));
        names2.put("START_OF_HISTORY", new Short(-61));
        names2.put("END_OF_HISTORY", new Short(-62));
        names2.put("REDISPLAY", new Short(-13));
        names2.put("KILL_LINE_PREV", new Short(-15));
        names2.put("DELETE_PREV_WORD", new Short(-16));
        names2.put("NEXT_CHAR", new Short(-19));
        names2.put("REPEAT_PREV_CHAR", new Short(-20));
        names2.put("SEARCH_PREV", new Short(-21));
        names2.put("REPEAT_NEXT_CHAR", new Short(-24));
        names2.put("SEARCH_NEXT", new Short(-25));
        names2.put("PREV_SPACE_WORD", new Short(-27));
        names2.put("TO_END_WORD", new Short(-29));
        names2.put("REPEAT_SEARCH_PREV", new Short(-34));
        names2.put("PASTE_PREV", new Short(-36));
        names2.put("REPLACE_MODE", new Short(-37));
        names2.put("SUBSTITUTE_LINE", new Short(-38));
        names2.put("TO_PREV_CHAR", new Short(-39));
        names2.put("NEXT_SPACE_WORD", new Short(-40));
        names2.put("DELETE_PREV_CHAR", new Short(-41));
        names2.put("ADD", new Short(-42));
        names2.put("PREV_WORD", new Short(-43));
        names2.put("CHANGE_META", new Short(-44));
        names2.put("DELETE_META", new Short(-45));
        names2.put("END_WORD", new Short(-46));
        names2.put("NEXT_CHAR", new Short(-19));
        names2.put("INSERT", new Short(-48));
        names2.put("REPEAT_SEARCH_NEXT", new Short(-49));
        names2.put("PASTE_NEXT", new Short(-50));
        names2.put("REPLACE_CHAR", new Short(-51));
        names2.put("SUBSTITUTE_CHAR", new Short(-52));
        names2.put("TO_NEXT_CHAR", new Short(-53));
        names2.put("UNDO", new Short(-54));
        names2.put("NEXT_WORD", new Short(-55));
        names2.put("DELETE_NEXT_CHAR", new Short(-56));
        names2.put("CHANGE_CASE", new Short(-57));
        names2.put("COMPLETE", new Short(-58));
        names2.put("EXIT", new Short(-59));
        names2.put("CLEAR_LINE", new Short(-63));
        KEYMAP_NAMES = new TreeMap(Collections.unmodifiableMap(names2));
        NULL_MASK = new Character('\u0000');
    }
}

