/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import [Lcom.sun.jna.Pointer;;
import [Lcom.sun.jna.Structure;;
import [Lcom.sun.jna.WString;;
import [Ljava.lang.String;;
import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.FunctionParameterContext;
import com.sun.jna.FunctionResultContext;
import com.sun.jna.Memory;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

public class Function
extends Pointer {
    public static final int MAX_NARGS = 256;
    public static final int C_CONVENTION = 0;
    public static final int ALT_CONVENTION = 1;
    private NativeLibrary library;
    private String functionName;
    private int callingConvention;
    static final String OPTION_INVOKING_METHOD = "invoking-method";
    static /* synthetic */ Class array$Lcom$sun$jna$Structure$ByReference;

    public static Function getFunction(String libraryName, String functionName) {
        return NativeLibrary.getInstance(libraryName).getFunction(functionName);
    }

    public static Function getFunction(String libraryName, String functionName, int callConvention) {
        return NativeLibrary.getInstance(libraryName).getFunction(functionName, callConvention);
    }

    Function(NativeLibrary library, String functionName, int callingConvention) {
        this.checkCallingConvention(callingConvention);
        if (functionName == null) {
            throw new NullPointerException("Function name must not be null");
        }
        this.library = library;
        this.functionName = functionName;
        this.callingConvention = callingConvention;
        try {
            this.peer = library.getSymbolAddress(functionName);
        }
        catch (UnsatisfiedLinkError e) {
            throw new UnsatisfiedLinkError("Error looking up function '" + functionName + "': " + e.getMessage());
        }
    }

    Function(Pointer functionAddress, int callingConvention) {
        this.checkCallingConvention(callingConvention);
        if (functionAddress == null || functionAddress.peer == 0L) {
            throw new NullPointerException("Function address may not be null");
        }
        this.functionName = functionAddress.toString();
        this.callingConvention = callingConvention;
        this.peer = functionAddress.peer;
    }

    private void checkCallingConvention(int convention) throws IllegalArgumentException {
        switch (convention) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized calling convention: " + convention);
            }
        }
    }

    public String getName() {
        return this.functionName;
    }

    public int getCallingConvention() {
        return this.callingConvention;
    }

    public Object invoke(Class returnType, Object[] inArgs) {
        return this.invoke(returnType, inArgs, Collections.EMPTY_MAP);
    }

    public Object invoke(Class returnType, Object[] inArgs, Map options2) {
        Object[] args2 = new Object[]{};
        if (inArgs != null) {
            if (inArgs.length > 256) {
                throw new UnsupportedOperationException("Maximum argument count is 256");
            }
            args2 = new Object[inArgs.length];
            System.arraycopy(inArgs, 0, args2, 0, args2.length);
        }
        TypeMapper mapper = (TypeMapper)options2.get("type-mapper");
        Method invokingMethod = (Method)options2.get(OPTION_INVOKING_METHOD);
        for (int i = 0; i < args2.length; ++i) {
            args2[i] = this.convertArgument(args2, i, invokingMethod, mapper);
        }
        Class nativeType = returnType;
        FromNativeConverter resultConverter = null;
        if (NativeMapped.class.isAssignableFrom(returnType)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(returnType);
            resultConverter = tc;
            nativeType = tc.nativeType();
        } else if (mapper != null && (resultConverter = mapper.getFromNativeConverter(returnType)) != null) {
            nativeType = resultConverter.nativeType();
        }
        Object result = this.invoke(args2, nativeType);
        if (resultConverter != null) {
            FunctionResultContext context = invokingMethod != null ? new MethodResultContext(returnType, this, inArgs, invokingMethod) : new FunctionResultContext(returnType, this, inArgs);
            result = resultConverter.fromNative(result, context);
        }
        if (inArgs != null) {
            for (int i = 0; i < inArgs.length; ++i) {
                Object inArg = inArgs[i];
                if (inArg == null) continue;
                if (inArg instanceof Structure) {
                    if (inArg instanceof Structure.ByValue) continue;
                    ((Structure)inArg).read();
                    continue;
                }
                if (args2[i] instanceof PostCallRead) {
                    ((PostCallRead)args2[i]).read();
                    if (!(args2[i] instanceof PointerArray)) continue;
                    PointerArray array = (PointerArray)args2[i];
                    if (!(array$Lcom$sun$jna$Structure$ByReference == null ? Function.class$("[Lcom.sun.jna.Structure$ByReference;") : array$Lcom$sun$jna$Structure$ByReference).isAssignableFrom(inArg.getClass())) continue;
                    Class<?> type2 = inArg.getClass().getComponentType();
                    Structure[] ss = (Structure[])inArg;
                    for (int si = 0; si < ss.length; ++si) {
                        Pointer p2 = array.getPointer(Pointer.SIZE * si);
                        ss[si] = Structure.updateStructureByReference(type2, ss[si], p2);
                    }
                    continue;
                }
                if (!(array$Lcom$sun$jna$Structure == null ? Function.class$("[Lcom.sun.jna.Structure;") : array$Lcom$sun$jna$Structure).isAssignableFrom(inArg.getClass())) continue;
                Structure[] ss = (Structure[])inArg;
                for (int si = 0; si < ss.length; ++si) {
                    ss[si].read();
                }
            }
        }
        return result;
    }

    Object invoke(Object[] args2, Class returnType) {
        Object result = null;
        if (returnType == null || returnType == Void.TYPE || returnType == Void.class) {
            this.invokeVoid(this.callingConvention, args2);
            result = null;
        } else if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            result = Function.valueOf(this.invokeInt(this.callingConvention, args2) != 0);
        } else if (returnType == Byte.TYPE || returnType == Byte.class) {
            result = new Byte((byte)this.invokeInt(this.callingConvention, args2));
        } else if (returnType == Short.TYPE || returnType == Short.class) {
            result = new Short((short)this.invokeInt(this.callingConvention, args2));
        } else if (returnType == Character.TYPE || returnType == Character.class) {
            result = new Character((char)this.invokeInt(this.callingConvention, args2));
        } else if (returnType == Integer.TYPE || returnType == Integer.class) {
            result = new Integer(this.invokeInt(this.callingConvention, args2));
        } else if (returnType == Long.TYPE || returnType == Long.class) {
            result = new Long(this.invokeLong(this.callingConvention, args2));
        } else if (returnType == Float.TYPE || returnType == Float.class) {
            result = new Float(this.invokeFloat(this.callingConvention, args2));
        } else if (returnType == Double.TYPE || returnType == Double.class) {
            result = new Double(this.invokeDouble(this.callingConvention, args2));
        } else if (returnType == String.class) {
            result = this.invokeString(this.callingConvention, args2, false);
        } else if (returnType == WString.class) {
            String s = this.invokeString(this.callingConvention, args2, true);
            result = s != null ? new WString(s) : null;
        } else if (Pointer.class.isAssignableFrom(returnType)) {
            result = this.invokePointer(this.callingConvention, args2);
        } else if (Structure.class.isAssignableFrom(returnType)) {
            if (Structure.ByValue.class.isAssignableFrom(returnType)) {
                Structure s = this.invokeStructure(this.callingConvention, args2, Structure.newInstance(returnType));
                s.read();
                result = s;
            } else {
                result = this.invokePointer(this.callingConvention, args2);
                if (result != null) {
                    Structure s = Structure.newInstance(returnType);
                    s.useMemory((Pointer)result);
                    s.read();
                    result = s;
                }
            }
        } else if (Callback.class.isAssignableFrom(returnType)) {
            result = this.invokePointer(this.callingConvention, args2);
            if (result != null) {
                result = CallbackReference.getCallback(returnType, (Pointer)result);
            }
        } else {
            throw new IllegalArgumentException("Unsupported return type " + returnType + " in function " + this.getName());
        }
        return result;
    }

    private Object convertArgument(Object[] args2, int index2, Method invokingMethod, TypeMapper mapper) {
        Object arg2 = args2[index2];
        if (arg2 != null) {
            Class<?> type2 = arg2.getClass();
            ToNativeConverter converter = null;
            if (NativeMapped.class.isAssignableFrom(type2)) {
                converter = NativeMappedConverter.getInstance(type2);
            } else if (mapper != null) {
                converter = mapper.getToNativeConverter(type2);
            }
            if (converter != null) {
                FunctionParameterContext context = invokingMethod != null ? new MethodParameterContext(this, args2, index2, invokingMethod) : new FunctionParameterContext(this, args2, index2);
                arg2 = converter.toNative(arg2, context);
            }
        }
        if (arg2 == null || this.isPrimitiveArray(arg2.getClass())) {
            return arg2;
        }
        Class<?> argClass = arg2.getClass();
        if (arg2 instanceof Structure) {
            Structure struct = (Structure)arg2;
            struct.write();
            if (struct instanceof Structure.ByValue) {
                return struct;
            }
            return struct.getPointer();
        }
        if (arg2 instanceof Callback) {
            return CallbackReference.getFunctionPointer((Callback)arg2);
        }
        if (arg2 instanceof String) {
            return new NativeString((String)arg2, false).getPointer();
        }
        if (arg2 instanceof WString) {
            return new NativeString(arg2.toString(), true).getPointer();
        }
        if (arg2 instanceof Boolean) {
            return new Integer(Boolean.TRUE.equals(arg2) ? -1 : 0);
        }
        if (String;.class == argClass) {
            return new StringArray((String[])arg2);
        }
        if (WString;.class == argClass) {
            return new StringArray((WString[])arg2);
        }
        if (Pointer;.class == argClass) {
            return new PointerArray((Pointer[])arg2);
        }
        if (Structure;.class.isAssignableFrom(argClass)) {
            Class<?> type3;
            Structure[] ss = (Structure[])arg2;
            boolean byRef = Structure.ByReference.class.isAssignableFrom(type3 = argClass.getComponentType());
            if (byRef) {
                Pointer[] pointers = new Pointer[ss.length + 1];
                for (int i = 0; i < ss.length; ++i) {
                    pointers[i] = ss[i].getPointer();
                }
                return new PointerArray(pointers);
            }
            if (ss.length == 0) {
                throw new IllegalArgumentException("Structure array must have non-zero length");
            }
            if (ss[0] == null) {
                Structure struct = Structure.newInstance(type3);
                int size2 = struct.size();
                Memory m = new Memory(size2 * ss.length);
                struct.useMemory(m);
                Structure[] tmp = struct.toArray(ss.length);
                for (int si = 0; si < ss.length; ++si) {
                    ss[si] = tmp[si];
                }
                return ss[0].getPointer();
            }
            Pointer base = ss[0].getPointer();
            int size3 = ss[0].size();
            ss[0].write();
            for (int si = 1; si < ss.length; ++si) {
                if (ss[si].getPointer().peer != base.peer + (long)(size3 * si)) {
                    String msg = "Structure array elements must use contiguous memory (at element index " + si + ")";
                    throw new IllegalArgumentException(msg);
                }
                ss[si].write();
            }
            return base;
        }
        if (argClass.isArray()) {
            throw new IllegalArgumentException("Unsupported array argument type: " + argClass.getComponentType());
        }
        if (arg2 != null && !Native.isSupportedNativeType(arg2.getClass())) {
            throw new IllegalArgumentException("Unsupported argument type " + arg2.getClass().getName() + " at parameter " + index2 + " of function " + this.getName());
        }
        return arg2;
    }

    private boolean isPrimitiveArray(Class argClass) {
        return argClass.isArray() && argClass.getComponentType().isPrimitive();
    }

    private native int invokeInt(int var1, Object[] var2);

    private native long invokeLong(int var1, Object[] var2);

    public void invoke(Object[] args2) {
        this.invoke(Void.class, args2);
    }

    private native void invokeVoid(int var1, Object[] var2);

    private native float invokeFloat(int var1, Object[] var2);

    private native double invokeDouble(int var1, Object[] var2);

    private String invokeString(int callingConvention, Object[] args2, boolean wide) {
        Pointer ptr = this.invokePointer(callingConvention, args2);
        String s = null;
        if (ptr != null) {
            s = wide ? ptr.getString(0L, wide) : ptr.getString(0L);
        }
        return s;
    }

    private native Pointer invokePointer(int var1, Object[] var2);

    private native Structure invokeStructure(int var1, Object[] var2, Structure var3);

    public String toString() {
        if (this.library != null) {
            return "native function " + this.functionName + "(" + this.library.getName() + ")@0x" + Long.toHexString(this.peer);
        }
        return "native function@0x" + Long.toHexString(this.peer);
    }

    public Pointer invokePointer(Object[] args2) {
        return (Pointer)this.invoke(Pointer.class, args2);
    }

    public String invokeString(Object[] args2, boolean wide) {
        Class clazz = wide ? WString.class : String.class;
        Object o = this.invoke(clazz, args2);
        return o != null ? o.toString() : null;
    }

    public int invokeInt(Object[] args2) {
        return (Integer)this.invoke(Integer.class, args2);
    }

    public long invokeLong(Object[] args2) {
        return (Long)this.invoke(Long.class, args2);
    }

    public float invokeFloat(Object[] args2) {
        return ((Float)this.invoke(Float.class, args2)).floatValue();
    }

    public double invokeDouble(Object[] args2) {
        return (Double)this.invoke(Double.class, args2);
    }

    public void invokeVoid(Object[] args2) {
        this.invoke(Void.class, args2);
    }

    public boolean equals(Object o) {
        if (o instanceof Function) {
            Function other = (Function)o;
            return other.callingConvention == this.callingConvention && other.peer == this.peer;
        }
        return false;
    }

    static Object[] concatenateVarArgs(Object[] inArgs) {
        if (inArgs != null && inArgs.length > 0) {
            Class<?> argType;
            Object lastArg = inArgs[inArgs.length - 1];
            Class<?> clazz = argType = lastArg != null ? lastArg.getClass() : null;
            if (argType != null && argType.isArray()) {
                Object[] varArgs = (Object[])lastArg;
                Object[] fullArgs = new Object[inArgs.length + varArgs.length];
                System.arraycopy(inArgs, 0, fullArgs, 0, inArgs.length - 1);
                System.arraycopy(varArgs, 0, fullArgs, inArgs.length - 1, varArgs.length);
                fullArgs[fullArgs.length - 1] = null;
                inArgs = fullArgs;
            }
        }
        return inArgs;
    }

    static boolean isVarArgs(Method m) {
        try {
            Method v = m.getClass().getMethod("isVarArgs", new Class[0]);
            return Boolean.TRUE.equals(v.invoke((Object)m, new Object[0]));
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    static Boolean valueOf(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    private static class PointerArray
    extends Memory
    implements PostCallRead {
        private Pointer[] original;

        public PointerArray(Pointer[] arg2) {
            super(Pointer.SIZE * (arg2.length + 1));
            this.original = arg2;
            for (int i = 0; i < arg2.length; ++i) {
                this.setPointer(i * Pointer.SIZE, arg2[i]);
            }
            this.setPointer(Pointer.SIZE * arg2.length, null);
        }

        public void read() {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i] = this.getPointer(i * Pointer.SIZE);
            }
        }
    }

    public static interface PostCallRead {
        public void read();
    }
}

