/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.builtin.IRubyObject;

public class ShellLauncher {
    private static final Pattern PATH_SEPARATORS = Pattern.compile("[/\\\\]");
    private Ruby runtime;

    public ShellLauncher(Ruby runtime) {
        this.runtime = runtime;
    }

    private String[] getCurrentEnv() {
        RubyHash hash = (RubyHash)this.runtime.getObject().getConstant("ENV");
        String[] ret = new String[hash.size()];
        int i = 0;
        for (Map.Entry e : hash.directEntrySet()) {
            ret[i] = e.getKey().toString() + "=" + e.getValue().toString();
            ++i;
        }
        return ret;
    }

    public int runAndWait(IRubyObject[] rawArgs) {
        return this.runAndWait(rawArgs, this.runtime.getOutputStream());
    }

    public int runAndWait(IRubyObject[] rawArgs, OutputStream output) {
        PrintStream error = this.runtime.getErrorStream();
        InputStream input = this.runtime.getInputStream();
        try {
            Process aProcess = this.run(rawArgs);
            this.handleStreams(aProcess, input, output, error);
            return aProcess.waitFor();
        }
        catch (IOException e) {
            throw this.runtime.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw this.runtime.newThreadError("unexpected interrupt");
        }
    }

    public Process run(IRubyObject string) throws IOException {
        return this.run(new IRubyObject[]{string});
    }

    public Process run(IRubyObject[] rawArgs) throws IOException {
        String shell = this.runtime.evalScript("require 'rbconfig'; Config::CONFIG['SHELL']").toString();
        rawArgs[0] = this.runtime.newString(this.repairDirSeps(rawArgs[0].toString()));
        Process aProcess = null;
        File pwd = new File(this.runtime.getCurrentDirectory());
        if (this.shouldRunInProcess(rawArgs[0].toString())) {
            int startIndex;
            List args = this.parseCommandLine(rawArgs);
            String command = (String)args.get(0);
            int n = startIndex = command.endsWith(".rb") ? 0 : 1;
            if (command.trim().endsWith("irb")) {
                startIndex = 0;
                args.set(0, this.runtime.getJRubyHome() + File.separator + "bin" + File.separator + "jirb");
            }
            String[] argArray = args.subList(startIndex, args.size()).toArray(new String[0]);
            ScriptThreadProcess ipScript = new ScriptThreadProcess(argArray, this.getCurrentEnv(), pwd);
            ipScript.start();
            aProcess = ipScript;
        } else if (shell != null && rawArgs.length == 1) {
            String shellSwitch = shell.endsWith("sh") ? "-c" : "/c";
            String[] argArray = new String[]{shell, shellSwitch, rawArgs[0].toString()};
            aProcess = Runtime.getRuntime().exec(argArray, this.getCurrentEnv(), pwd);
        } else if (rawArgs.length > 1) {
            String[] argArray = new String[rawArgs.length];
            for (int i = 0; i < rawArgs.length; ++i) {
                argArray[i] = rawArgs[i].toString();
            }
            aProcess = Runtime.getRuntime().exec(argArray, this.getCurrentEnv(), pwd);
        } else {
            aProcess = Runtime.getRuntime().exec(rawArgs[0].toString(), this.getCurrentEnv(), pwd);
        }
        return aProcess;
    }

    private void handleStreams(Process p, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p.getInputStream();
        InputStream pErr = p.getErrorStream();
        OutputStream pIn = p.getOutputStream();
        StreamCopier t1 = new StreamCopier(pOut, out, false);
        StreamCopier t2 = new StreamCopier(pErr, err, false);
        StreamCopier t3 = new StreamCopier(in, pIn, true);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        t3.quit();
        try {
            err.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            pIn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            pOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            pErr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String repairDirSeps(String command) {
        String[] tokens;
        String executable = "";
        String remainder = "";
        if ((command = command.trim()).startsWith("'")) {
            tokens = command.split("'", 3);
            executable = "'" + tokens[1] + "'";
            if (tokens.length > 2) {
                remainder = tokens[2];
            }
        } else if (command.startsWith("\"")) {
            tokens = command.split("\"", 3);
            executable = "\"" + tokens[1] + "\"";
            if (tokens.length > 2) {
                remainder = tokens[2];
            }
        } else {
            tokens = command.split(" ", 2);
            executable = tokens[0];
            if (tokens.length > 1) {
                remainder = " " + tokens[1];
            }
        }
        String replacement = File.separator;
        if (File.separatorChar == '\\') {
            replacement = "\\\\";
        }
        return PATH_SEPARATORS.matcher(executable).replaceAll(replacement) + remainder;
    }

    private List parseCommandLine(IRubyObject[] rawArgs) {
        String command = rawArgs[0].toString();
        Stack<String> args = new Stack<String>();
        StringTokenizer st = new StringTokenizer(command, " ");
        String quoteChar = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (quoteChar == null) {
                if (token.startsWith("'") || token.startsWith("\"")) {
                    quoteChar = token.substring(0, 1);
                    token = token.substring(1);
                }
                if (quoteChar != null && token.endsWith(quoteChar)) {
                    token = token.substring(0, token.length() - 1);
                    quoteChar = null;
                }
                args.push(token);
                continue;
            }
            if (token.endsWith(quoteChar)) {
                token = token.substring(0, token.length() - 1);
                quoteChar = null;
            }
            token = args.pop() + " " + token;
            args.push(token);
        }
        for (int i = 1; i < rawArgs.length; ++i) {
            args.push(rawArgs[i].toString());
        }
        return args;
    }

    private boolean shouldRunInProcess(String command) {
        String[] spaceDelimitedTokens = (command = command.trim()).split(" ", 2);
        String[] slashDelimitedTokens = spaceDelimitedTokens[0].split("/");
        String finalToken = slashDelimitedTokens[slashDelimitedTokens.length - 1];
        return finalToken.indexOf("ruby") != -1 || finalToken.endsWith(".rb") || finalToken.endsWith("irb");
    }

    private static class StreamCopier
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private boolean onlyIfAvailable;
        private boolean quit;

        StreamCopier(InputStream in, OutputStream out, boolean avail) {
            this.in = in;
            this.out = out;
            this.onlyIfAvailable = avail;
        }

        @Override
        public void run() {
            byte[] buf = new byte[128];
            try {
                while (!this.quit) {
                    Thread.sleep(10L);
                    if (this.onlyIfAvailable && this.in.available() == 0) continue;
                    int numRead = this.in.read(buf);
                    if (numRead != -1) {
                        this.out.write(buf, 0, numRead);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void quit() {
            this.quit = true;
        }
    }

    private static class ScriptThreadProcess
    extends Process
    implements Runnable {
        private String[] argArray;
        private int result;
        private RubyInstanceConfig config;
        private Thread processThread;
        private PipedInputStream processOutput = new PipedInputStream();
        private PipedInputStream processError = new PipedInputStream();
        private PipedOutputStream processInput = new PipedOutputStream();
        private final String[] env;
        private final File pwd;

        public ScriptThreadProcess(String[] argArray, String[] env, File dir) {
            this.argArray = argArray;
            this.env = env;
            this.pwd = dir;
        }

        @Override
        public void run() {
            this.result = new Main(this.config).run(this.argArray);
            this.config.getOutput().close();
            this.config.getError().close();
        }

        private Map environmentMap(String[] env) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < env.length; ++i) {
                String[] kv = env[i].split("=", 2);
                m.put(kv[0], kv[1]);
            }
            return m;
        }

        public void start() throws IOException {
            this.config = new RubyInstanceConfig(){
                {
                    this.setInput(new PipedInputStream(processInput));
                    this.setOutput(new PrintStream(new PipedOutputStream(processOutput)));
                    this.setError(new PrintStream(new PipedOutputStream(processError)));
                    this.setEnvironment(this.environmentMap(env));
                    this.setCurrentDirectory(pwd.toString());
                }
            };
            this.processThread = new Thread((Runnable)this, "ScriptThreadProcess: " + this.argArray[0]);
            this.processThread.start();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.processInput;
        }

        @Override
        public InputStream getInputStream() {
            return this.processOutput;
        }

        @Override
        public InputStream getErrorStream() {
            return this.processError;
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.closeStreams();
            this.processThread.join();
            return this.result;
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public void destroy() {
            this.closeStreams();
            this.processThread.interrupt();
        }

        private void closeStreams() {
            try {
                this.processInput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.processOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.processError.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

