/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.Writer;
import org.jruby.runtime.builtin.IRubyObject;

public class IOWriter
extends Writer {
    private IRubyObject io;

    public IOWriter(IRubyObject io) {
        if (!io.respondsTo("write")) {
            throw new IllegalArgumentException("Object: " + io + " is not a legal argument to this wrapper, cause it doesn't respond to \"write\".");
        }
        this.io = io;
    }

    @Override
    public void close() throws IOException {
        this.io.callMethod(this.io.getRuntime().getCurrentContext(), "close");
    }

    @Override
    public void flush() throws IOException {
        this.io.callMethod(this.io.getRuntime().getCurrentContext(), "flush");
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.io.callMethod(this.io.getRuntime().getCurrentContext(), "write", this.io.getRuntime().newString(String.valueOf(cbuf, off, len)));
    }
}

