/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.util.ArrayList;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.VCallNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;

public class LocalStaticScope
extends StaticScope {
    private static final long serialVersionUID = 2204064248888411628L;

    public LocalStaticScope(StaticScope enclosingScope) {
        super(enclosingScope);
        this.addVariable("$~");
        this.addVariable("$_");
    }

    public LocalStaticScope(StaticScope enclosingScope, String[] names) {
        super(enclosingScope, names);
    }

    @Override
    public StaticScope getLocalScope() {
        return this;
    }

    @Override
    public int isDefined(String name, int depth) {
        return depth << 16 | this.exists(name);
    }

    @Override
    public String[] getAllNamesInScope(DynamicScope dynamicScope) {
        String[] variables = this.getVariables();
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 2; i < variables.length; ++i) {
            if (dynamicScope.getValue(i, 0) == null) continue;
            resultList.add(variables[i]);
        }
        int localNamesSize = resultList.size();
        String[] names = new String[localNamesSize];
        resultList.toArray(names);
        return names;
    }

    @Override
    public AssignableNode assign(ISourcePosition position, String name, Node value, StaticScope topScope, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            return new LocalAsgnNode(position, name, depth << 16 | slot, value);
        }
        if (topScope == this) {
            slot = this.addVariable(name);
            return new LocalAsgnNode(position, name, slot, value);
        }
        return ((BlockStaticScope)topScope).addAssign(position, name, value);
    }

    @Override
    public Node declare(ISourcePosition position, String name, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            return new LocalVarNode(position, depth << 16 | slot, name);
        }
        return new VCallNode(position, name);
    }
}

