/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class SimpleCallbackMethod
extends DynamicMethod {
    private Callback callback;

    public SimpleCallbackMethod(RubyModule implementationClass, Callback callback, Visibility visibility) {
        super(implementationClass, visibility);
        this.callback = callback;
    }

    @Override
    public void preMethod(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
    }

    @Override
    public void postMethod(ThreadContext context) {
    }

    @Override
    public IRubyObject internalCall(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        assert (false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, boolean noSuper, Block block) {
        assert (args != null);
        Ruby runtime = context.getRuntime();
        if (runtime.hasEventHooks()) {
            ISourcePosition position = context.getPosition();
            runtime.callEventHooks(context, 5, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
            try {
                IRubyObject iRubyObject = this.callback.execute(self, args, Block.NULL_BLOCK);
                return iRubyObject;
            }
            finally {
                runtime.callEventHooks(context, 6, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
            }
        }
        return this.callback.execute(self, args, Block.NULL_BLOCK);
    }

    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public Arity getArity() {
        return this.getCallback().getArity();
    }

    @Override
    public DynamicMethod dup() {
        return new SimpleCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }
}

