/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ProcMethod
extends DynamicMethod {
    private RubyProc proc;

    public ProcMethod(RubyModule implementationClass, RubyProc proc, Visibility visibility) {
        super(implementationClass, visibility);
        this.proc = proc;
    }

    @Override
    public void preMethod(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        context.preMethodCall(this.implementationClass, klazz, self, name, args, this.getArity().required(), block, noSuper, this);
    }

    @Override
    public void postMethod(ThreadContext context) {
        context.postMethodCall();
    }

    @Override
    public IRubyObject internalCall(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        return this.proc.call(args, self, Block.NULL_BLOCK);
    }

    @Override
    public DynamicMethod dup() {
        return new ProcMethod(this.getImplementationClass(), this.proc, this.getVisibility());
    }

    @Override
    public Arity getArity() {
        return this.proc.getBlock().arity();
    }
}

