/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public abstract class CompiledMethod
extends DynamicMethod
implements Cloneable {
    private Arity arity;
    private SinglyLinkedList cref;
    private StaticScope staticScope;

    public CompiledMethod(RubyModule implementationClass, Arity arity, Visibility visibility, SinglyLinkedList cref, StaticScope staticScope) {
        super(implementationClass, visibility);
        this.arity = arity;
        this.cref = cref;
        this.staticScope = staticScope;
    }

    @Override
    public void preMethod(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
    }

    @Override
    public void postMethod(ThreadContext context) {
    }

    @Override
    public IRubyObject internalCall(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        assert (false);
        return null;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, boolean noSuper, Block block) {
        try {
            context.preDefMethodInternalCall(klazz, name, self, args, this.arity.required(), block, noSuper, this.cref, this.staticScope, this);
            IRubyObject iRubyObject = this.call(context, self, args, block);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump && je.getTarget() == this) {
                IRubyObject iRubyObject = (IRubyObject)je.getValue();
                return iRubyObject;
            }
            throw je;
        }
        finally {
            context.postDefMethodInternalCall();
        }
    }

    protected abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3, Block var4);

    @Override
    public DynamicMethod dup() {
        try {
            CompiledMethod msm = (CompiledMethod)this.clone();
            return msm;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }
}

