/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.environment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.environment.IOSEnvironmentReader;
import org.jruby.environment.OSEnvironment;

class OSEnvironmentReaderFromRuntimeExec
implements IOSEnvironmentReader {
    private final OSEnvironment environmentReader = new OSEnvironment();

    OSEnvironmentReaderFromRuntimeExec() {
    }

    @Override
    public boolean isAccessible(Ruby runtime) {
        return true;
    }

    private String getEnvCommand() {
        String osname = System.getProperty("os.name").toLowerCase();
        String command = osname.indexOf("windows 9") > -1 ? "command.com /c set" : (osname.indexOf("nt") > -1 || osname.indexOf("windows 20") > -1 || osname.indexOf("windows xp") > -1 ? "cmd.exe /c set" : "env");
        return command;
    }

    @Override
    public Map getVariables(Ruby runtime) {
        try {
            Process process = Runtime.getRuntime().exec(this.getEnvCommand());
            return this.environmentReader.getVariablesFrom(new BufferedReader(new InputStreamReader(process.getInputStream())));
        }
        catch (IOException e) {
            this.environmentReader.handleException(e);
            return null;
        }
    }
}

