/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.demo;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.io.PipedInputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.demo.TextAreaReadline;
import org.jruby.runtime.builtin.IRubyObject;

public class IRBApplet
extends Applet {
    private static final long serialVersionUID = 3746242973444417387L;

    @Override
    public void start() {
        super.start();
        final PipedInputStream pipeIn = new PipedInputStream();
        this.setLayout(new BorderLayout());
        JTextPane text = new JTextPane();
        text.setMargin(new Insets(8, 8, 8, 8));
        text.setCaretColor(new Color(164, 0, 0));
        text.setBackground(new Color(242, 242, 242));
        text.setForeground(new Color(164, 0, 0));
        Font font = this.findFont("Monospaced", 0, 14, new String[]{"Monaco", "Andale Mono"});
        text.setFont(font);
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(text);
        pane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.add(pane);
        this.validate();
        final TextAreaReadline tar = new TextAreaReadline(text, " Welcome to JRuby for the Web! \n\n");
        RubyInstanceConfig config = new RubyInstanceConfig(){
            {
                this.setInput(pipeIn);
                this.setOutput(new PrintStream(tar));
                this.setError(new PrintStream(tar));
                this.setObjectSpaceEnabled(false);
            }
        };
        Ruby.setSecurityRestricted(true);
        final Ruby runtime = Ruby.newInstance(config);
        runtime.defineGlobalConstant("ARGV", runtime.newArrayNoCopy(new IRubyObject[]{runtime.newString("-f")}));
        runtime.getLoadService().init(new ArrayList(0));
        tar.hookIntoRuntime(runtime);
        Thread t2 = new Thread(){

            @Override
            public void run() {
                runtime.evalScript("require 'irb'; require 'irb/completion'; IRB.start");
            }
        };
        t2.start();
    }

    private Font findFont(String otherwise, int style, int size, String[] families) {
        Object[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(fonts);
        Font font = null;
        for (int i = 0; i < families.length; ++i) {
            if (Arrays.binarySearch(fonts, families[i]) < 0) continue;
            font = new Font(families[i], style, size);
            break;
        }
        if (font == null) {
            font = new Font(otherwise, style, size);
        }
        return font;
    }
}

