/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.IfNode;
import org.jruby.ast.Node;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;

public class IfNodeCompiler
implements NodeCompiler {
    @Override
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        final IfNode ifNode = (IfNode)node;
        NodeCompilerFactory.getCompiler(ifNode.getCondition()).compile(ifNode.getCondition(), context);
        BranchCallback trueCallback = new BranchCallback(){

            @Override
            public void branch(Compiler context) {
                if (ifNode.getThenBody() != null) {
                    NodeCompilerFactory.getCompiler(ifNode.getThenBody()).compile(ifNode.getThenBody(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        BranchCallback falseCallback = new BranchCallback(){

            @Override
            public void branch(Compiler context) {
                if (ifNode.getElseBody() != null) {
                    NodeCompilerFactory.getCompiler(ifNode.getElseBody()).compile(ifNode.getElseBody(), context);
                } else {
                    context.loadNil();
                }
            }
        };
        context.performBooleanBranch(trueCallback, falseCallback);
    }
}

