/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.common;

import org.jruby.Ruby;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyWarnings
implements IRubyWarnings {
    private Ruby runtime;

    public RubyWarnings(Ruby runtime) {
        this.runtime = runtime;
    }

    @Override
    public void warn(ISourcePosition position, String message) {
        assert (position != null);
        if (this.runtime.getVerbose().isNil()) {
            return;
        }
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(position.getFile()).append(':').append(position.getEndLine()).append(' ');
        buffer.append("warning: ").append(message).append('\n');
        IRubyObject errorStream = this.runtime.getGlobalVariables().get("$stderr");
        errorStream.callMethod(this.runtime.getCurrentContext(), "write", this.runtime.newString(buffer.toString()));
    }

    @Override
    public boolean isVerbose() {
        return this.runtime.getVerbose().isTrue();
    }

    @Override
    public void warn(String message) {
        this.warn(this.runtime.getCurrentContext().getPosition(), message);
    }

    @Override
    public void warning(String message) {
        this.warning(this.runtime.getCurrentContext().getPosition(), message);
    }

    @Override
    public void warning(ISourcePosition position, String message) {
        if (this.isVerbose()) {
            this.warn(position, message);
        }
    }
}

