/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class UntilNode
extends Node {
    static final long serialVersionUID = -2929327250252365636L;
    private final Node conditionNode;
    private final Node bodyNode;
    private final boolean evaluateAtStart;

    public UntilNode(ISourcePosition position, Node conditionNode, Node bodyNode) {
        this(position, conditionNode, bodyNode, true);
    }

    public UntilNode(ISourcePosition position, Node conditionNode, Node bodyNode, boolean evaluateAtStart) {
        super(position, 90);
        this.conditionNode = conditionNode;
        this.bodyNode = bodyNode;
        this.evaluateAtStart = evaluateAtStart;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitUntilNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getConditionNode() {
        return this.conditionNode;
    }

    @Override
    public List childNodes() {
        return Node.createList(this.conditionNode, this.bodyNode);
    }

    public boolean evaluateAtStart() {
        return this.evaluateAtStart;
    }
}

