/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.IdUtil;
import org.jruby.util.collections.SinglyLinkedList;

public class RubyObject
implements Cloneable,
IRubyObject {
    public static final IRubyObject NEVER = new RubyObject();
    protected RubyClass metaClass;
    protected Map instanceVariables;
    private transient Object dataStruct;
    private boolean frozen;
    private boolean taint;
    protected boolean isTrue = true;
    private Finalizer finalizer;
    public static ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyObject instance = new RubyObject(runtime, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    private RubyObject() {
    }

    public RubyObject(Ruby runtime, RubyClass metaClass) {
        this(runtime, metaClass, runtime.isObjectSpaceEnabled());
    }

    public RubyObject(Ruby runtime, RubyClass metaClass, boolean useObjectSpace) {
        this.metaClass = metaClass;
        this.frozen = false;
        this.taint = false;
        if (useObjectSpace && !this.isImmediate()) {
            runtime.getObjectSpace().add(this);
        }
        this.taint |= runtime.getSafeLevel() >= 3;
    }

    public static RubyClass createObjectClass(Ruby runtime, RubyClass objectClass) {
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyObject.class);
        objectClass.index = 14;
        objectClass.definePrivateMethod("initialize", callbackFactory.getOptMethod("initialize"));
        objectClass.definePrivateMethod("inherited", callbackFactory.getMethod("inherited", IRubyObject.class));
        return objectClass;
    }

    public void attachToObjectSpace() {
        this.getRuntime().getObjectSpace().add(this);
    }

    @Override
    public int getNativeTypeIndex() {
        return 14;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public RubyClass makeMetaClass(RubyClass superClass, SinglyLinkedList parentCRef) {
        MetaClass klass = new MetaClass(this.getRuntime(), superClass, this.getMetaClass().getAllocator(), parentCRef);
        this.setMetaClass(klass);
        klass.setInstanceVariable("__attached__", this);
        if (this instanceof RubyClass && this.isSingleton()) {
            klass.setMetaClass(klass);
            klass.setSuperClass(((RubyClass)this).getSuperClass().getRealClass().getMetaClass());
        } else {
            klass.setMetaClass(superClass.getRealClass().getMetaClass());
        }
        klass.index = superClass.index;
        return klass;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Class getJavaClass() {
        return IRubyObject.class;
    }

    public static void puts(Object obj) {
        System.out.println(obj.toString());
    }

    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && this.callMethod(this.getRuntime().getCurrentContext(), 9, "==", (IRubyObject)other).isTrue();
    }

    public String toString() {
        return this.callMethod(this.getRuntime().getCurrentContext(), 14, "to_s", IRubyObject.NULL_ARRAY).toString();
    }

    @Override
    public Ruby getRuntime() {
        return this.metaClass.getRuntime();
    }

    @Override
    public boolean safeHasInstanceVariables() {
        return this.instanceVariables != null && this.instanceVariables.size() > 0;
    }

    @Override
    public Map safeGetInstanceVariables() {
        return this.instanceVariables == null ? null : this.getInstanceVariablesSnapshot();
    }

    public IRubyObject removeInstanceVariable(String name) {
        return (IRubyObject)this.getInstanceVariables().remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getInstanceVariablesSnapshot() {
        Map map = this.getInstanceVariables();
        synchronized (map) {
            return Collections.unmodifiableMap(new HashMap(this.getInstanceVariables()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getInstanceVariables() {
        if (this.instanceVariables == null) {
            RubyObject rubyObject = this;
            synchronized (rubyObject) {
                if (this.instanceVariables == null) {
                    this.instanceVariables = Collections.synchronizedMap(new HashMap());
                }
            }
        }
        return this.instanceVariables;
    }

    @Override
    public void setInstanceVariables(Map instanceVariables) {
        this.instanceVariables = Collections.synchronizedMap(instanceVariables);
    }

    @Override
    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    @Override
    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    protected void testFrozen(String message) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(message + this.getMetaClass().getName());
        }
    }

    protected void checkFrozen() {
        this.testFrozen("can't modify frozen ");
    }

    @Override
    public boolean isTaint() {
        return this.taint;
    }

    @Override
    public void setTaint(boolean taint) {
        this.taint = taint;
    }

    @Override
    public boolean isNil() {
        return false;
    }

    @Override
    public final boolean isTrue() {
        return this.isTrue;
    }

    public final boolean isFalse() {
        return !this.isTrue;
    }

    @Override
    public boolean respondsTo(String name) {
        if (this.getMetaClass().searchMethod("respond_to?") == this.getRuntime().getRespondToMethod()) {
            return this.getMetaClass().isMethodBound(name, false);
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "respond_to?", this.getRuntime().newSymbol(name)).isTrue();
    }

    @Override
    public boolean isKindOf(RubyModule type) {
        return this.getMetaClass().hasModuleInHierarchy(type);
    }

    @Override
    public RubyClass getSingletonClass() {
        RubyClass klass = this.getMetaClass().isSingleton() && this.getMetaClass().getInstanceVariable("__attached__") == this ? this.getMetaClass() : this.makeMetaClass(this.getMetaClass(), this.getMetaClass().getCRef());
        klass.setTaint(this.isTaint());
        klass.setFrozen(this.isFrozen());
        return klass;
    }

    public RubyClass getSingletonClassClone() {
        RubyClass klass = this.getMetaClass();
        if (!klass.isSingleton()) {
            return klass;
        }
        MetaClass clone = new MetaClass(this.getRuntime(), klass.getSuperClass(), this.getMetaClass().getAllocator(), this.getMetaClass().getCRef());
        clone.setFrozen(klass.isFrozen());
        clone.setTaint(klass.isTaint());
        if (this instanceof RubyClass) {
            clone.setMetaClass(clone);
        } else {
            clone.setMetaClass(klass.getSingletonClassClone());
        }
        if (klass.safeHasInstanceVariables()) {
            clone.setInstanceVariables(new HashMap(klass.getInstanceVariables()));
        }
        klass.cloneMethods(clone);
        clone.getMetaClass().setInstanceVariable("__attached__", clone);
        return clone;
    }

    public static void initCopy(IRubyObject clone, IRubyObject original) {
        assert (original != null);
        assert (!clone.isFrozen()) : "frozen object (" + clone.getMetaClass().getName() + ") allocated";
        if (original.safeHasInstanceVariables()) {
            clone.setInstanceVariables(new HashMap(original.getInstanceVariables()));
        }
        clone.callMethod(clone.getRuntime().getCurrentContext(), "initialize_copy", original);
    }

    @Override
    public IRubyObject infectBy(IRubyObject obj) {
        this.setTaint(this.isTaint() || obj.isTaint());
        return this;
    }

    @Override
    public IRubyObject callSuper(ThreadContext context, IRubyObject[] args, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        RubyClass superClass = klazz.getSuperClass();
        assert (superClass != null) : "Superclass should always be something for " + klazz.getBaseName();
        return this.callMethod(context, (RubyModule)superClass, context.getFrameName(), args, CallType.SUPER, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args, Block block) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, CallType.FUNCTIONAL, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args, CallType callType) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, callType, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject[] args, CallType callType, Block block) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, args, callType, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, int methodIndex, String name, IRubyObject arg) {
        return this.callMethod(context, this.getMetaClass(), methodIndex, name, new IRubyObject[]{arg}, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, int methodIndex, String name, IRubyObject[] args) {
        return this.callMethod(context, this.getMetaClass(), methodIndex, name, args, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, int methodIndex, String name, IRubyObject[] args, CallType callType) {
        return this.callMethod(context, this.getMetaClass(), methodIndex, name, args, callType, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject compilerCallMethodWithIndex(ThreadContext context, int methodIndex, String name, IRubyObject[] args, IRubyObject self, CallType callType, Block block) {
        RubyClass module = this.getMetaClass();
        if (module.index != 0) {
            return this.callMethod(context, module, methodIndex, name, args, callType, block);
        }
        return this.compilerCallMethod(context, name, args, self, callType, block);
    }

    @Override
    public IRubyObject compilerCallMethod(ThreadContext context, String name, IRubyObject[] args, IRubyObject self, CallType callType, Block block) {
        assert (args != null);
        DynamicMethod method = null;
        RubyClass rubyclass = this.getMetaClass();
        method = rubyclass.searchMethod(name);
        IRubyObject mmResult = RubyObject.callMethodMissingIfNecessary(context, this, method, name, args, self, callType, block);
        if (mmResult != null) {
            return mmResult;
        }
        return method.call(context, this, rubyclass, name, args, false, block);
    }

    public static IRubyObject callMethodMissingIfNecessary(ThreadContext context, IRubyObject receiver, DynamicMethod method, String name, IRubyObject[] args, IRubyObject self, CallType callType, Block block) {
        if (method.isUndefined() || !name.equals("method_missing") && !method.isCallableFrom(self, callType)) {
            context.setLastCallStatus(callType);
            context.setLastVisibility(method.getVisibility());
            if (name.equals("method_missing")) {
                return RubyKernel.method_missing(self, args, block);
            }
            IRubyObject[] newArgs = new IRubyObject[args.length + 1];
            System.arraycopy(args, 0, newArgs, 1, args.length);
            newArgs[0] = RubySymbol.newSymbol(self.getRuntime(), name);
            return receiver.callMethod(context, "method_missing", newArgs, block);
        }
        return null;
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType) {
        return this.callMethod(context, rubyclass, methodIndex, name, args, callType, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        return this.callMethod(context, rubyclass, name, args, callType, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, String name, IRubyObject[] args, CallType callType, Block block) {
        assert (args != null);
        DynamicMethod method = null;
        method = rubyclass.searchMethod(name);
        IRubyObject mmResult = RubyObject.callMethodMissingIfNecessary(context, this, method, name, args, context.getFrameSelf(), callType, block);
        if (mmResult != null) {
            return mmResult;
        }
        return method.call(context, this, rubyclass, name, args, false, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, IRubyObject.NULL_ARRAY, null, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, int methodIndex, String name) {
        return this.callMethod(context, this.getMetaClass(), methodIndex, name, IRubyObject.NULL_ARRAY, null, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, Block block) {
        return this.callMethod(context, (RubyModule)this.getMetaClass(), name, IRubyObject.NULL_ARRAY, null, block);
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, String name, IRubyObject arg) {
        return this.callMethod(context, name, new IRubyObject[]{arg});
    }

    public IRubyObject instance_variable_get(IRubyObject var) {
        String varName = var.asSymbol();
        if (!IdUtil.isInstanceVariable(varName)) {
            throw this.getRuntime().newNameError("`" + varName + "' is not allowable as an instance variable name", varName);
        }
        IRubyObject variable = this.getInstanceVariable(varName);
        return variable == null ? this.getRuntime().getNil() : variable;
    }

    @Override
    public IRubyObject getInstanceVariable(String name) {
        return (IRubyObject)this.getInstanceVariables().get(name);
    }

    public IRubyObject instance_variable_set(IRubyObject var, IRubyObject value) {
        String varName = var.asSymbol();
        if (!IdUtil.isInstanceVariable(varName)) {
            throw this.getRuntime().newNameError("`" + varName + "' is not allowable as an instance variable name", varName);
        }
        return this.setInstanceVariable(var.asSymbol(), value);
    }

    public IRubyObject setInstanceVariable(String name, IRubyObject value, String taintError, String freezeError) {
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError(taintError);
        }
        this.testFrozen(freezeError);
        this.getInstanceVariables().put(name, value);
        return value;
    }

    @Override
    public IRubyObject setInstanceVariable(String name, IRubyObject value) {
        return this.setInstanceVariable(name, value, "Insecure: can't modify instance variable", "");
    }

    @Override
    public Iterator instanceVariableNames() {
        return this.getInstanceVariables().keySet().iterator();
    }

    public void callInit(IRubyObject[] args, Block block) {
        this.callMethod(this.getRuntime().getCurrentContext(), "initialize", args, block);
    }

    @Override
    public String asSymbol() {
        throw this.getRuntime().newTypeError(this.inspect().toString() + " is not a symbol");
    }

    public static String trueFalseNil(IRubyObject v) {
        return RubyObject.trueFalseNil(v.getMetaClass().getName());
    }

    public static String trueFalseNil(String v) {
        if ("TrueClass".equals(v)) {
            return "true";
        }
        if ("FalseClass".equals(v)) {
            return "false";
        }
        if ("NilClass".equals(v)) {
            return "nil";
        }
        return v;
    }

    @Override
    public RubyArray convertToArray() {
        return (RubyArray)this.convertToType(this.getRuntime().getArray(), 18, true);
    }

    @Override
    public RubyHash convertToHash() {
        return (RubyHash)this.convertToType(this.getRuntime().getHash(), 34, "to_hash", true, true, false);
    }

    @Override
    public RubyFloat convertToFloat() {
        return (RubyFloat)this.convertToType(this.getRuntime().getClass("Float"), 20, true);
    }

    @Override
    public RubyInteger convertToInteger() {
        return (RubyInteger)this.convertToType(this.getRuntime().getClass("Integer"), 19, true);
    }

    @Override
    public RubyString convertToString() {
        return (RubyString)this.convertToType(this.getRuntime().getString(), 17, true);
    }

    @Override
    public IRubyObject convertToTypeWithCheck(RubyClass targetType, int convertMethodIndex, String convertMethod) {
        return this.convertToType(targetType, convertMethodIndex, convertMethod, false, true, false);
    }

    @Override
    public IRubyObject convertToType(RubyClass targetType, int convertMethodIndex, String convertMethod, boolean raise) {
        return this.convertToType(targetType, convertMethodIndex, convertMethod, raise, false, false);
    }

    public IRubyObject convertToType(RubyClass targetType, int convertMethodIndex, boolean raise) {
        return this.convertToType(targetType, convertMethodIndex, MethodIndex.NAMES[convertMethodIndex], raise, false, false);
    }

    @Override
    public IRubyObject convertToType(RubyClass targetType, int convertMethodIndex, String convertMethod, boolean raiseOnMissingMethod, boolean raiseOnWrongTypeResult, boolean allowNilThrough) {
        if (this.isKindOf(targetType)) {
            return this;
        }
        if (!this.respondsTo(convertMethod)) {
            if (raiseOnMissingMethod) {
                throw this.getRuntime().newTypeError("can't convert " + RubyObject.trueFalseNil(this) + " into " + RubyObject.trueFalseNil(targetType.getName()));
            }
            return this.getRuntime().getNil();
        }
        IRubyObject value = this.callMethod(this.getRuntime().getCurrentContext(), convertMethodIndex, convertMethod, IRubyObject.NULL_ARRAY);
        if (allowNilThrough && value.isNil()) {
            return value;
        }
        if (raiseOnWrongTypeResult && !value.isKindOf(targetType)) {
            throw this.getRuntime().newTypeError(this.getMetaClass().getName() + "#" + convertMethod + " should return " + targetType);
        }
        return value;
    }

    @Override
    public RubyString asString() {
        if (this instanceof RubyString) {
            return (RubyString)this;
        }
        IRubyObject str = this.callMethod(this.getRuntime().getCurrentContext(), 14, "to_s", IRubyObject.NULL_ARRAY);
        if (!(str instanceof RubyString)) {
            str = this.anyToString();
        }
        return (RubyString)str;
    }

    @Override
    public IRubyObject checkStringType() {
        IRubyObject str = this.convertToTypeWithCheck(this.getRuntime().getString(), 17, "to_str");
        if (!str.isNil() && !(str instanceof RubyString)) {
            str = this.getRuntime().newString("");
        }
        return str;
    }

    @Override
    public IRubyObject checkArrayType() {
        return this.convertToTypeWithCheck(this.getRuntime().getArray(), 18, "to_ary");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject specificEval(RubyModule mod, IRubyObject[] args, Block block) {
        if (block.isGiven()) {
            if (args.length > 0) {
                throw this.getRuntime().newArgumentError(args.length, 0);
            }
            return this.yieldUnder(mod, new IRubyObject[]{this}, block);
        }
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (args.length == 0) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        if (args.length > 3) {
            String lastFuncName = tc.getFrameName();
            throw this.getRuntime().newArgumentError("wrong # of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        args[0].convertToString();
        IRubyObject file = args.length > 1 ? args[1] : this.getRuntime().newString("(eval)");
        IRubyObject line = args.length > 2 ? args[2] : RubyFixnum.one(this.getRuntime());
        Visibility savedVisibility = tc.getCurrentVisibility();
        tc.setCurrentVisibility(Visibility.PUBLIC);
        try {
            IRubyObject iRubyObject = this.evalUnder(mod, args[0], file, line);
            return iRubyObject;
        }
        finally {
            tc.setCurrentVisibility(savedVisibility);
        }
    }

    public IRubyObject evalUnder(RubyModule under, IRubyObject src, IRubyObject file, IRubyObject line) {
        return under.executeUnder(new Callback(){

            @Override
            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                IRubyObject source = args[1];
                IRubyObject filename = args[2];
                return args[0].evalSimple(source.getRuntime().getCurrentContext(), source, filename.convertToString().toString());
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        }, new IRubyObject[]{this, src, file, line}, Block.NULL_BLOCK);
    }

    private IRubyObject yieldUnder(RubyModule under, IRubyObject[] args, Block block) {
        final RubyObject selfInYield = this;
        return under.executeUnder(new Callback(){

            @Override
            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                ThreadContext context = RubyObject.this.getRuntime().getCurrentContext();
                Visibility savedVisibility = block.getVisibility();
                block.setVisibility(Visibility.PUBLIC);
                try {
                    boolean aValue;
                    IRubyObject valueInYield;
                    if (args.length == 1) {
                        valueInYield = args[0];
                        aValue = false;
                    } else {
                        valueInYield = RubyArray.newArray(RubyObject.this.getRuntime(), args);
                        aValue = true;
                    }
                    IRubyObject iRubyObject = block.yield(context, valueInYield, selfInYield, context.getRubyClass(), aValue);
                    return iRubyObject;
                }
                catch (JumpException je) {
                    if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                        IRubyObject iRubyObject = (IRubyObject)je.getValue();
                        return iRubyObject;
                    }
                    throw je;
                }
                finally {
                    block.setVisibility(savedVisibility);
                }
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        }, args, block);
    }

    @Override
    public IRubyObject evalWithBinding(ThreadContext context, IRubyObject src, IRubyObject scope, String file, int lineNumber) {
        assert (!scope.isNil());
        assert (file != null);
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        ISourcePosition savedPosition = threadContext.getPosition();
        if (!(scope instanceof RubyBinding)) {
            if (scope instanceof RubyProc) {
                scope = ((RubyProc)scope).binding();
            } else {
                throw this.getRuntime().newTypeError("wrong argument type " + scope.getMetaClass() + " (expected Proc/Binding)");
            }
        }
        Block blockOfBinding = ((RubyBinding)scope).getBlock();
        try {
            threadContext.preEvalWithBinding(blockOfBinding);
            IRubyObject newSelf = threadContext.getFrameSelf();
            Node node = this.getRuntime().parse(src.toString(), file, blockOfBinding.getDynamicScope(), lineNumber);
            IRubyObject iRubyObject = EvaluationState.eval(this.getRuntime(), threadContext, node, newSelf, blockOfBinding);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                throw this.getRuntime().newLocalJumpError("break", (IRubyObject)je.getValue(), "unexpected break");
            }
            throw je;
        }
        finally {
            threadContext.postEvalWithBinding(blockOfBinding);
            threadContext.setPosition(savedPosition);
        }
    }

    @Override
    public IRubyObject evalSimple(ThreadContext context, IRubyObject src, String file) {
        assert (file != null);
        ISourcePosition savedPosition = context.getPosition();
        try {
            Node node = this.getRuntime().parse(src.toString(), file, context.getCurrentScope(), 0);
            IRubyObject iRubyObject = EvaluationState.eval(this.getRuntime(), context, node, this, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                throw this.getRuntime().newLocalJumpError("break", (IRubyObject)je.getValue(), "unexpected break");
            }
            throw je;
        }
        finally {
            context.setPosition(savedPosition);
        }
    }

    public IRubyObject obj_equal(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    public IRubyObject equal(IRubyObject other) {
        if (this == other || this.callMethod(this.getRuntime().getCurrentContext(), 9, "==", other).isTrue()) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @Override
    public final IRubyObject equalInternal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        return this.callMethod(context, 9, "==", other);
    }

    @Override
    public boolean eql(IRubyObject other) {
        return this.callMethod(this.getRuntime().getCurrentContext(), 33, "eql?", other).isTrue();
    }

    @Override
    public final boolean eqlInternal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return true;
        }
        return this.callMethod(context, 33, "eql?", other).isTrue();
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != original.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("initialize_copy should take same class object");
        }
        return this;
    }

    public RubyBoolean respond_to(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        String name = args[0].asSymbol();
        boolean includePrivate = args.length > 1 ? args[1].isTrue() : false;
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name, !includePrivate));
    }

    @Override
    public synchronized RubyFixnum id() {
        return this.getRuntime().newFixnum(this.getRuntime().getObjectSpace().idOf(this));
    }

    public synchronized RubyFixnum id_deprecated() {
        this.getRuntime().getWarnings().warn("Object#id will be deprecated; use Object#object_id");
        return this.getRuntime().newFixnum(this.getRuntime().getObjectSpace().idOf(this));
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(super.hashCode());
    }

    public int hashCode() {
        IRubyObject hashValue = this.callMethod(this.getRuntime().getCurrentContext(), 23, "hash");
        if (hashValue instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return super.hashCode();
    }

    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    public RubyClass type_deprecated() {
        this.getRuntime().getWarnings().warn("Object#type is deprecated; use Object#class");
        return this.type();
    }

    @Override
    public IRubyObject rbClone(Block unusedBlock) {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't clone " + this.getMetaClass().getName());
        }
        IRubyObject clone = this.doClone();
        clone.setMetaClass(this.getSingletonClassClone());
        clone.setTaint(this.isTaint());
        RubyObject.initCopy(clone, this);
        clone.setFrozen(this.isFrozen());
        return clone;
    }

    protected IRubyObject doClone() {
        RubyClass realClass = this.getMetaClass().getRealClass();
        return realClass.getAllocator().allocate(this.getRuntime(), realClass);
    }

    public IRubyObject display(IRubyObject[] args) {
        IRubyObject port = args.length == 0 ? this.getRuntime().getGlobalVariables().get("$>") : args[0];
        port.callMethod(this.getRuntime().getCurrentContext(), "write", this);
        return this.getRuntime().getNil();
    }

    @Override
    public IRubyObject dup() {
        if (this.isImmediate()) {
            throw this.getRuntime().newTypeError("can't dup " + this.getMetaClass().getName());
        }
        IRubyObject dup = this.doClone();
        dup.setMetaClass(this.type());
        dup.setFrozen(false);
        dup.setTaint(this.isTaint());
        RubyObject.initCopy(dup, this);
        return dup;
    }

    public RubyBoolean tainted() {
        return this.getRuntime().newBoolean(this.isTaint());
    }

    public IRubyObject taint() {
        this.getRuntime().secure(4);
        if (!this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(true);
        }
        return this;
    }

    public IRubyObject untaint() {
        this.getRuntime().secure(3);
        if (this.isTaint()) {
            this.testFrozen("object");
            this.setTaint(false);
        }
        return this;
    }

    public IRubyObject freeze() {
        if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't freeze object");
        }
        this.setFrozen(true);
        return this;
    }

    public RubyBoolean frozen() {
        return this.getRuntime().newBoolean(this.isFrozen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject inspect() {
        if (!this.isImmediate() && !(this instanceof RubyClass) && this != this.getRuntime().getObject() && this != this.getRuntime().getClass("Module") && !(this instanceof RubyModule) && this.safeHasInstanceVariables()) {
            StringBuffer part = new StringBuffer();
            String cname = this.getMetaClass().getRealClass().getName();
            part.append("#<").append(cname).append(":0x");
            part.append(Integer.toHexString(System.identityHashCode(this)));
            if (!this.getRuntime().registerInspecting(this)) {
                part.append(" ...>");
                return this.getRuntime().newString(part.toString());
            }
            try {
                String sep = "";
                Map iVars = this.getInstanceVariablesSnapshot();
                for (String name : iVars.keySet()) {
                    if (!IdUtil.isInstanceVariable(name)) continue;
                    part.append(sep);
                    part.append(" ");
                    part.append(name);
                    part.append("=");
                    part.append(((IRubyObject)iVars.get(name)).callMethod(this.getRuntime().getCurrentContext(), "inspect"));
                    sep = ",";
                }
                part.append(">");
                RubyString rubyString = this.getRuntime().newString(part.toString());
                return rubyString;
            }
            finally {
                this.getRuntime().unregisterInspecting(this);
            }
        }
        if (this.isNil()) {
            return RubyNil.inspect(this);
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), 14, "to_s", IRubyObject.NULL_ARRAY);
    }

    public RubyBoolean instance_of(IRubyObject type) {
        return this.getRuntime().newBoolean(this.type() == type);
    }

    public RubyArray instance_variables() {
        ArrayList<RubyString> names = new ArrayList<RubyString>();
        for (String name : this.getInstanceVariablesSnapshot().keySet()) {
            if (!IdUtil.isInstanceVariable(name)) continue;
            names.add(this.getRuntime().newString(name));
        }
        return this.getRuntime().newArray(names);
    }

    public RubyBoolean kind_of(IRubyObject type) {
        if (!type.isKindOf(this.getRuntime().getClass("Module"))) {
            throw this.getRuntime().newTypeError(type, this.getRuntime().getClass("Module"));
        }
        return this.getRuntime().newBoolean(this.isKindOf((RubyModule)type));
    }

    public IRubyObject methods(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getTrue()};
        }
        return this.getMetaClass().instance_methods(args);
    }

    public IRubyObject public_methods(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getTrue()};
        }
        return this.getMetaClass().public_instance_methods(args);
    }

    public IRubyObject protected_methods(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getTrue()};
        }
        return this.getMetaClass().protected_instance_methods(args);
    }

    public IRubyObject private_methods(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        if (args.length == 0) {
            args = new IRubyObject[]{this.getRuntime().getTrue()};
        }
        return this.getMetaClass().private_instance_methods(args);
    }

    public RubyArray singleton_methods(IRubyObject[] args) {
        boolean all = true;
        if (Arity.checkArgumentCount(this.getRuntime(), args, 0, 1) == 1) {
            all = args[0].isTrue();
        }
        RubyArray result = this.getRuntime().newArray();
        for (RubyClass type = this.getMetaClass(); type != null && (type instanceof MetaClass || all && type.isIncluded()); type = type.getSuperClass()) {
            for (Map.Entry entry : type.getMethods().entrySet()) {
                DynamicMethod method = (DynamicMethod)entry.getValue();
                if (method.getImplementationClass() != type && (!all || !type.isIncluded())) continue;
                RubyString methodName = this.getRuntime().newString((String)entry.getKey());
                if (!method.getVisibility().isPublic() || result.includes(methodName)) continue;
                result.append(methodName);
            }
        }
        return result;
    }

    public IRubyObject method(IRubyObject symbol) {
        return this.getMetaClass().newMethod(this, symbol.asSymbol(), true);
    }

    @Override
    public IRubyObject anyToString() {
        String cname = this.getMetaClass().getRealClass().getName();
        RubyString str = this.getRuntime().newString("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    public IRubyObject to_s() {
        return this.anyToString();
    }

    public IRubyObject instance_eval(IRubyObject[] args, Block block) {
        return this.specificEval(this.getSingletonClass(), args, block);
    }

    public IRubyObject instance_exec(IRubyObject[] args, Block block) {
        if (!block.isGiven()) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        return this.yieldUnder(this.getSingletonClass(), args, block);
    }

    public IRubyObject extend(IRubyObject[] args) {
        int i;
        Arity.checkArgumentCount(this.getRuntime(), args, 1, -1);
        for (i = 0; i < args.length; ++i) {
            IRubyObject obj = args[i];
            if (obj instanceof RubyModule && ((RubyModule)obj).isModule()) continue;
            throw this.getRuntime().newTypeError(obj, this.getRuntime().getClass("Module"));
        }
        for (i = 0; i < args.length; ++i) {
            args[i].callMethod(this.getRuntime().getCurrentContext(), "extend_object", this);
            args[i].callMethod(this.getRuntime().getCurrentContext(), "extended", this);
        }
        return this;
    }

    public IRubyObject inherited(IRubyObject arg, Block block) {
        return this.getRuntime().getNil();
    }

    public IRubyObject initialize(IRubyObject[] args, Block block) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 0);
        return this.getRuntime().getNil();
    }

    public IRubyObject send(IRubyObject[] args, Block block) {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("no method name given");
        }
        String name = args[0].asSymbol();
        IRubyObject[] newArgs = new IRubyObject[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return this.callMethod(this.getRuntime().getCurrentContext(), name, newArgs, CallType.FUNCTIONAL, block);
    }

    public IRubyObject nil_p() {
        return this.getRuntime().getFalse();
    }

    public IRubyObject match(IRubyObject arg) {
        return this.getRuntime().getFalse();
    }

    public IRubyObject remove_instance_variable(IRubyObject name, Block block) {
        String id = name.asSymbol();
        if (!IdUtil.isInstanceVariable(id)) {
            throw this.getRuntime().newNameError("wrong instance variable name " + id, id);
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove instance variable");
        }
        this.testFrozen("class/module");
        IRubyObject variable = this.removeInstanceVariable(id);
        if (variable != null) {
            return variable;
        }
        throw this.getRuntime().newNameError("instance variable " + id + " not defined", id);
    }

    @Override
    public RubyClass getType() {
        return this.type();
    }

    @Override
    public synchronized void dataWrapStruct(Object obj) {
        this.dataStruct = obj;
    }

    @Override
    public synchronized Object dataGetStruct() {
        return this.dataStruct;
    }

    @Override
    public void addFinalizer(RubyProc finalizer) {
        if (this.finalizer == null) {
            this.finalizer = new Finalizer(this.getRuntime().getObjectSpace().idOf(this));
            this.getRuntime().addFinalizer(this.finalizer);
        }
        this.finalizer.addFinalizer(finalizer);
    }

    @Override
    public void removeFinalizers() {
        if (this.finalizer != null) {
            this.finalizer.removeFinalizers();
            this.finalizer = null;
            this.getRuntime().removeFinalizer(this.finalizer);
        }
    }

    public class Finalizer {
        private long id;
        private List finalizers;
        private AtomicBoolean finalized;

        public Finalizer(long id) {
            this.id = id;
            this.finalized = new AtomicBoolean(false);
        }

        public void addFinalizer(RubyProc finalizer) {
            if (this.finalizers == null) {
                this.finalizers = new ArrayList();
            }
            this.finalizers.add(finalizer);
        }

        public void removeFinalizers() {
            this.finalizers = null;
        }

        public void finalize() {
            if (this.finalized.compareAndSet(false, true) && this.finalizers != null) {
                RubyFixnum idFixnum = RubyObject.this.getRuntime().newFixnum(this.id);
                for (int i = 0; i < this.finalizers.size(); ++i) {
                    ((RubyProc)this.finalizers.get(i)).call(new IRubyObject[]{idFixnum});
                }
            }
        }
    }
}

