/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNil
extends RubyObject {
    private final Ruby runtime;
    public static ObjectAllocator NIL_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return runtime.getNil();
        }
    };

    public RubyNil(Ruby runtime) {
        super(runtime, runtime.getNilClass());
        this.runtime = runtime;
        this.isTrue = false;
    }

    @Override
    public Ruby getRuntime() {
        return this.runtime;
    }

    public static RubyClass createNilClass(Ruby runtime) {
        RubyClass nilClass = runtime.defineClass("NilClass", runtime.getObject(), NIL_ALLOCATOR);
        nilClass.index = 5;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyNil.class);
        nilClass.defineFastMethod("type", callbackFactory.getFastSingletonMethod("type"));
        nilClass.defineFastMethod("to_i", callbackFactory.getFastSingletonMethod("to_i"));
        nilClass.defineFastMethod("to_s", callbackFactory.getFastSingletonMethod("to_s"));
        nilClass.defineFastMethod("to_a", callbackFactory.getFastSingletonMethod("to_a"));
        nilClass.defineFastMethod("to_f", callbackFactory.getFastSingletonMethod("to_f"));
        nilClass.defineFastMethod("inspect", callbackFactory.getFastSingletonMethod("inspect"));
        nilClass.defineFastMethod("&", callbackFactory.getFastSingletonMethod("op_and", RubyKernel.IRUBY_OBJECT));
        nilClass.defineFastMethod("|", callbackFactory.getFastSingletonMethod("op_or", RubyKernel.IRUBY_OBJECT));
        nilClass.defineFastMethod("^", callbackFactory.getFastSingletonMethod("op_xor", RubyKernel.IRUBY_OBJECT));
        nilClass.defineFastMethod("nil?", callbackFactory.getFastMethod("nil_p"));
        nilClass.defineFastMethod("id", callbackFactory.getFastSingletonMethod("id"));
        nilClass.defineFastMethod("taint", callbackFactory.getFastMethod("taint"));
        nilClass.defineFastMethod("freeze", callbackFactory.getFastMethod("freeze"));
        nilClass.getMetaClass().undefineMethod("new");
        return nilClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 5;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public boolean safeHasInstanceVariables() {
        return false;
    }

    public static RubyFixnum to_i(IRubyObject recv) {
        return RubyFixnum.zero(recv.getRuntime());
    }

    public static RubyFloat to_f(IRubyObject recv) {
        return RubyFloat.newFloat(recv.getRuntime(), 0.0);
    }

    public static RubyString to_s(IRubyObject recv) {
        return recv.getRuntime().newString("");
    }

    public static RubyArray to_a(IRubyObject recv) {
        return recv.getRuntime().newArray(0);
    }

    public static RubyString inspect(IRubyObject recv) {
        return recv.getRuntime().newString("nil");
    }

    public static RubyClass type(IRubyObject recv) {
        return recv.getRuntime().getClass("NilClass");
    }

    public static RubyBoolean op_and(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().getFalse();
    }

    public static RubyBoolean op_or(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().newBoolean(obj.isTrue());
    }

    public static RubyBoolean op_xor(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().newBoolean(obj.isTrue());
    }

    public static RubyFixnum id(IRubyObject recv) {
        return recv.getRuntime().newFixnum(4L);
    }

    @Override
    public boolean isNil() {
        return true;
    }

    @Override
    public IRubyObject freeze() {
        return this;
    }

    @Override
    public IRubyObject nil_p() {
        return this.getRuntime().getTrue();
    }

    @Override
    public IRubyObject taint() {
        return this;
    }

    @Override
    public RubyFixnum id() {
        return this.getRuntime().newFixnum(4L);
    }
}

