/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.IncludedModuleWrapper;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyUnboundMethod;
import org.jruby.RubyUndef;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.FullFunctionCallbackMethod;
import org.jruby.internal.runtime.methods.MethodMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.internal.runtime.methods.SimpleCallbackMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ClassProvider;
import org.jruby.util.IdUtil;
import org.jruby.util.collections.SinglyLinkedList;

public class RubyModule
extends RubyObject {
    private static final String CVAR_TAINT_ERROR = "Insecure: can't modify class variable";
    private static final String CVAR_FREEZE_ERROR = "class/module";
    private RubyClass superClass;
    public int index;
    public final int id;
    public SinglyLinkedList cref;
    private String classId;
    private Map methods = new HashMap();
    private transient List classProviders;
    static ObjectAllocator MODULE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return RubyModule.newModule(runtime, klass, null);
        }
    };
    public static final byte EQQ_SWITCHVALUE = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassProvider(ClassProvider provider) {
        Object object;
        if (this.classProviders == null) {
            object = this;
            synchronized (object) {
                if (this.classProviders == null) {
                    this.classProviders = Collections.synchronizedList(new ArrayList());
                }
            }
        }
        object = this.classProviders;
        synchronized (object) {
            if (!this.classProviders.contains(provider)) {
                this.classProviders.add(provider);
            }
        }
    }

    public void removeClassProvider(ClassProvider provider) {
        if (this.classProviders != null) {
            this.classProviders.remove(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyClass searchClassProviders(String name, RubyClass superClazz) {
        if (this.classProviders != null) {
            List list = this.classProviders;
            synchronized (list) {
                Iterator iter = this.classProviders.iterator();
                while (iter.hasNext()) {
                    RubyClass clazz = ((ClassProvider)iter.next()).defineClassUnder(this, name, superClazz);
                    if (clazz == null) continue;
                    return clazz;
                }
            }
        }
        return null;
    }

    protected RubyModule(Ruby runtime, RubyClass metaClass, RubyClass superClass, SinglyLinkedList parentCRef, String name) {
        super(runtime, metaClass);
        this.superClass = superClass;
        this.setBaseName(name);
        if (parentCRef == null && runtime.getObject() != null) {
            parentCRef = runtime.getObject().getCRef();
        }
        this.cref = new SinglyLinkedList(this, parentCRef);
        ++runtime.moduleLastId;
        this.id = runtime.moduleLastId;
    }

    public static RubyClass createModuleClass(Ruby runtime, RubyClass moduleClass) {
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyModule.class);
        RubyClass moduleMetaClass = moduleClass.getMetaClass();
        moduleClass.index = 12;
        moduleClass.defineFastMethod("===", callbackFactory.getFastMethod("op_eqq", IRubyObject.class));
        moduleClass.defineFastMethod("<=>", callbackFactory.getFastMethod("op_cmp", IRubyObject.class));
        moduleClass.defineFastMethod("<", callbackFactory.getFastMethod("op_lt", IRubyObject.class));
        moduleClass.defineFastMethod("<=", callbackFactory.getFastMethod("op_le", IRubyObject.class));
        moduleClass.defineFastMethod(">", callbackFactory.getFastMethod("op_gt", IRubyObject.class));
        moduleClass.defineFastMethod(">=", callbackFactory.getFastMethod("op_ge", IRubyObject.class));
        moduleClass.defineFastMethod("ancestors", callbackFactory.getFastMethod("ancestors"));
        moduleClass.defineFastMethod("class_variables", callbackFactory.getFastMethod("class_variables"));
        moduleClass.defineFastMethod("const_defined?", callbackFactory.getFastMethod("const_defined", IRubyObject.class));
        moduleClass.defineFastMethod("const_get", callbackFactory.getFastMethod("const_get", IRubyObject.class));
        moduleClass.defineMethod("const_missing", callbackFactory.getMethod("const_missing", IRubyObject.class));
        moduleClass.defineFastMethod("const_set", callbackFactory.getFastMethod("const_set", IRubyObject.class, IRubyObject.class));
        moduleClass.defineFastMethod("constants", callbackFactory.getFastMethod("constants"));
        moduleClass.defineMethod("extended", callbackFactory.getMethod("extended", IRubyObject.class));
        moduleClass.defineFastMethod("include?", callbackFactory.getFastMethod("include_p", IRubyObject.class));
        moduleClass.defineFastMethod("included", callbackFactory.getFastMethod("included", IRubyObject.class));
        moduleClass.defineFastMethod("included_modules", callbackFactory.getFastMethod("included_modules"));
        moduleClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        moduleClass.defineFastMethod("initialize_copy", callbackFactory.getFastMethod("initialize_copy", IRubyObject.class));
        moduleClass.defineFastMethod("instance_method", callbackFactory.getFastMethod("instance_method", IRubyObject.class));
        moduleClass.defineFastMethod("instance_methods", callbackFactory.getFastOptMethod("instance_methods"));
        moduleClass.defineFastMethod("method_defined?", callbackFactory.getFastMethod("method_defined", IRubyObject.class));
        moduleClass.defineFastMethod("public_method_defined?", callbackFactory.getFastMethod("public_method_defined", IRubyObject.class));
        moduleClass.defineFastMethod("protected_method_defined?", callbackFactory.getFastMethod("protected_method_defined", IRubyObject.class));
        moduleClass.defineFastMethod("private_method_defined?", callbackFactory.getFastMethod("private_method_defined", IRubyObject.class));
        moduleClass.defineMethod("module_eval", callbackFactory.getOptMethod("module_eval"));
        moduleClass.defineFastMethod("name", callbackFactory.getFastMethod("name"));
        moduleClass.defineFastMethod("private_class_method", callbackFactory.getFastOptMethod("private_class_method"));
        moduleClass.defineFastMethod("private_instance_methods", callbackFactory.getFastOptMethod("private_instance_methods"));
        moduleClass.defineFastMethod("protected_instance_methods", callbackFactory.getFastOptMethod("protected_instance_methods"));
        moduleClass.defineFastMethod("public_class_method", callbackFactory.getFastOptMethod("public_class_method"));
        moduleClass.defineFastMethod("public_instance_methods", callbackFactory.getFastOptMethod("public_instance_methods"));
        moduleClass.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        moduleClass.defineAlias("class_eval", "module_eval");
        moduleClass.defineFastPrivateMethod("alias_method", callbackFactory.getFastMethod("alias_method", IRubyObject.class, IRubyObject.class));
        moduleClass.defineFastPrivateMethod("append_features", callbackFactory.getFastMethod("append_features", IRubyObject.class));
        moduleClass.defineFastPrivateMethod("attr", callbackFactory.getFastOptMethod("attr"));
        moduleClass.defineFastPrivateMethod("attr_reader", callbackFactory.getFastOptMethod("attr_reader"));
        moduleClass.defineFastPrivateMethod("attr_writer", callbackFactory.getFastOptMethod("attr_writer"));
        moduleClass.defineFastPrivateMethod("attr_accessor", callbackFactory.getFastOptMethod("attr_accessor"));
        moduleClass.defineFastPrivateMethod("class_variable_get", callbackFactory.getFastMethod("class_variable_get", IRubyObject.class));
        moduleClass.defineFastPrivateMethod("class_variable_set", callbackFactory.getFastMethod("class_variable_set", IRubyObject.class, IRubyObject.class));
        moduleClass.definePrivateMethod("define_method", callbackFactory.getOptMethod("define_method"));
        moduleClass.defineFastPrivateMethod("extend_object", callbackFactory.getFastMethod("extend_object", IRubyObject.class));
        moduleClass.defineFastPrivateMethod("include", callbackFactory.getFastOptMethod("include"));
        moduleClass.definePrivateMethod("method_added", callbackFactory.getMethod("method_added", IRubyObject.class));
        moduleClass.definePrivateMethod("method_removed", callbackFactory.getMethod("method_removed", IRubyObject.class));
        moduleClass.definePrivateMethod("method_undefined", callbackFactory.getMethod("method_undefined", IRubyObject.class));
        moduleClass.defineFastPrivateMethod("module_function", callbackFactory.getFastOptMethod("module_function"));
        moduleClass.defineFastPrivateMethod("public", callbackFactory.getFastOptMethod("rbPublic"));
        moduleClass.defineFastPrivateMethod("protected", callbackFactory.getFastOptMethod("rbProtected"));
        moduleClass.defineFastPrivateMethod("private", callbackFactory.getFastOptMethod("rbPrivate"));
        moduleClass.defineFastPrivateMethod("remove_class_variable", callbackFactory.getFastMethod("remove_class_variable", IRubyObject.class));
        moduleClass.defineFastPrivateMethod("remove_const", callbackFactory.getFastMethod("remove_const", IRubyObject.class));
        moduleClass.defineFastPrivateMethod("remove_method", callbackFactory.getFastOptMethod("remove_method"));
        moduleClass.defineFastPrivateMethod("undef_method", callbackFactory.getFastMethod("undef_method", IRubyObject.class));
        moduleMetaClass.defineMethod("nesting", callbackFactory.getSingletonMethod("nesting"));
        callbackFactory = runtime.callbackFactory(RubyKernel.class);
        moduleClass.defineFastMethod("autoload", callbackFactory.getFastSingletonMethod("autoload", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        moduleClass.defineFastMethod("autoload?", callbackFactory.getFastSingletonMethod("autoload_p", RubyKernel.IRUBY_OBJECT));
        return moduleClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 12;
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        if (context.getRuntime().hasEventHooks()) {
            return this.callMethod(context, rubyclass, name, args, callType, block);
        }
        switch (this.getRuntime().getSelectorTable().table[rubyclass.index][methodIndex]) {
            case 1: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_eqq(args[0]);
            }
        }
        return super.callMethod(context, rubyclass, name, args, callType, block);
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    protected void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
    }

    public RubyModule getParent() {
        if (this.cref.getNext() == null) {
            return null;
        }
        return (RubyModule)this.cref.getNext().getValue();
    }

    public void setParent(RubyModule p) {
        this.cref.setNext(p.getCRef());
    }

    public Map getMethods() {
        return this.methods;
    }

    public void putMethod(Object name, DynamicMethod method) {
        this.getRuntime().getSelectorTable().table[this.index][MethodIndex.getIndex((String)((String)name))] = 0;
        this.getMethods().put(name, method);
    }

    public boolean isModule() {
        return true;
    }

    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public boolean isIncluded() {
        return false;
    }

    public RubyModule getNonIncludedClass() {
        return this;
    }

    public String getBaseName() {
        return this.classId;
    }

    public void setBaseName(String name) {
        this.classId = name;
    }

    public String getName() {
        if (this.getBaseName() == null) {
            if (this.isClass()) {
                return "#<Class:01x" + Integer.toHexString(System.identityHashCode(this)) + ">";
            }
            return "#<Module:01x" + Integer.toHexString(System.identityHashCode(this)) + ">";
        }
        StringBuffer result = new StringBuffer(this.getBaseName());
        RubyClass objectClass = this.getRuntime().getObject();
        for (RubyModule p = this.getParent(); p != null && p != objectClass; p = p.getParent()) {
            String pName = p.getBaseName();
            if (pName == null) {
                pName = p.getName();
            }
            result.insert(0, "::").insert(0, pName);
        }
        return result.toString();
    }

    public IncludedModuleWrapper newIncludeClass(RubyClass superClazz) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClazz, this);
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    private RubyModule getModuleWithInstanceVar(String name) {
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (p.getInstanceVariable(name) == null) continue;
            return p;
        }
        return null;
    }

    public IRubyObject setClassVar(String name, IRubyObject value) {
        RubyModule module = this.getModuleWithInstanceVar(name);
        if (module == null) {
            module = this;
        }
        return module.setInstanceVariable(name, value, CVAR_TAINT_ERROR, CVAR_FREEZE_ERROR);
    }

    public IRubyObject getClassVar(String name) {
        RubyModule module = this.getModuleWithInstanceVar(name);
        if (module != null) {
            IRubyObject variable = module.getInstanceVariable(name);
            return variable == null ? this.getRuntime().getNil() : variable;
        }
        throw this.getRuntime().newNameError("uninitialized class variable " + name + " in " + this.getName(), name);
    }

    public boolean isClassVarDefined(String name) {
        return this.getModuleWithInstanceVar(name) != null;
    }

    public IRubyObject setConstant(String name, IRubyObject value) {
        RubyModule module;
        IRubyObject oldValue = this.getInstanceVariable(name);
        if (oldValue == this.getRuntime().getUndef()) {
            this.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + name);
        } else if (oldValue != null) {
            this.getRuntime().getWarnings().warn("already initialized constant " + name);
        }
        IRubyObject result = this.setInstanceVariable(name, value, "Insecure: can't set constant", CVAR_FREEZE_ERROR);
        if (value instanceof RubyModule && (module = (RubyModule)value).getBaseName() == null) {
            module.setBaseName(name);
            module.setParent(this);
        }
        return result;
    }

    public RubyClass getClass(String name) {
        IRubyObject module = this.getConstantAt(name);
        return module instanceof RubyClass ? (RubyClass)module : null;
    }

    public IRubyObject const_missing(IRubyObject name, Block block) {
        if (this != this.getRuntime().getObject()) {
            throw this.getRuntime().newNameError("uninitialized constant " + this.getName() + "::" + name.asSymbol(), "" + this.getName() + "::" + name.asSymbol());
        }
        throw this.getRuntime().newNameError("uninitialized constant " + name.asSymbol(), name.asSymbol());
    }

    public synchronized void includeModule(IRubyObject arg) {
        assert (arg != null);
        this.testFrozen("module");
        if (!this.isTaint()) {
            this.getRuntime().secure(4);
        }
        if (!(arg instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + arg.getMetaClass().getName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg;
        if (this.isSame(module)) {
            return;
        }
        this.infectBy(module);
        boolean changed = false;
        boolean skip = false;
        RubyModule c = this;
        while (module != null) {
            if (this.getNonIncludedClass() == module.getNonIncludedClass()) {
                throw this.getRuntime().newArgumentError("cyclic include detected");
            }
            boolean superclassSeen = false;
            for (RubyClass p = this.getSuperClass(); p != null; p = p.getSuperClass()) {
                if (p instanceof IncludedModuleWrapper) {
                    if (p.getNonIncludedClass() != module.getNonIncludedClass()) continue;
                    if (!superclassSeen) {
                        c = p;
                    }
                    skip = true;
                    break;
                }
                superclassSeen = true;
            }
            if (!skip) {
                c.setSuperClass(new IncludedModuleWrapper(this.getRuntime(), c.getSuperClass(), module.getNonIncludedClass()));
                c = c.getSuperClass();
                changed = true;
            }
            module = module.getSuperClass();
            skip = false;
        }
        if (changed) {
            ArrayList methodNames = new ArrayList(((RubyModule)arg).getMethods().keySet());
            for (String methodName : methodNames) {
                this.getRuntime().getCacheMap().remove(methodName, this.searchMethod(methodName));
            }
        }
    }

    public void defineMethod(String name, Callback method) {
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name, new FullFunctionCallbackMethod(this, method, visibility));
    }

    public void defineFastMethod(String name, Callback method) {
        Visibility visibility = name.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name, new SimpleCallbackMethod(this, method, visibility));
    }

    public void defineFastMethod(String name, Callback method, Visibility visibility) {
        this.addMethod(name, new SimpleCallbackMethod(this, method, visibility));
    }

    public void definePrivateMethod(String name, Callback method) {
        this.addMethod(name, new FullFunctionCallbackMethod(this, method, Visibility.PRIVATE));
    }

    public void defineFastPrivateMethod(String name, Callback method) {
        this.addMethod(name, new SimpleCallbackMethod(this, method, Visibility.PRIVATE));
    }

    public void defineFastProtectedMethod(String name, Callback method) {
        this.addMethod(name, new SimpleCallbackMethod(this, method, Visibility.PROTECTED));
    }

    public void undefineMethod(String name) {
        this.addMethod(name, UndefinedMethod.getInstance());
    }

    public void undef(String name) {
        DynamicMethod method;
        Ruby runtime = this.getRuntime();
        if (this == runtime.getObject()) {
            runtime.secure(4);
        }
        if (runtime.getSafeLevel() >= 4 && !this.isTaint()) {
            throw new SecurityException("Insecure: can't undef");
        }
        this.testFrozen("module");
        if (name.equals("__id__") || name.equals("__send__")) {
            this.getRuntime().getWarnings().warn("undefining `" + name + "' may cause serious problem");
        }
        if ((method = this.searchMethod(name)).isUndefined()) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                IRubyObject obj = this.getInstanceVariable("__attached__");
                if (obj != null && obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw this.getRuntime().newNameError("Undefined method " + name + " for" + s0 + " '" + c.getName() + "'", name);
        }
        this.addMethod(name, UndefinedMethod.getInstance());
        if (this.isSingleton()) {
            IRubyObject singleton = this.getInstanceVariable("__attached__");
            singleton.callMethod(runtime.getCurrentContext(), "singleton_method_undefined", this.getRuntime().newSymbol(name));
        } else {
            this.callMethod(runtime.getCurrentContext(), "method_undefined", this.getRuntime().newSymbol(name));
        }
    }

    public IRubyObject include_p(IRubyObject arg) {
        if (!(arg instanceof RubyModule) || !((RubyModule)arg).isModule()) {
            throw this.getRuntime().newTypeError(arg, this.getRuntime().getClass("Module"));
        }
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (!(p instanceof IncludedModuleWrapper) || ((IncludedModuleWrapper)p).getNonIncludedClass() != arg) continue;
            return this.getRuntime().newBoolean(true);
        }
        return this.getRuntime().newBoolean(false);
    }

    private void addCachedMethod(String name, DynamicMethod method) {
        if (!this.isIncluded()) {
            this.putMethod(name, method);
            this.getRuntime().getCacheMap().add(method, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(String name, DynamicMethod method) {
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't define method");
        }
        this.testFrozen(CVAR_FREEZE_ERROR);
        Map map = this.getMethods();
        synchronized (map) {
            DynamicMethod existingMethod = (DynamicMethod)this.getMethods().remove(name);
            if (existingMethod != null) {
                this.getRuntime().getCacheMap().remove(name, existingMethod);
            }
            this.putMethod(name, method);
        }
    }

    public void removeCachedMethod(String name) {
        this.getMethods().remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(String name) {
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove method");
        }
        this.testFrozen(CVAR_FREEZE_ERROR);
        Map map = this.getMethods();
        synchronized (map) {
            DynamicMethod method = (DynamicMethod)this.getMethods().remove(name);
            if (method == null) {
                throw this.getRuntime().newNameError("method '" + name + "' not defined in " + this.getName(), name);
            }
            this.getRuntime().getCacheMap().remove(name, method);
        }
        if (this.isSingleton()) {
            IRubyObject singleton = this.getInstanceVariable("__attached__");
            singleton.callMethod(this.getRuntime().getCurrentContext(), "singleton_method_removed", this.getRuntime().newSymbol(name));
        } else {
            this.callMethod(this.getRuntime().getCurrentContext(), "method_removed", this.getRuntime().newSymbol(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicMethod searchMethod(String name) {
        for (RubyModule searchModule = this; searchModule != null; searchModule = searchModule.getSuperClass()) {
            Map map = searchModule.getMethods();
            synchronized (map) {
                DynamicMethod method = (DynamicMethod)searchModule.getMethods().get(name);
                if (method != null) {
                    if (searchModule != this) {
                        this.addCachedMethod(name, method);
                    }
                    return method;
                }
                continue;
            }
        }
        return UndefinedMethod.getInstance();
    }

    public DynamicMethod retrieveMethod(String name) {
        return (DynamicMethod)this.getMethods().get(name);
    }

    public RubyModule findImplementer(RubyModule clazz) {
        for (RubyModule searchModule = this; searchModule != null; searchModule = searchModule.getSuperClass()) {
            if (!searchModule.isSame(clazz)) continue;
            return searchModule;
        }
        return null;
    }

    public void addModuleFunction(String name, DynamicMethod method) {
        this.addMethod(name, method);
        this.getSingletonClass().addMethod(name, method);
    }

    public void defineModuleFunction(String name, Callback method) {
        this.definePrivateMethod(name, method);
        this.getSingletonClass().defineMethod(name, method);
    }

    public void definePublicModuleFunction(String name, Callback method) {
        this.defineMethod(name, method);
        this.getSingletonClass().defineMethod(name, method);
    }

    public void defineFastModuleFunction(String name, Callback method) {
        this.defineFastPrivateMethod(name, method);
        this.getSingletonClass().defineFastMethod(name, method);
    }

    public void defineFastPublicModuleFunction(String name, Callback method) {
        this.defineFastMethod(name, method);
        this.getSingletonClass().defineFastMethod(name, method);
    }

    private IRubyObject getConstantInner(String name, boolean exclude) {
        RubyClass objectClass = this.getRuntime().getObject();
        IRubyObject undef = this.getRuntime().getUndef();
        boolean retryForModule = false;
        RubyModule p = this;
        while (true) {
            if (p != null) {
                IRubyObject constant = p.getInstanceVariable(name);
                if (constant == undef) {
                    p.removeInstanceVariable(name);
                    if (this.getRuntime().getLoadService().autoload(p.getName() + "::" + name) != null) continue;
                } else {
                    if (constant != null) {
                        if (exclude && p == objectClass && this != objectClass) {
                            this.getRuntime().getWarnings().warn("toplevel constant " + name + " referenced by " + this.getName() + "::" + name);
                        }
                        return constant;
                    }
                    p = p.getSuperClass();
                    continue;
                }
            }
            if (exclude || retryForModule || !this.getClass().equals(RubyModule.class)) break;
            retryForModule = true;
            p = this.getRuntime().getObject();
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", RubySymbol.newSymbol(this.getRuntime(), name));
    }

    public IRubyObject getConstant(String name) {
        return this.getConstantInner(name, false);
    }

    public IRubyObject getConstantFrom(String name) {
        return this.getConstantInner(name, true);
    }

    public IRubyObject getConstantAt(String name) {
        IRubyObject constant = this.getInstanceVariable(name);
        if (constant != this.getRuntime().getUndef()) {
            return constant;
        }
        this.removeInstanceVariable(name);
        return this.getRuntime().getLoadService().autoload(this.getName() + "::" + name);
    }

    public synchronized void defineAlias(String name, String oldName) {
        DynamicMethod method;
        this.testFrozen("module");
        if (oldName.equals(name)) {
            return;
        }
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if ((method = this.searchMethod(oldName)).isUndefined()) {
            if (this.isModule()) {
                method = this.getRuntime().getObject().searchMethod(oldName);
            }
            if (method.isUndefined()) {
                throw this.getRuntime().newNameError("undefined method `" + oldName + "' for " + (this.isModule() ? "module" : "class") + " `" + this.getName() + "'", oldName);
            }
        }
        this.getRuntime().getCacheMap().remove(name, this.searchMethod(name));
        this.putMethod(name, new AliasMethod(this, method, oldName));
    }

    public RubyClass defineOrGetClassUnder(String name, RubyClass superClazz) {
        IRubyObject type = this.getInstanceVariable(name);
        if (type == null || type instanceof RubyUndef) {
            if (this.classProviders != null && (type = this.searchClassProviders(name, superClazz)) != null) {
                return (RubyClass)type;
            }
            ObjectAllocator allocator = superClazz == null ? this.getRuntime().getObject().getAllocator() : superClazz.getAllocator();
            return this.getRuntime().defineClassUnder(name, superClazz, allocator, this.cref);
        }
        if (!(type instanceof RubyClass)) {
            throw this.getRuntime().newTypeError(name + " is not a class.");
        }
        if (superClazz != null && ((RubyClass)type).getSuperClass().getRealClass() != superClazz) {
            throw this.getRuntime().newTypeError("superclass mismatch for class " + name);
        }
        return (RubyClass)type;
    }

    public RubyClass defineClassUnder(String name, RubyClass superClazz, ObjectAllocator allocator) {
        IRubyObject type = this.getInstanceVariable(name);
        if (type == null) {
            return this.getRuntime().defineClassUnder(name, superClazz, allocator, this.cref);
        }
        if (!(type instanceof RubyClass)) {
            throw this.getRuntime().newTypeError(name + " is not a class.");
        }
        if (((RubyClass)type).getSuperClass().getRealClass() != superClazz) {
            throw this.getRuntime().newNameError(name + " is already defined.", name);
        }
        return (RubyClass)type;
    }

    public RubyModule defineModuleUnder(String name) {
        IRubyObject type = this.getConstantAt(name);
        if (type == null) {
            return this.getRuntime().defineModuleUnder(name, this.cref);
        }
        if (!(type instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(name + " is not a module.");
        }
        return (RubyModule)type;
    }

    public void defineConstant(String name, IRubyObject value) {
        assert (value != null);
        if (this == this.getRuntime().getClass("Class")) {
            this.getRuntime().secure(4);
        }
        if (!IdUtil.isConstant(name)) {
            throw this.getRuntime().newNameError("bad constant name " + name, name);
        }
        this.setConstant(name, value);
    }

    public IRubyObject removeCvar(IRubyObject name) {
        if (!IdUtil.isClassVariable(name.asSymbol())) {
            throw this.getRuntime().newNameError("wrong class variable name " + name.asSymbol(), name.asSymbol());
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove class variable");
        }
        this.testFrozen(CVAR_FREEZE_ERROR);
        IRubyObject value = this.removeInstanceVariable(name.asSymbol());
        if (value != null) {
            return value;
        }
        if (this.isClassVarDefined(name.asSymbol())) {
            throw this.cannotRemoveError(name.asSymbol());
        }
        throw this.getRuntime().newNameError("class variable " + name.asSymbol() + " not defined for " + this.getName(), name.asSymbol());
    }

    private void addAccessor(String name, boolean readable, boolean writeable) {
        ThreadContext tc = this.getRuntime().getCurrentContext();
        Visibility attributeScope = tc.getCurrentVisibility();
        if (!attributeScope.isPrivate() && attributeScope.isModuleFunction()) {
            attributeScope = Visibility.PRIVATE;
        }
        final String variableName = "@" + name;
        final Ruby runtime = this.getRuntime();
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (readable) {
            this.defineMethod(name, new Callback(){

                @Override
                public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                    Arity.checkArgumentCount(RubyModule.this.getRuntime(), args, 0, 0);
                    IRubyObject variable = self.getInstanceVariable(variableName);
                    return variable == null ? runtime.getNil() : variable;
                }

                @Override
                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            this.callMethod(context, "method_added", RubySymbol.newSymbol(this.getRuntime(), name));
        }
        if (writeable) {
            name = name + "=";
            this.defineMethod(name, new Callback(){

                @Override
                public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                    Arity.checkArgumentCount(RubyModule.this.getRuntime(), args, 1, 1);
                    return self.setInstanceVariable(variableName, args[0]);
                }

                @Override
                public Arity getArity() {
                    return Arity.singleArgument();
                }
            });
            this.callMethod(context, "method_added", RubySymbol.newSymbol(this.getRuntime(), name));
        }
    }

    public void setMethodVisibility(IRubyObject[] methods, Visibility visibility) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        for (int i = 0; i < methods.length; ++i) {
            this.exportMethod(methods[i].asSymbol(), visibility);
        }
    }

    public void exportMethod(String name, Visibility visibility) {
        DynamicMethod method;
        if (this == this.getRuntime().getObject()) {
            this.getRuntime().secure(4);
        }
        if ((method = this.searchMethod(name)).isUndefined()) {
            throw this.getRuntime().newNameError("undefined method '" + name + "' for " + (this.isModule() ? "module" : "class") + " '" + this.getName() + "'", name);
        }
        if (method.getVisibility() != visibility) {
            if (this == method.getImplementationClass()) {
                method.setVisibility(visibility);
            } else {
                this.addMethod(name, new FullFunctionCallbackMethod(this, new Callback(){

                    @Override
                    public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                        ThreadContext tc = self.getRuntime().getCurrentContext();
                        return self.callSuper(tc, tc.getFrameArgs(), block);
                    }

                    @Override
                    public Arity getArity() {
                        return Arity.optional();
                    }
                }, visibility));
            }
        }
    }

    public boolean isMethodBound(String name, boolean checkVisibility) {
        DynamicMethod method = this.searchMethod(name);
        if (!method.isUndefined()) {
            return !checkVisibility || !method.getVisibility().isPrivate();
        }
        return false;
    }

    public IRubyObject newMethod(IRubyObject receiver, String name, boolean bound) {
        DynamicMethod method = this.searchMethod(name);
        if (method.isUndefined()) {
            throw this.getRuntime().newNameError("undefined method `" + name + "' for class `" + this.getName() + "'", name);
        }
        RubyMethod newMethod = null;
        newMethod = bound ? RubyMethod.newMethod(method.getImplementationClass(), name, this, name, method, receiver) : RubyUnboundMethod.newUnboundMethod(method.getImplementationClass(), name, this, name, method);
        newMethod.infectBy(this);
        return newMethod;
    }

    public IRubyObject define_method(IRubyObject[] args, Block block) {
        RubyObject body;
        if (args.length < 1 || args.length > 2) {
            throw this.getRuntime().newArgumentError("wrong # of arguments(" + args.length + " for 1)");
        }
        String name = args[0].asSymbol();
        DynamicMethod newMethod = null;
        ThreadContext tc = this.getRuntime().getCurrentContext();
        Visibility visibility = tc.getCurrentVisibility();
        if (visibility.isModuleFunction()) {
            visibility = Visibility.PRIVATE;
        }
        if (args.length == 1 || args[1].isKindOf(this.getRuntime().getClass("Proc"))) {
            RubyProc proc;
            body = proc = args.length == 1 ? this.getRuntime().newProc(false, block) : (RubyProc)args[1];
            proc.getBlock().isLambda = true;
            proc.getBlock().getFrame().setKlazz(this);
            proc.getBlock().getFrame().setName(name);
            newMethod = new ProcMethod(this, proc, visibility);
        } else if (args[1].isKindOf(this.getRuntime().getClass("Method"))) {
            RubyMethod method = (RubyMethod)args[1];
            body = method;
            newMethod = new MethodMethod(this, method.unbind(null), visibility);
        } else {
            throw this.getRuntime().newTypeError("wrong argument type " + args[0].getType().getName() + " (expected Proc/Method)");
        }
        this.addMethod(name, newMethod);
        RubySymbol symbol = RubySymbol.newSymbol(this.getRuntime(), name);
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (tc.getPreviousVisibility().isModuleFunction()) {
            this.getSingletonClass().addMethod(name, new WrapperMethod(this.getSingletonClass(), newMethod, Visibility.PUBLIC));
        }
        if (this.isSingleton()) {
            IRubyObject singleton = this.getInstanceVariable("__attached__");
            singleton.callMethod(context, "singleton_method_added", symbol);
        } else {
            this.callMethod(context, "method_added", symbol);
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject executeUnder(Callback method, IRubyObject[] args, Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        context.preExecuteUnder(this, block);
        try {
            IRubyObject iRubyObject = method.execute(this, args, block);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
        }
    }

    public static RubyModule newModule(Ruby runtime, String name) {
        return RubyModule.newModule(runtime, runtime.getClass("Module"), name, null);
    }

    public static RubyModule newModule(Ruby runtime, RubyClass type, String name) {
        return RubyModule.newModule(runtime, type, name, null);
    }

    public static RubyModule newModule(Ruby runtime, String name, SinglyLinkedList parentCRef) {
        return RubyModule.newModule(runtime, runtime.getClass("Module"), name, parentCRef);
    }

    public static RubyModule newModule(Ruby runtime, RubyClass type, String name, SinglyLinkedList parentCRef) {
        RubyModule module = new RubyModule(runtime, type, null, parentCRef, name);
        return module;
    }

    public RubyString name() {
        return this.getRuntime().newString(this.getBaseName() == null ? "" : this.getName());
    }

    public RubyArray class_variables() {
        RubyArray ary = this.getRuntime().newArray();
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            Iterator iter = p.instanceVariableNames();
            while (iter.hasNext()) {
                RubyString kval;
                String id = (String)iter.next();
                if (!IdUtil.isClassVariable(id) || ary.includes(kval = this.getRuntime().newString(id))) continue;
                ary.append(kval);
            }
        }
        return ary;
    }

    public IRubyObject class_variable_get(IRubyObject var) {
        String varName = var.asSymbol();
        if (!IdUtil.isClassVariable(varName)) {
            throw this.getRuntime().newNameError("`" + varName + "' is not allowed as a class variable name", varName);
        }
        return this.getClassVar(varName);
    }

    public IRubyObject class_variable_set(IRubyObject var, IRubyObject value) {
        String varName = var.asSymbol();
        if (!IdUtil.isClassVariable(varName)) {
            throw this.getRuntime().newNameError("`" + varName + "' is not allowed as a class variable name", varName);
        }
        return this.setClassVar(varName, value);
    }

    protected IRubyObject cloneMethods(RubyModule clone) {
        RubyModule realType = this.getNonIncludedClass();
        for (Map.Entry entry : this.getMethods().entrySet()) {
            DynamicMethod method = (DynamicMethod)entry.getValue();
            if (method.getImplementationClass() != realType && !(method instanceof UndefinedMethod)) continue;
            DynamicMethod clonedMethod = method.dup();
            clonedMethod.setImplementationClass(clone);
            clone.putMethod(entry.getKey(), clonedMethod);
        }
        return clone;
    }

    @Override
    protected IRubyObject doClone() {
        return RubyModule.newModule(this.getRuntime(), null, this.cref.getNext());
    }

    @Override
    public IRubyObject initialize_copy(IRubyObject original) {
        assert (original instanceof RubyModule);
        RubyModule originalModule = (RubyModule)original;
        super.initialize_copy(originalModule);
        if (!this.getMetaClass().isSingleton()) {
            this.setMetaClass(originalModule.getSingletonClassClone());
        }
        this.setSuperClass(originalModule.getSuperClass());
        if (originalModule.instanceVariables != null) {
            this.setInstanceVariables(new HashMap(originalModule.getInstanceVariables()));
        }
        originalModule.cloneMethods(this);
        return this;
    }

    public RubyArray included_modules() {
        RubyArray ary = this.getRuntime().newArray();
        for (RubyClass p = this.getSuperClass(); p != null; p = p.getSuperClass()) {
            if (!p.isIncluded()) continue;
            ary.append(p.getNonIncludedClass());
        }
        return ary;
    }

    public RubyArray ancestors() {
        RubyArray ary = this.getRuntime().newArray(this.getAncestorList());
        return ary;
    }

    public List getAncestorList() {
        ArrayList<RubyModule> list = new ArrayList<RubyModule>();
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (p.isSingleton()) continue;
            list.add(p.getNonIncludedClass());
        }
        return list;
    }

    public boolean hasModuleInHierarchy(RubyModule type) {
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (p.getNonIncludedClass() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.id);
    }

    @Override
    public IRubyObject to_s() {
        if (this.isSingleton()) {
            IRubyObject attached = this.getInstanceVariable("__attached__");
            StringBuffer buffer = new StringBuffer("#<Class:");
            if (attached instanceof RubyClass || attached instanceof RubyModule) {
                buffer.append(attached.inspect());
            } else {
                buffer.append(attached.anyToString());
            }
            buffer.append(">");
            return this.getRuntime().newString(buffer.toString());
        }
        return this.getRuntime().newString(this.getName());
    }

    public RubyBoolean op_eqq(IRubyObject obj) {
        return this.getRuntime().newBoolean(obj.isKindOf(this));
    }

    public IRubyObject op_le(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        if (this.isKindOfModule((RubyModule)obj)) {
            return this.getRuntime().getTrue();
        }
        if (((RubyModule)obj).isKindOfModule(this)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject op_lt(IRubyObject obj) {
        return obj == this ? this.getRuntime().getFalse() : this.op_le(obj);
    }

    public IRubyObject op_ge(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    public IRubyObject op_gt(IRubyObject obj) {
        return this == obj ? this.getRuntime().getFalse() : this.op_ge(obj);
    }

    public IRubyObject op_cmp(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().newFixnum(0L);
        }
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("<=> requires Class or Module (" + this.getMetaClass().getName() + " given)");
        }
        RubyModule module = (RubyModule)obj;
        if (module.isKindOfModule(this)) {
            return this.getRuntime().newFixnum(1L);
        }
        if (this.isKindOfModule(module)) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().getNil();
    }

    public boolean isKindOfModule(RubyModule type) {
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (!p.isSame(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isSame(RubyModule module) {
        return this == module;
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (block.isGiven()) {
            block.yield(this.getRuntime().getCurrentContext(), null, this, this, false);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject attr(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        boolean writeable = args.length > 1 ? args[1].isTrue() : false;
        this.addAccessor(args[0].asSymbol(), true, writeable);
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_reader(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.addAccessor(args[i].asSymbol(), true, false);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_writer(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.addAccessor(args[i].asSymbol(), false, true);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject attr_accessor(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.addAccessor(args[i].asSymbol(), true, true);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject const_get(IRubyObject symbol) {
        String name = symbol.asSymbol();
        if (!IdUtil.isConstant(name)) {
            throw this.wrongConstantNameError(name);
        }
        return this.getConstant(name);
    }

    public IRubyObject const_set(IRubyObject symbol, IRubyObject value) {
        String name = symbol.asSymbol();
        if (!IdUtil.isConstant(name)) {
            throw this.wrongConstantNameError(name);
        }
        return this.setConstant(name, value);
    }

    public RubyBoolean const_defined(IRubyObject symbol) {
        String name = symbol.asSymbol();
        if (!IdUtil.isConstant(name)) {
            throw this.wrongConstantNameError(name);
        }
        return this.getRuntime().newBoolean(this.getInstanceVariable(name) != null);
    }

    private RaiseException wrongConstantNameError(String name) {
        return this.getRuntime().newNameError("wrong constant name " + name, name);
    }

    private RubyArray instance_methods(IRubyObject[] args, Visibility visibility) {
        boolean includeSuper = args.length > 0 ? args[0].isTrue() : true;
        RubyArray ary = this.getRuntime().newArray();
        HashMap<String, Boolean> undefinedMethods = new HashMap<String, Boolean>();
        HashSet<String> added = new HashSet<String>();
        for (RubyModule type = this; type != null; type = type.getSuperClass()) {
            RubyModule realType = type.getNonIncludedClass();
            for (Map.Entry entry : type.getMethods().entrySet()) {
                DynamicMethod method = (DynamicMethod)entry.getValue();
                String methodName = (String)entry.getKey();
                if (method.isUndefined()) {
                    undefinedMethods.put(methodName, Boolean.TRUE);
                    continue;
                }
                if (method.getImplementationClass() != realType || !method.getVisibility().is(visibility) || undefinedMethods.get(methodName) != null || added.contains(methodName)) continue;
                ary.append(this.getRuntime().newString(methodName));
                added.add(methodName);
            }
            if (!includeSuper) break;
        }
        return ary;
    }

    public RubyArray instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PUBLIC_PROTECTED);
    }

    public RubyArray public_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PUBLIC);
    }

    public IRubyObject instance_method(IRubyObject symbol) {
        return this.newMethod(null, symbol.asSymbol(), false);
    }

    public RubyArray protected_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PROTECTED);
    }

    public RubyArray private_instance_methods(IRubyObject[] args) {
        return this.instance_methods(args, Visibility.PRIVATE);
    }

    public RubyArray constants() {
        ArrayList<RubyString> constantNames = new ArrayList<RubyString>();
        RubyClass objectClass = this.getRuntime().getObject();
        if (this.getRuntime().getClass("Module") == this) {
            Iterator vars = objectClass.instanceVariableNames();
            while (vars.hasNext()) {
                String name = (String)vars.next();
                if (!IdUtil.isConstant(name)) continue;
                constantNames.add(this.getRuntime().newString(name));
            }
            return this.getRuntime().newArray(constantNames);
        }
        if (this.getRuntime().getObject() == this) {
            Iterator vars = this.instanceVariableNames();
            while (vars.hasNext()) {
                String name = (String)vars.next();
                if (!IdUtil.isConstant(name)) continue;
                constantNames.add(this.getRuntime().newString(name));
            }
            return this.getRuntime().newArray(constantNames);
        }
        for (RubyModule p = this; p != null; p = p.getSuperClass()) {
            if (objectClass == p) continue;
            Iterator vars = p.instanceVariableNames();
            while (vars.hasNext()) {
                String name = (String)vars.next();
                if (!IdUtil.isConstant(name)) continue;
                constantNames.add(this.getRuntime().newString(name));
            }
        }
        return this.getRuntime().newArray(constantNames);
    }

    public IRubyObject remove_class_variable(IRubyObject name) {
        String id = name.asSymbol();
        if (!IdUtil.isClassVariable(id)) {
            throw this.getRuntime().newNameError("wrong class variable name " + id, id);
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove class variable");
        }
        this.testFrozen(CVAR_FREEZE_ERROR);
        IRubyObject variable = this.removeInstanceVariable(id);
        if (variable != null) {
            return variable;
        }
        if (this.isClassVarDefined(id)) {
            throw this.cannotRemoveError(id);
        }
        throw this.getRuntime().newNameError("class variable " + id + " not defined for " + this.getName(), id);
    }

    private RaiseException cannotRemoveError(String id) {
        return this.getRuntime().newNameError("cannot remove " + id + " for " + this.getName(), id);
    }

    public IRubyObject remove_const(IRubyObject name) {
        String id = name.asSymbol();
        if (!IdUtil.isConstant(id)) {
            throw this.wrongConstantNameError(id);
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't remove class variable");
        }
        this.testFrozen(CVAR_FREEZE_ERROR);
        IRubyObject variable = this.getInstanceVariable(id);
        if (variable != null) {
            if (variable == this.getRuntime().getUndef()) {
                this.getRuntime().getLoadService().removeAutoLoadFor(this.getName() + "::" + id);
            }
            return this.removeInstanceVariable(id);
        }
        if (this.isClassVarDefined(id)) {
            throw this.cannotRemoveError(id);
        }
        throw this.getRuntime().newNameError("constant " + id + " not defined for " + this.getName(), id);
    }

    public RubyModule append_features(IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(module, this.getRuntime().getClass("Class"));
        }
        ((RubyModule)module).includeModule(this);
        return this;
    }

    public IRubyObject extend_object(IRubyObject obj) {
        obj.getSingletonClass().includeModule(this);
        return obj;
    }

    public RubyModule include(IRubyObject[] modules) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int i = modules.length;
        while (--i >= 0) {
            IRubyObject obj = modules[i];
            if (obj instanceof RubyModule && ((RubyModule)obj).isModule()) continue;
            throw this.getRuntime().newTypeError(obj, this.getRuntime().getClass("Module"));
        }
        for (i = modules.length - 1; i >= 0; --i) {
            modules[i].callMethod(context, "append_features", this);
            modules[i].callMethod(context, "included", this);
        }
        return this;
    }

    public IRubyObject included(IRubyObject other) {
        return this.getRuntime().getNil();
    }

    public IRubyObject extended(IRubyObject other, Block block) {
        return this.getRuntime().getNil();
    }

    private void setVisibility(IRubyObject[] args, Visibility visibility) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuntime().getCurrentContext().setCurrentVisibility(visibility);
        } else {
            this.setMethodVisibility(args, visibility);
        }
    }

    public RubyModule rbPublic(IRubyObject[] args) {
        this.setVisibility(args, Visibility.PUBLIC);
        return this;
    }

    public RubyModule rbProtected(IRubyObject[] args) {
        this.setVisibility(args, Visibility.PROTECTED);
        return this;
    }

    public RubyModule rbPrivate(IRubyObject[] args) {
        this.setVisibility(args, Visibility.PRIVATE);
        return this;
    }

    public RubyModule module_function(IRubyObject[] args) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args.length == 0) {
            context.setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(args, Visibility.PRIVATE);
            for (int i = 0; i < args.length; ++i) {
                String name = args[i].asSymbol();
                DynamicMethod method = this.searchMethod(name);
                assert (!method.isUndefined()) : "undefined method '" + name + "'";
                this.getSingletonClass().addMethod(name, new WrapperMethod(this.getSingletonClass(), method, Visibility.PUBLIC));
                this.callMethod(context, "singleton_method_added", RubySymbol.newSymbol(this.getRuntime(), name));
            }
        }
        return this;
    }

    public IRubyObject method_added(IRubyObject nothing, Block block) {
        return this.getRuntime().getNil();
    }

    public IRubyObject method_removed(IRubyObject nothing, Block block) {
        return this.getRuntime().getNil();
    }

    public IRubyObject method_undefined(IRubyObject nothing, Block block) {
        return this.getRuntime().getNil();
    }

    public RubyBoolean method_defined(IRubyObject symbol) {
        return this.isMethodBound(symbol.asSymbol(), true) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject public_method_defined(IRubyObject symbol) {
        DynamicMethod method = this.searchMethod(symbol.asSymbol());
        return this.getRuntime().newBoolean(!method.isUndefined() && method.getVisibility().isPublic());
    }

    public IRubyObject protected_method_defined(IRubyObject symbol) {
        DynamicMethod method = this.searchMethod(symbol.asSymbol());
        return this.getRuntime().newBoolean(!method.isUndefined() && method.getVisibility().isProtected());
    }

    public IRubyObject private_method_defined(IRubyObject symbol) {
        DynamicMethod method = this.searchMethod(symbol.asSymbol());
        return this.getRuntime().newBoolean(!method.isUndefined() && method.getVisibility().isPrivate());
    }

    public RubyModule public_class_method(IRubyObject[] args) {
        this.getMetaClass().setMethodVisibility(args, Visibility.PUBLIC);
        return this;
    }

    public RubyModule private_class_method(IRubyObject[] args) {
        this.getMetaClass().setMethodVisibility(args, Visibility.PRIVATE);
        return this;
    }

    public RubyModule alias_method(IRubyObject newId, IRubyObject oldId) {
        this.defineAlias(newId.asSymbol(), oldId.asSymbol());
        return this;
    }

    public RubyModule undef_method(IRubyObject name) {
        this.undef(name.asSymbol());
        return this;
    }

    public IRubyObject module_eval(IRubyObject[] args, Block block) {
        return this.specificEval(this, args, block);
    }

    public RubyModule remove_method(IRubyObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.removeMethod(args[i].asSymbol());
        }
        return this;
    }

    public static void marshalTo(RubyModule module, MarshalStream output) throws IOException {
        output.writeString(module.name().toString());
    }

    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name = RubyString.byteListToString(input.unmarshalString());
        Ruby runtime = input.getRuntime();
        RubyModule result = runtime.getClassFromPath(name);
        if (result == null) {
            throw runtime.newNameError("uninitialized constant " + name, name);
        }
        input.registerLinkTarget(result);
        return result;
    }

    public SinglyLinkedList getCRef() {
        return this.cref;
    }

    public static RubyArray nesting(IRubyObject recv, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyClass object = runtime.getObject();
        SinglyLinkedList base = runtime.getCurrentContext().peekCRef();
        RubyArray result = runtime.newArray();
        SinglyLinkedList current = base;
        while (current.getValue() != object) {
            result.append((RubyModule)current.getValue());
            current = current.getNext();
        }
        return result;
    }
}

