/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.UnsupportedEncodingException;
import jregex.Matcher;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.runtime.Arity;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class RubyMatchData
extends RubyObject {
    protected Matcher matcher;

    public static RubyClass createMatchDataClass(Ruby runtime) {
        RubyClass matchDataClass = runtime.defineClass("MatchData", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.defineGlobalConstant("MatchingData", matchDataClass);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyMatchData.class);
        matchDataClass.defineFastMethod("captures", callbackFactory.getFastMethod("captures"));
        matchDataClass.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        matchDataClass.defineFastMethod("size", callbackFactory.getFastMethod("size"));
        matchDataClass.defineFastMethod("length", callbackFactory.getFastMethod("size"));
        matchDataClass.defineFastMethod("offset", callbackFactory.getFastMethod("offset", RubyFixnum.class));
        matchDataClass.defineFastMethod("begin", callbackFactory.getFastMethod("begin", RubyFixnum.class));
        matchDataClass.defineFastMethod("end", callbackFactory.getFastMethod("end", RubyFixnum.class));
        matchDataClass.defineFastMethod("to_a", callbackFactory.getFastMethod("to_a"));
        matchDataClass.defineFastMethod("[]", callbackFactory.getFastOptMethod("aref"));
        matchDataClass.defineFastMethod("pre_match", callbackFactory.getFastMethod("pre_match"));
        matchDataClass.defineFastMethod("post_match", callbackFactory.getFastMethod("post_match"));
        matchDataClass.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        matchDataClass.defineFastMethod("string", callbackFactory.getFastMethod("string"));
        matchDataClass.getMetaClass().undefineMethod("new");
        return matchDataClass;
    }

    public RubyMatchData(Ruby runtime, Matcher matcher) {
        super(runtime, runtime.getClass("MatchData"));
        this.matcher = matcher;
    }

    public abstract IRubyObject captures();

    public IRubyObject subseq(long beg, long len) {
        if (beg < 0L || beg > this.getSize() || len < 0L) {
            this.getRuntime().getNil();
        }
        if (beg + len > this.getSize()) {
            len = this.getSize() - beg;
        }
        if (len < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return this.getRuntime().newArray();
        }
        RubyArray arr = RubyArray.newArray(this.getRuntime(), len);
        long j = beg + len;
        for (long i = beg; i < j; ++i) {
            arr.append(this.group(i));
        }
        return arr;
    }

    public long getSize() {
        return this.matcher.groupCount();
    }

    public boolean proceed() {
        boolean b = this.matcher.proceed();
        this.invalidateRegs();
        return b;
    }

    public boolean find() {
        boolean b = this.matcher.find();
        this.invalidateRegs();
        return b;
    }

    public void invalidateRegs() {
    }

    public abstract IRubyObject group(long var1);

    public int matchStartPosition() {
        return this.matcher.start();
    }

    public int matchEndPosition() {
        return this.matcher.end();
    }

    private boolean outOfBounds(RubyFixnum index) {
        return this.outOfBounds(index.getLongValue());
    }

    private boolean outOfBounds(long n) {
        return n < 0L || n >= this.getSize();
    }

    public IRubyObject aref(IRubyObject[] args) {
        int argc = Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        if (argc == 2) {
            int beg = RubyNumeric.fix2int(args[0]);
            int len = RubyNumeric.fix2int(args[1]);
            if (beg < 0) {
                beg = (int)((long)beg + this.getSize());
            }
            return this.subseq(beg, len);
        }
        if (args[0] instanceof RubyFixnum) {
            return this.group(RubyNumeric.fix2int(args[0]));
        }
        if (args[0] instanceof RubyBignum) {
            throw this.getRuntime().newIndexError("index too big");
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getSize(), true, false);
            if (begLen == null) {
                return this.getRuntime().getNil();
            }
            return this.subseq(begLen[0], begLen[1]);
        }
        return this.group(RubyNumeric.num2long(args[0]));
    }

    public IRubyObject begin(RubyFixnum index) {
        long lIndex = index.getLongValue();
        long answer = this.begin((int)lIndex);
        return answer == -1L ? this.getRuntime().getNil() : this.getRuntime().newFixnum(answer);
    }

    public int begin(int index) {
        return this.outOfBounds(index) || !this.matcher.isCaptured(index) ? -1 : this.matcher.start(index);
    }

    public IRubyObject end(RubyFixnum index) {
        int lIndex = RubyNumeric.fix2int(index);
        long answer = this.end(lIndex);
        return answer == -1L ? this.getRuntime().getNil() : this.getRuntime().newFixnum(answer);
    }

    public int end(int index) {
        return this.outOfBounds(index) || !this.matcher.isCaptured(index) ? -1 : this.matcher.end(index);
    }

    @Override
    public IRubyObject inspect() {
        return this.anyToString();
    }

    public RubyFixnum size() {
        return this.getRuntime().newFixnum(this.getSize());
    }

    public IRubyObject offset(RubyFixnum index) {
        if (this.outOfBounds(index)) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.begin(index), this.end(index)});
    }

    public abstract RubyString pre_match();

    public abstract RubyString post_match();

    public abstract RubyString string();

    public abstract RubyArray to_a();

    @Override
    public abstract IRubyObject to_s();

    @Override
    public abstract IRubyObject doClone();

    public static final class RString
    extends RubyMatchData {
        private RubyString original;
        private int len;
        private int[] start;
        private int[] end;

        public RString(Ruby runtime, RubyString original, Matcher matcher) {
            super(runtime, matcher);
            this.original = (RubyString)original.strDup().freeze();
            this.invalidateRegs();
        }

        @Override
        public void invalidateRegs() {
            this.len = this.matcher.groupCount();
            if (this.start == null || this.start.length != this.len) {
                this.start = new int[this.len];
                this.end = new int[this.len];
            }
            for (int i = 0; i < this.len; ++i) {
                if (this.matcher.isCaptured(i)) {
                    this.start[i] = this.matcher.start(i);
                    this.end[i] = this.matcher.end(i);
                    continue;
                }
                this.start[i] = -1;
            }
        }

        @Override
        public long getSize() {
            return this.len;
        }

        private RubyArray match_array(int st) {
            RubyArray ary = RubyArray.newArray(this.getRuntime(), this.len);
            RubyString target = this.original;
            boolean taint = this.isTaint();
            for (int i = st; i < this.len; ++i) {
                if (this.start[i] == -1) {
                    ary.append(this.getRuntime().getNil());
                    continue;
                }
                RubyString str = target.makeShared(this.start[i], this.end[i] - this.start[i]);
                if (taint) {
                    str.setTaint(true);
                }
                ary.append(str);
            }
            return ary;
        }

        @Override
        public IRubyObject captures() {
            return this.match_array(1);
        }

        public IRubyObject nth_match(int nth) {
            if (nth >= this.len) {
                return this.getRuntime().getNil();
            }
            if (nth < 0 && (nth += this.len) <= 0) {
                return this.getRuntime().getNil();
            }
            if (this.start[nth] == -1) {
                return this.getRuntime().getNil();
            }
            int st = this.start[nth];
            int llen = this.end[nth] - st;
            RubyString str = this.original.makeShared(st, llen);
            str.infectBy(this);
            return str;
        }

        @Override
        public IRubyObject group(long _n) {
            int n = (int)_n;
            if (n < 0 || n >= this.len || this.start[n] == -1) {
                return this.getRuntime().getNil();
            }
            int st = this.start[n];
            int llen = this.end[n] - st;
            return this.original.makeShared(st, llen);
        }

        @Override
        public RubyString pre_match() {
            RubyString str = this.original.makeShared(0, this.start[0]);
            if (this.isTaint()) {
                str.setTaint(true);
            }
            return str;
        }

        @Override
        public RubyString post_match() {
            RubyString str = this.original;
            int pos = this.end[0];
            str = str.makeShared(pos, str.getByteList().length() - pos);
            if (this.isTaint()) {
                str.setTaint(true);
            }
            return str;
        }

        @Override
        public RubyString string() {
            return this.original;
        }

        @Override
        public RubyArray to_a() {
            return this.match_array(0);
        }

        private IRubyObject last_match() {
            return this.nth_match(0);
        }

        @Override
        public IRubyObject to_s() {
            IRubyObject str = this.last_match();
            if (str.isNil()) {
                str = this.getRuntime().newString();
            }
            if (this.isTaint()) {
                str.setTaint(true);
            }
            if (this.original.isTaint()) {
                str.setTaint(true);
            }
            return str;
        }

        @Override
        public IRubyObject doClone() {
            return new RString(this.getRuntime(), this.original, this.matcher);
        }

        @Override
        public int matchStartPosition() {
            return this.start[0];
        }

        @Override
        public int matchEndPosition() {
            return this.end[0];
        }
    }

    public static final class JavaString
    extends RubyMatchData {
        private String original;

        public JavaString(Ruby runtime, String original, Matcher matcher) {
            super(runtime, matcher);
            this.original = original;
        }

        @Override
        public IRubyObject captures() {
            RubyArray arr = this.getRuntime().newArray(this.matcher.groupCount());
            for (int i = 1; i < this.matcher.groupCount(); ++i) {
                if (this.matcher.group(i) == null) {
                    arr.append(this.getRuntime().getNil());
                    continue;
                }
                arr.append(RubyString.newUnicodeString(this.getRuntime(), this.matcher.group(i)));
            }
            return arr;
        }

        @Override
        public IRubyObject group(long n) {
            if (n < 0L || n >= this.getSize() || this.matcher.group((int)n) == null) {
                return this.getRuntime().getNil();
            }
            return RubyString.newUnicodeString(this.getRuntime(), this.matcher.group((int)n));
        }

        @Override
        public RubyString pre_match() {
            return RubyString.newUnicodeString(this.getRuntime(), this.matcher.prefix());
        }

        @Override
        public RubyString post_match() {
            return RubyString.newUnicodeString(this.getRuntime(), this.matcher.suffix());
        }

        @Override
        public RubyString string() {
            RubyString frozenString = RubyString.newUnicodeString(this.getRuntime(), this.original);
            System.out.println(frozenString);
            frozenString.freeze();
            return frozenString;
        }

        @Override
        public RubyArray to_a() {
            RubyArray arr = this.getRuntime().newArray(this.matcher.groupCount());
            for (int i = 0; i < this.matcher.groupCount(); ++i) {
                if (this.matcher.group(i) == null) {
                    arr.append(this.getRuntime().getNil());
                    continue;
                }
                arr.append(RubyString.newUnicodeString(this.getRuntime(), this.matcher.group(i)));
            }
            return arr;
        }

        @Override
        public IRubyObject to_s() {
            return RubyString.newUnicodeString(this.getRuntime(), this.matcher.group(0));
        }

        @Override
        public IRubyObject doClone() {
            return new JavaString(this.getRuntime(), this.original, this.matcher);
        }

        @Override
        public int matchStartPosition() {
            int position = 0;
            try {
                position = this.matcher.prefix().getBytes("UTF8").length;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return position;
        }
    }
}

