/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyLocalJumpError
extends RubyException {
    private static ObjectAllocator LOCALJUMPERROR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyLocalJumpError(runtime, klass);
        }
    };

    public static RubyClass createLocalJumpErrorClass(Ruby runtime, RubyClass standardErrorClass) {
        RubyClass nameErrorClass = runtime.defineClass("LocalJumpError", standardErrorClass, LOCALJUMPERROR_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyLocalJumpError.class);
        nameErrorClass.defineFastMethod("reason", callbackFactory.getFastMethod("reason"));
        nameErrorClass.defineFastMethod("exit_value", callbackFactory.getFastMethod("exitValue"));
        return nameErrorClass;
    }

    private RubyLocalJumpError(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass);
    }

    public RubyLocalJumpError(Ruby runtime, RubyClass exceptionClass, String message, String reason, IRubyObject exitValue) {
        super(runtime, exceptionClass, message);
        this.setInstanceVariable("reason", runtime.newSymbol(reason));
        this.setInstanceVariable("exit_value", exitValue);
    }

    public IRubyObject reason() {
        return this.getInstanceVariable("reason");
    }

    public IRubyObject exitValue() {
        return this.getInstanceVariable("exit_value");
    }
}

