/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;

public class JRubyFile
extends File {
    private static final long serialVersionUID = 435364547567567L;

    public static JRubyFile create(String cwd, String pathname) {
        File internal = new File(pathname);
        if (!internal.isAbsolute() && !(internal = new File(cwd, pathname)).isAbsolute()) {
            throw new IllegalArgumentException("Neither current working directory (" + cwd + ") nor pathname (" + pathname + ") led to an absolute path");
        }
        return new JRubyFile(internal);
    }

    public static String getFileProperty(String property) {
        String value = System.getProperty(property);
        return value.replace(File.separatorChar, '/');
    }

    private JRubyFile(File file) {
        this(file.getAbsolutePath());
    }

    private JRubyFile(String filename) {
        super(filename);
    }

    @Override
    public String getAbsolutePath() {
        return super.getAbsolutePath().replace(File.separatorChar, '/');
    }

    @Override
    public String getCanonicalPath() throws IOException {
        String canonicalPath = super.getCanonicalPath().replace(File.separatorChar, '/');
        if (canonicalPath.endsWith("/.")) {
            canonicalPath = canonicalPath.substring(0, canonicalPath.length() - 1);
        }
        return canonicalPath;
    }

    @Override
    public String getPath() {
        return super.getPath().replace(File.separatorChar, '/');
    }

    @Override
    public String toString() {
        return super.toString().replace(File.separatorChar, '/');
    }

    @Override
    public File getAbsoluteFile() {
        return new JRubyFile(this.getAbsolutePath());
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return new JRubyFile(this.getCanonicalPath());
    }

    @Override
    public String getParent() {
        return super.getParent().replace(File.separatorChar, '/');
    }

    @Override
    public File getParentFile() {
        return new JRubyFile(this.getParent());
    }

    public static File[] listRoots() {
        File[] roots = File.listRoots();
        File[] smartRoots = new JRubyFile[roots.length];
        int j = roots.length;
        for (int i = 0; i < j; ++i) {
            smartRoots[i] = new JRubyFile(roots[i].getPath());
        }
        return smartRoots;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        return new JRubyFile(File.createTempFile(prefix, suffix, directory));
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return new JRubyFile(File.createTempFile(prefix, suffix));
    }

    @Override
    public String[] list(FilenameFilter filter) {
        String[] files = super.list(filter);
        if (files == null) {
            return null;
        }
        String[] smartFiles = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            smartFiles[i] = files[i].replace(File.separatorChar, '/');
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles() {
        File[] files = super.listFiles();
        if (files == null) {
            return null;
        }
        File[] smartFiles = new JRubyFile[files.length];
        int j = files.length;
        for (int i = 0; i < j; ++i) {
            smartFiles[i] = JRubyFile.create(super.getAbsolutePath(), files[i].getPath());
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        File[] files = super.listFiles(filter);
        if (files == null) {
            return null;
        }
        File[] smartFiles = new JRubyFile[files.length];
        int j = files.length;
        for (int i = 0; i < j; ++i) {
            smartFiles[i] = JRubyFile.create(super.getAbsolutePath(), files[i].getPath());
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        File[] files = super.listFiles(filter);
        if (files == null) {
            return null;
        }
        File[] smartFiles = new JRubyFile[files.length];
        int j = files.length;
        for (int i = 0; i < j; ++i) {
            smartFiles[i] = JRubyFile.create(super.getAbsolutePath(), files[i].getPath());
        }
        return smartFiles;
    }
}

