/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOInputStream
extends InputStream {
    private IRubyObject io;
    private final IRubyObject numOne;

    public IOInputStream(IRubyObject io) {
        if (!io.respondsTo("read")) {
            throw new IllegalArgumentException("Object: " + io + " is not a legal argument to this wrapper, cause it doesn't respond to \"read\".");
        }
        this.io = io;
        this.numOne = RubyFixnum.one(this.io.getRuntime());
    }

    @Override
    public int read() throws IOException {
        IRubyObject readValue = this.io.callMethod(this.io.getRuntime().getCurrentContext(), "read", this.numOne);
        int returnValue = -1;
        if (!readValue.isNil()) {
            returnValue = readValue.toString().charAt(0);
        }
        return returnValue;
    }

    @Override
    public int read(byte[] b) throws IOException {
        IRubyObject readValue = this.io.callMethod(this.io.getRuntime().getCurrentContext(), "read", this.io.getRuntime().newFixnum(b.length));
        int returnValue = -1;
        if (!readValue.isNil()) {
            ByteList str = ((RubyString)readValue).getByteList();
            System.arraycopy(str.bytes, 0, b, 0, str.realSize);
            returnValue = str.realSize;
        }
        return returnValue;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        IRubyObject readValue = this.io.callMethod(this.io.getRuntime().getCurrentContext(), "read", this.io.getRuntime().newFixnum(len));
        int returnValue = -1;
        if (!readValue.isNil()) {
            ByteList str = ((RubyString)readValue).getByteList();
            System.arraycopy(str.bytes, 0, b, off, str.realSize);
            returnValue = str.realSize;
        }
        return returnValue;
    }
}

