/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.util.ByteList;
import org.jruby.util.DataInputBridgeStream;
import org.jruby.util.DataOutputBridgeStream;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerJavaIO;
import org.jruby.util.IOModes;
import org.jruby.util.JRubyFile;

public class IOHandlerSeekable
extends IOHandlerJavaIO {
    private static final int BUFSIZE = 1024;
    protected RandomAccessFile file;
    protected String path;
    protected String cwd;
    protected ByteBuffer buffer;
    protected boolean reading;
    protected FileChannel channel;

    public IOHandlerSeekable(Ruby runtime, String path, IOModes modes) throws IOException, IOHandler.InvalidValueException {
        super(runtime);
        this.path = path;
        this.modes = modes;
        this.cwd = runtime.getCurrentDirectory();
        JRubyFile theFile = JRubyFile.create(this.cwd, path);
        if (theFile.exists()) {
            if (modes.shouldTruncate() && !theFile.delete()) {
                // empty if block
            }
        } else if (modes.isReadable() && !modes.isWriteable()) {
            throw new FileNotFoundException();
        }
        String javaMode = "r";
        if (modes.isWriteable()) {
            javaMode = javaMode + "w";
        }
        this.file = new RandomAccessFile(theFile, javaMode);
        this.channel = this.file.getChannel();
        this.isOpen = true;
        this.buffer = ByteBuffer.allocate(1024);
        this.buffer.flip();
        this.reading = true;
        if (modes.isAppendable()) {
            this.seek(0L, 2);
        }
        this.fileno = RubyIO.getNewFileno();
    }

    private void reopen() throws IOException {
        long pos = this.pos();
        String javaMode = "r";
        if (this.modes.isWriteable()) {
            javaMode = javaMode + "w";
        }
        JRubyFile theFile = JRubyFile.create(this.cwd, this.path);
        this.file.close();
        this.file = new RandomAccessFile(theFile, javaMode);
        this.channel = this.file.getChannel();
        this.isOpen = true;
        this.buffer.clear();
        this.buffer.flip();
        this.reading = true;
        try {
            this.seek(pos, 0);
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    private void checkReopen() throws IOException {
        if (this.file.length() != new File(this.path).length()) {
            this.reopen();
        }
    }

    @Override
    public ByteList getsEntireStream() throws IOException {
        this.checkReopen();
        this.invalidateBuffer();
        long left = this.channel.size() - this.channel.position();
        if (left == 0L) {
            return null;
        }
        try {
            return this.sysread((int)left);
        }
        catch (IOHandler.BadDescriptorException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public IOHandler cloneIOHandler() throws IOException, IOHandler.PipeException, IOHandler.InvalidValueException {
        IOHandlerSeekable newHandler = new IOHandlerSeekable(this.getRuntime(), this.path, this.modes);
        ((IOHandler)newHandler).seek(this.pos(), 1);
        return newHandler;
    }

    @Override
    public void close() throws IOException, IOHandler.BadDescriptorException {
        if (!this.isOpen()) {
            throw new IOHandler.BadDescriptorException();
        }
        this.isOpen = false;
        this.flushWrite();
        this.channel.close();
        this.file.close();
    }

    @Override
    public void flush() throws IOException, IOHandler.BadDescriptorException {
        this.checkWriteable();
        this.flushWrite();
    }

    private void flushWrite() throws IOException {
        if (this.reading || !this.modes.isWritable() || this.buffer.position() == 0) {
            return;
        }
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.buffer.clear();
    }

    @Override
    public InputStream getInputStream() {
        return new BufferedInputStream(new DataInputBridgeStream(this.file));
    }

    @Override
    public OutputStream getOutputStream() {
        return new BufferedOutputStream(new DataOutputBridgeStream(this.file));
    }

    @Override
    public boolean isEOF() throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        if (this.reading && this.buffer.hasRemaining()) {
            return false;
        }
        return this.channel.size() == this.channel.position();
    }

    @Override
    public int pid() {
        return -1;
    }

    @Override
    public long pos() throws IOException {
        this.checkOpen();
        int offset = this.reading ? -this.buffer.remaining() : this.buffer.position();
        return this.channel.position() + (long)offset;
    }

    @Override
    public void resetByModes(IOModes newModes) throws IOException, IOHandler.InvalidValueException {
        if (newModes.isAppendable()) {
            this.seek(0L, 2);
        } else if (newModes.isWriteable()) {
            this.rewind();
        }
    }

    @Override
    public void rewind() throws IOException, IOHandler.InvalidValueException {
        this.seek(0L, 0);
    }

    @Override
    public void seek(long offset, int type) throws IOException, IOHandler.InvalidValueException {
        this.checkOpen();
        this.invalidateBuffer();
        try {
            switch (type) {
                case 0: {
                    this.channel.position(offset);
                    break;
                }
                case 1: {
                    this.channel.position(this.channel.position() + offset);
                    break;
                }
                case 2: {
                    this.channel.position(this.channel.size() + offset);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOHandler.InvalidValueException();
        }
    }

    @Override
    public void sync() throws IOException {
        this.flushWrite();
        this.channel.force(false);
    }

    @Override
    public ByteList sysread(int number) throws IOException, IOHandler.BadDescriptorException {
        if (!this.isOpen()) {
            throw new IOException("File not open");
        }
        this.checkReadable();
        this.ensureRead();
        ByteBuffer buf = ByteBuffer.allocate(number);
        if (this.buffer.hasRemaining()) {
            IOHandlerSeekable.putInto(buf, this.buffer);
        }
        if (buf.position() != buf.capacity()) {
            if (buf.capacity() > this.buffer.capacity()) {
                this.channel.read(buf);
            } else {
                this.buffer.clear();
                this.channel.read(this.buffer);
                this.buffer.flip();
                IOHandlerSeekable.putInto(buf, this.buffer);
            }
        }
        if (buf.position() == 0) {
            throw new EOFException();
        }
        return new ByteList(buf.array(), 0, buf.position(), false);
    }

    private static void putInto(ByteBuffer dest, ByteBuffer src) {
        int destAvail = dest.capacity() - dest.position();
        if (src.remaining() > destAvail) {
            int oldLimit = src.limit();
            src.limit(src.position() + destAvail);
            dest.put(src);
            src.limit(oldLimit);
        } else {
            dest.put(src);
        }
    }

    private void ensureRead() throws IOException {
        if (this.reading) {
            return;
        }
        this.flushWrite();
        this.buffer.clear();
        this.buffer.flip();
        this.reading = true;
    }

    private void ensureWrite() throws IOException {
        if (!this.reading) {
            return;
        }
        if (this.buffer.hasRemaining()) {
            this.channel.position(this.channel.position() - (long)this.buffer.remaining());
        }
        this.buffer.clear();
        this.reading = false;
    }

    @Override
    public int sysread() throws IOException {
        this.ensureRead();
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            int read = this.channel.read(this.buffer);
            this.buffer.flip();
            if (read == -1) {
                return -1;
            }
        }
        return this.buffer.get();
    }

    @Override
    public int syswrite(ByteList buf) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWriteable();
        this.ensureWrite();
        if (buf == null || buf.length() == 0) {
            return 0;
        }
        if (buf.length() > this.buffer.capacity()) {
            this.flushWrite();
            this.channel.write(ByteBuffer.wrap(buf.unsafeBytes(), buf.begin(), buf.length()));
        } else {
            if (buf.length() > this.buffer.remaining()) {
                this.flushWrite();
            }
            this.buffer.put(buf.unsafeBytes(), buf.begin(), buf.length());
        }
        if (this.isSync()) {
            this.sync();
        }
        return buf.realSize;
    }

    @Override
    public int syswrite(int c) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWriteable();
        this.ensureWrite();
        if (!this.buffer.hasRemaining()) {
            this.flushWrite();
        }
        this.buffer.put((byte)c);
        if (this.isSync()) {
            this.sync();
        }
        return 1;
    }

    @Override
    public void truncate(long newLength) throws IOException {
        this.invalidateBuffer();
        this.channel.truncate(newLength);
    }

    @Override
    public FileChannel getFileChannel() {
        return this.channel;
    }

    private void invalidateBuffer() throws IOException {
        if (!this.reading) {
            this.flushWrite();
        }
        int posOverrun = this.buffer.remaining();
        this.buffer.clear();
        if (this.reading) {
            this.buffer.flip();
            if (posOverrun != 0) {
                this.channel.position(this.channel.position() - (long)posOverrun);
            }
        }
    }
}

