/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import org.jruby.util.IOModes;

public abstract class IOHandler {
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    public static final ByteList PARAGRAPH_DELIMETER = ByteList.create("PARAGRPH_DELIM_MRK_ER");
    private Ruby runtime;
    protected IOModes modes;
    protected int fileno;
    protected boolean isOpen = false;
    protected boolean isSync = false;

    protected IOHandler(Ruby runtime) {
        this.runtime = runtime;
    }

    public int getFileno() {
        return this.fileno;
    }

    public void setFileno(int fileno) {
        this.fileno = fileno;
    }

    protected Ruby getRuntime() {
        return this.runtime;
    }

    public abstract FileChannel getFileChannel();

    public boolean isReadable() {
        return this.modes.isReadable();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isWriteable() {
        return this.modes.isWriteable();
    }

    protected void checkOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("not opened");
        }
    }

    protected void checkReadable() throws IOException, BadDescriptorException {
        if (!this.isOpen) {
            throw new BadDescriptorException();
        }
        if (!this.modes.isReadable()) {
            throw new IOException("not opened for reading");
        }
    }

    protected void checkWriteable() throws IOException, BadDescriptorException {
        this.checkWritable();
    }

    protected void checkWritable() throws IOException, BadDescriptorException {
        if (!this.isOpen) {
            throw new BadDescriptorException();
        }
        if (!this.modes.isWriteable()) {
            throw new IOException("not opened for writing");
        }
    }

    public void checkPermissionsSubsetOf(IOModes subsetModes) {
        subsetModes.checkSubsetOf(this.modes);
    }

    public IOModes getModes() {
        return this.modes;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public void setIsSync(boolean isSync) {
        this.isSync = isSync;
    }

    public void reset(IOModes subsetModes) throws IOException, InvalidValueException {
        this.checkPermissionsSubsetOf(subsetModes);
        this.resetByModes(subsetModes);
    }

    public abstract ByteList gets(ByteList var1) throws IOException, BadDescriptorException, EOFException;

    public abstract ByteList getsEntireStream() throws IOException, BadDescriptorException, EOFException;

    public abstract ByteList read(int var1) throws IOException, BadDescriptorException, EOFException;

    public abstract int write(ByteList var1) throws IOException, BadDescriptorException;

    public abstract int getc() throws IOException, BadDescriptorException, EOFException;

    public abstract void ungetc(int var1);

    public abstract void putc(int var1) throws IOException, BadDescriptorException;

    public abstract ByteList sysread(int var1) throws IOException, BadDescriptorException, EOFException;

    public abstract int syswrite(ByteList var1) throws IOException, BadDescriptorException;

    public abstract int syswrite(int var1) throws IOException, BadDescriptorException;

    public abstract IOHandler cloneIOHandler() throws IOException, PipeException, InvalidValueException;

    public abstract void close() throws IOException, BadDescriptorException;

    public abstract void flush() throws IOException, BadDescriptorException;

    public abstract void sync() throws IOException, BadDescriptorException;

    public abstract boolean isEOF() throws IOException, BadDescriptorException;

    public abstract int pid();

    public abstract long pos() throws IOException, PipeException;

    protected abstract void resetByModes(IOModes var1) throws IOException, InvalidValueException;

    public abstract void rewind() throws IOException, PipeException, InvalidValueException;

    public abstract void seek(long var1, int var3) throws IOException, PipeException, InvalidValueException;

    public abstract void truncate(long var1) throws IOException, PipeException;

    public boolean hasPendingBuffered() {
        return false;
    }

    public class InvalidValueException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public class BadDescriptorException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public class PipeException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

