/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CallBlock
extends Block {
    private Arity arity;
    private BlockCallback callback;
    private IRubyObject self;
    private RubyModule imClass;
    private ThreadContext tc;

    public CallBlock(IRubyObject self, RubyModule imClass, Arity arity, BlockCallback callback, ThreadContext ctx) {
        super(null, self, ctx.getCurrentFrame(), ctx.peekCRef(), Visibility.PUBLIC, ctx.getRubyClass(), ctx.getCurrentScope());
        this.arity = arity;
        this.callback = callback;
        this.self = self;
        this.imClass = imClass;
        this.tc = ctx;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        return this.callback.call(context, args, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value) {
        return this.yield(context, value, null, null, false);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        if (klass == null) {
            self = this.self;
            this.frame.setSelf(self);
        }
        this.pre(context, klass);
        try {
            IRubyObject[] args = new IRubyObject[]{value};
            while (true) {
                try {
                    IRubyObject iRubyObject = this.callback.call(context, args, NULL_BLOCK);
                    return iRubyObject;
                }
                catch (JumpException je) {
                    try {
                        if (je.getJumpType() == JumpException.JumpType.RedoJump) {
                            context.pollThreadEvents();
                            continue;
                        }
                        if (je.getJumpType() == JumpException.JumpType.BreakJump && je.getTarget() == null) {
                            je.setTarget(this);
                        }
                        throw je;
                    }
                    catch (JumpException je2) {
                        if (je2.getJumpType() == JumpException.JumpType.NextJump) {
                            IRubyObject iRubyObject = (IRubyObject)je2.getValue();
                            return iRubyObject;
                        }
                        throw je2;
                    }
                }
                break;
            }
        }
        finally {
            this.post(context);
        }
    }

    @Override
    public Block cloneBlock() {
        return new CallBlock(this.self, this.imClass, this.arity, this.callback, this.tc);
    }

    @Override
    public Arity arity() {
        return this.arity;
    }
}

