/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyProc;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.WeakIdentityHashMap;

public class JavaSupport {
    private Ruby runtime;
    private Map exceptionHandlers = new HashMap();
    private JRubyClassLoader javaClassLoader;
    private Map instanceCache = Collections.synchronizedMap(new WeakIdentityHashMap(100));
    private RubyClass javaObjectClass;
    private RubyClass javaArrayClass;

    public JavaSupport(Ruby ruby) {
        this.runtime = ruby;
        this.javaClassLoader = ruby.getJRubyClassLoader();
    }

    public Class loadJavaClass(String className) {
        try {
            Class result = JavaSupport.primitiveClass(className);
            if (result == null) {
                return Ruby.isSecurityRestricted() ? Class.forName(className) : Class.forName(className, true, this.javaClassLoader);
            }
            return result;
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw this.runtime.newNameError("cannot load Java class " + className, className);
        }
    }

    public JavaClass getJavaClassFromCache(Class clazz) {
        WeakReference ref = (WeakReference)this.instanceCache.get(clazz);
        return ref == null ? null : (JavaClass)ref.get();
    }

    public void putJavaClassIntoCache(JavaClass clazz) {
        this.instanceCache.put(clazz.javaClass(), new WeakReference<JavaClass>(clazz));
    }

    public void addToClasspath(URL url) {
        this.javaClassLoader.addURL(url);
    }

    public void defineExceptionHandler(String exceptionClass, RubyProc handler) {
        this.exceptionHandlers.put(exceptionClass, handler);
    }

    public void handleNativeException(Throwable exception) {
        Class<?> excptnClass;
        if (exception instanceof RaiseException) {
            throw (RaiseException)exception;
        }
        RubyProc handler = (RubyProc)this.exceptionHandlers.get(excptnClass.getName());
        for (excptnClass = exception.getClass(); handler == null && excptnClass != Throwable.class; excptnClass = excptnClass.getSuperclass()) {
        }
        if (handler == null) {
            throw this.createRaiseException(exception);
        }
        handler.call(new IRubyObject[]{JavaUtil.convertJavaToRuby(this.runtime, exception)});
    }

    private RaiseException createRaiseException(Throwable exception) {
        RaiseException re = RaiseException.createNativeRaiseException(this.runtime, exception);
        return re;
    }

    private static Class primitiveClass(String name) {
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        return null;
    }

    public ClassLoader getJavaClassLoader() {
        return this.javaClassLoader;
    }

    public JavaObject getJavaObjectFromCache(Object object) {
        WeakReference ref = (WeakReference)this.instanceCache.get(object);
        if (ref == null) {
            return null;
        }
        JavaObject javaObject = (JavaObject)ref.get();
        if (javaObject != null && javaObject.getValue() == object) {
            return javaObject;
        }
        return null;
    }

    public void putJavaObjectIntoCache(JavaObject object) {
        this.instanceCache.put(object.getValue(), new WeakReference<JavaObject>(object));
    }

    public RubyClass getJavaObjectClass() {
        if (this.javaObjectClass == null) {
            this.javaObjectClass = this.runtime.getModule("Java").getClass("JavaObject");
        }
        return this.javaObjectClass;
    }

    public RubyClass getJavaArrayClass() {
        if (this.javaArrayClass == null) {
            this.javaArrayClass = this.runtime.getModule("Java").getClass("JavaArray");
        }
        return this.javaArrayClass;
    }
}

