/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaField
extends JavaAccessibleObject {
    private Field field;

    public static RubyClass createJavaFieldClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaField", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaField.class);
        JavaAccessibleObject.registerRubyMethods(runtime, result);
        result.defineFastMethod("value_type", callbackFactory.getFastMethod("value_type"));
        result.defineFastMethod("public?", callbackFactory.getFastMethod("public_p"));
        result.defineFastMethod("static?", callbackFactory.getFastMethod("static_p"));
        result.defineFastMethod("value", callbackFactory.getFastMethod("value", IRubyObject.class));
        result.defineFastMethod("set_value", callbackFactory.getFastMethod("set_value", IRubyObject.class, IRubyObject.class));
        result.defineFastMethod("set_static_value", callbackFactory.getFastMethod("set_static_value", IRubyObject.class));
        result.defineFastMethod("final?", callbackFactory.getFastMethod("final_p"));
        result.defineFastMethod("static_value", callbackFactory.getFastMethod("static_value"));
        result.defineFastMethod("name", callbackFactory.getFastMethod("name"));
        result.defineFastMethod("==", callbackFactory.getFastMethod("equal", IRubyObject.class));
        result.defineAlias("===", "==");
        return result;
    }

    public JavaField(Ruby runtime, Field field) {
        super(runtime, runtime.getModule("Java").getClass("JavaField"));
        this.field = field;
    }

    public RubyString value_type() {
        return this.getRuntime().newString(this.field.getType().getName());
    }

    @Override
    public IRubyObject equal(IRubyObject other) {
        if (!(other instanceof JavaField)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(this.field.equals(((JavaField)other).field));
    }

    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.field.getModifiers()));
    }

    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(Modifier.isStatic(this.field.getModifiers()));
    }

    public JavaObject value(IRubyObject object) {
        if (!(object instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object");
        }
        Object javaObject = ((JavaObject)object).getValue();
        try {
            return JavaObject.wrap(this.getRuntime(), this.field.get(javaObject));
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access");
        }
    }

    public JavaObject set_value(IRubyObject object, IRubyObject value) {
        if (!(object instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object: " + object);
        }
        if (!(value instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value);
        }
        Object javaObject = ((JavaObject)object).getValue();
        try {
            Object convertedValue = JavaUtil.convertArgument(((JavaObject)value).getValue(), this.field.getType());
            this.field.set(javaObject, convertedValue);
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access on setting variable: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("wrong type for " + this.field.getType().getName() + ": " + ((JavaObject)value).getValue().getClass().getName());
        }
        return (JavaObject)value;
    }

    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.field.getModifiers()));
    }

    public JavaObject static_value() {
        if (Ruby.isSecurityRestricted()) {
            return null;
        }
        try {
            this.field.setAccessible(true);
            return JavaObject.wrap(this.getRuntime(), this.field.get(null));
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal static value access: " + iae.getMessage());
        }
    }

    public JavaObject set_static_value(IRubyObject value) {
        if (!(value instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value);
        }
        try {
            Object convertedValue = JavaUtil.convertArgument(((JavaObject)value).getValue(), this.field.getType());
            this.field.set(null, convertedValue);
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access on setting static variable: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("wrong type for " + this.field.getType().getName() + ": " + ((JavaObject)value).getValue().getClass().getName());
        }
        return (JavaObject)value;
    }

    public RubyString name() {
        return this.getRuntime().newString(this.field.getName());
    }

    @Override
    protected AccessibleObject accesibleObject() {
        return this.field;
    }
}

