/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.IdUtil;
import org.jruby.util.collections.IntHashMap;

public class JavaClass
extends JavaObject {
    private static boolean DEBUG = false;
    private static final Map RESERVED_NAMES = new HashMap();
    private static final Map STATIC_RESERVED_NAMES;
    private static final Map INSTANCE_RESERVED_NAMES;
    private final RubyModule JAVA_UTILITIES = this.getRuntime().getModule("JavaUtilities");
    private Map staticAssignedNames;
    private Map instanceAssignedNames;
    private Map staticCallbacks;
    private Map instanceCallbacks;
    private List constantFields;
    private RubyArray constructors;
    private static final Pattern JAVA_PROPERTY_CHOPPER;
    private static final Pattern CAMEL_CASE_SPLITTER;
    private static final Callback __jsend_method;

    protected Map getStaticAssignedNames() {
        return this.staticAssignedNames;
    }

    protected Map getInstanceAssignedNames() {
        return this.instanceAssignedNames;
    }

    private JavaClass(Ruby runtime, Class javaClass) {
        super(runtime, runtime.getModule("Java").getClass("JavaClass"), javaClass);
        if (javaClass.isInterface()) {
            this.initializeInterface(javaClass);
        } else if (!javaClass.isArray() && !javaClass.isPrimitive()) {
            this.initializeClass(javaClass);
        }
    }

    private void initializeInterface(Class javaClass) {
        Field[] fields;
        HashMap staticNames = new HashMap(STATIC_RESERVED_NAMES);
        ArrayList<ConstantField> constantFields = new ArrayList<ConstantField>();
        try {
            fields = javaClass.getDeclaredFields();
        }
        catch (SecurityException e) {
            fields = javaClass.getFields();
        }
        int i = fields.length;
        while (--i >= 0) {
            Field field = fields[i];
            if (javaClass != field.getDeclaringClass() || !ConstantField.isConstant(field)) continue;
            constantFields.add(new ConstantField(field));
        }
        this.staticAssignedNames = staticNames;
        this.constantFields = constantFields;
    }

    private void initializeClass(Class javaClass) {
        AssignedName assignedName;
        HashMap<String, AssignedName> instanceNames;
        HashMap<String, AssignedName> staticNames;
        Class superclass = javaClass.getSuperclass();
        if (superclass == null) {
            staticNames = new HashMap<String, AssignedName>();
            instanceNames = new HashMap<String, AssignedName>();
        } else {
            JavaClass superJavaClass = JavaClass.get(this.getRuntime(), superclass);
            staticNames = new HashMap(superJavaClass.getStaticAssignedNames());
            instanceNames = new HashMap(superJavaClass.getInstanceAssignedNames());
        }
        staticNames.putAll(STATIC_RESERVED_NAMES);
        instanceNames.putAll(INSTANCE_RESERVED_NAMES);
        HashMap<String, NamedCallback> staticCallbacks = new HashMap<String, NamedCallback>();
        HashMap<String, NamedCallback> instanceCallbacks = new HashMap<String, NamedCallback>();
        ArrayList<ConstantField> constantFields = new ArrayList<ConstantField>();
        Field[] fields = javaClass.getFields();
        int i = fields.length;
        while (--i >= 0) {
            String setName;
            Field field = fields[i];
            if (javaClass != field.getDeclaringClass()) continue;
            if (ConstantField.isConstant(field)) {
                constantFields.add(new ConstantField(field));
                continue;
            }
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                assignedName = (AssignedName)staticNames.get(name);
                if (assignedName != null && assignedName.type < 2) continue;
                staticNames.put(name, new AssignedName(name, 2));
                staticCallbacks.put(name, new StaticFieldGetter(name, field));
                if (Modifier.isFinal(modifiers)) continue;
                setName = name + '=';
                staticCallbacks.put(setName, new StaticFieldSetter(setName, field));
                continue;
            }
            assignedName = (AssignedName)instanceNames.get(name);
            if (assignedName != null && assignedName.type < 2) continue;
            instanceNames.put(name, new AssignedName(name, 2));
            instanceCallbacks.put(name, new InstanceFieldGetter(name, field));
            if (Modifier.isFinal(modifiers)) continue;
            setName = name + '=';
            instanceCallbacks.put(setName, new InstanceFieldSetter(setName, field));
        }
        Method[] methods = javaClass.getMethods();
        int i2 = methods.length;
        while (--i2 >= 0) {
            MethodCallback invoker;
            Method method = methods[i2];
            String name = method.getName();
            if (Modifier.isStatic(method.getModifiers())) {
                assignedName = (AssignedName)staticNames.get(name);
                if (assignedName == null) {
                    staticNames.put(name, new AssignedName(name, 1));
                } else {
                    if (assignedName.type < 1) continue;
                    if (assignedName.type != 1) {
                        staticCallbacks.remove(name);
                        staticCallbacks.remove(name + '=');
                        staticNames.put(name, new AssignedName(name, 1));
                    }
                }
                invoker = (StaticMethodInvoker)staticCallbacks.get(name);
                if (invoker == null) {
                    invoker = new StaticMethodInvoker(name);
                    staticCallbacks.put(name, invoker);
                }
                invoker.addMethod(method, javaClass);
                continue;
            }
            assignedName = (AssignedName)instanceNames.get(name);
            if (assignedName == null) {
                instanceNames.put(name, new AssignedName(name, 1));
            } else {
                if (assignedName.type < 1) continue;
                if (assignedName.type != 1) {
                    instanceCallbacks.remove(name);
                    instanceCallbacks.remove(name + '=');
                    instanceNames.put(name, new AssignedName(name, 1));
                }
            }
            invoker = (InstanceMethodInvoker)instanceCallbacks.get(name);
            if (invoker == null) {
                invoker = new InstanceMethodInvoker(name);
                instanceCallbacks.put(name, invoker);
            }
            invoker.addMethod(method, javaClass);
        }
        this.staticAssignedNames = staticNames;
        this.instanceAssignedNames = instanceNames;
        this.staticCallbacks = staticCallbacks;
        this.instanceCallbacks = instanceCallbacks;
        this.constantFields = constantFields;
    }

    public void setupProxy(RubyClass proxy) {
        proxy.defineFastMethod("__jsend!", __jsend_method);
        Class javaClass = this.javaClass();
        if (javaClass.isInterface()) {
            this.setupInterfaceProxy(proxy);
            return;
        }
        if (javaClass.isArray() || javaClass.isPrimitive()) {
            return;
        }
        Iterator<Object> iter = this.constantFields.iterator();
        while (iter.hasNext()) {
            ((ConstantField)iter.next()).install(proxy);
        }
        for (NamedCallback callback : this.staticCallbacks.values()) {
            if (callback.type == 2 && callback.hasLocalMethod()) {
                JavaClass.assignAliases((MethodCallback)callback, this.staticAssignedNames);
            }
            callback.install(proxy);
        }
        for (NamedCallback callback : this.instanceCallbacks.values()) {
            if (callback.type == 4 && callback.hasLocalMethod()) {
                JavaClass.assignAliases((MethodCallback)callback, this.instanceAssignedNames);
            }
            callback.install(proxy);
        }
        Class<?>[] classes = javaClass.getClasses();
        int i = classes.length;
        while (--i >= 0) {
            Class<?> clazz;
            String simpleName;
            if (javaClass != classes[i].getDeclaringClass() || (simpleName = JavaClass.getSimpleName(clazz = classes[i])).length() == 0 || !IdUtil.isConstant(simpleName) || proxy.getConstantAt(simpleName) != null) continue;
            proxy.const_set(this.getRuntime().newString(simpleName), Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz)));
        }
    }

    private static void assignAliases(MethodCallback callback, Map assignedNames) {
        String name = callback.name;
        JavaClass.addUnassignedAlias(JavaClass.getRubyCasedName(name), assignedNames, callback);
        if (name.length() <= 3 && !name.startsWith("is")) {
            return;
        }
        String javaPropertyName = JavaClass.getJavaPropertyName(name);
        if (javaPropertyName == null) {
            return;
        }
        for (Method method : callback.methods) {
            String rubyName;
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            if (argCount == 0) {
                if (name.startsWith("get")) {
                    JavaClass.addUnassignedAlias(JavaClass.getRubyCasedName(javaPropertyName), assignedNames, callback);
                    JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, callback);
                    continue;
                }
                if (resultType != Boolean.TYPE || !name.startsWith("is")) continue;
                rubyName = JavaClass.getRubyCasedName(name.substring(2));
                if (rubyName != null) {
                    JavaClass.addUnassignedAlias(rubyName, assignedNames, callback);
                    JavaClass.addUnassignedAlias(rubyName + '?', assignedNames, callback);
                }
                if (javaPropertyName.equals(rubyName)) continue;
                JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, callback);
                JavaClass.addUnassignedAlias(javaPropertyName + '?', assignedNames, callback);
                continue;
            }
            if (argCount != 1) continue;
            if (argTypes[0] == Integer.TYPE && name.startsWith("get")) {
                JavaClass.addUnassignedAlias(JavaClass.getRubyCasedName(name.substring(3)), assignedNames, callback);
                JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, callback);
                continue;
            }
            if (resultType != Void.TYPE || !name.startsWith("set")) continue;
            rubyName = JavaClass.getRubyCasedName(name.substring(3));
            if (rubyName != null) {
                JavaClass.addUnassignedAlias(rubyName + '=', assignedNames, callback);
            }
            if (javaPropertyName.equals(rubyName)) continue;
            JavaClass.addUnassignedAlias(javaPropertyName + '=', assignedNames, callback);
        }
    }

    private static void addUnassignedAlias(String name, Map assignedNames, MethodCallback callback) {
        if (name != null) {
            AssignedName assignedName = (AssignedName)assignedNames.get(name);
            if (assignedName == null) {
                callback.addAlias(name);
                assignedNames.put(name, new AssignedName(name, 5));
            } else if (assignedName.type == 5) {
                callback.addAlias(name);
            } else if (assignedName.type > 5) {
                callback.addAlias(name);
                assignedNames.put(name, new AssignedName(name, 5));
            }
        }
    }

    public static String getJavaPropertyName(String beanMethodName) {
        Matcher m = JAVA_PROPERTY_CHOPPER.matcher(beanMethodName);
        if (!m.find()) {
            return null;
        }
        String javaPropertyName = m.group(2).toLowerCase() + m.group(3);
        return javaPropertyName;
    }

    public static String getRubyCasedName(String javaCasedName) {
        Matcher m = CAMEL_CASE_SPLITTER.matcher(javaCasedName);
        String rubyCasedName = m.replaceAll("$1_$2").toLowerCase();
        if (rubyCasedName.equals(javaCasedName)) {
            return null;
        }
        return rubyCasedName;
    }

    public void setupInterfaceProxy(RubyClass proxy) {
        Class javaClass = this.javaClass();
        Iterator iter = this.constantFields.iterator();
        while (iter.hasNext()) {
            ((ConstantField)iter.next()).install(proxy);
        }
        Class<?>[] classes = javaClass.getClasses();
        int i = classes.length;
        while (--i >= 0) {
            Class<?> clazz;
            String simpleName;
            if (javaClass != classes[i].getDeclaringClass() || (simpleName = JavaClass.getSimpleName(clazz = classes[i])).length() == 0 || !IdUtil.isConstant(simpleName) || proxy.getConstantAt(simpleName) != null) continue;
            proxy.const_set(this.getRuntime().newString(simpleName), Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz)));
        }
    }

    public void setupInterfaceModule(RubyModule module) {
        Class javaClass = this.javaClass();
        Iterator iter = this.constantFields.iterator();
        while (iter.hasNext()) {
            ((ConstantField)iter.next()).install(module);
        }
        Class<?>[] classes = javaClass.getClasses();
        int i = classes.length;
        while (--i >= 0) {
            Class<?> clazz;
            String simpleName;
            if (javaClass != classes[i].getDeclaringClass() || (simpleName = JavaClass.getSimpleName(clazz = classes[i])).length() == 0 || !IdUtil.isConstant(simpleName) || module.getConstantAt(simpleName) != null) continue;
            module.const_set(this.getRuntime().newString(simpleName), Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz)));
        }
    }

    public static JavaClass get(Ruby runtime, Class klass) {
        JavaClass javaClass = runtime.getJavaSupport().getJavaClassFromCache(klass);
        if (javaClass == null) {
            javaClass = JavaClass.createJavaClass(runtime, klass);
        }
        return javaClass;
    }

    private static synchronized JavaClass createJavaClass(Ruby runtime, Class klass) {
        JavaClass javaClass = runtime.getJavaSupport().getJavaClassFromCache(klass);
        if (javaClass == null) {
            javaClass = new JavaClass(runtime, klass);
            runtime.getJavaSupport().putJavaClassIntoCache(javaClass);
        }
        return javaClass;
    }

    public static RubyClass createJavaClassClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaClass", javaModule.getClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaClass.class);
        result.includeModule(runtime.getModule("Comparable"));
        JavaObject.registerRubyMethods(runtime, result);
        result.getMetaClass().defineFastMethod("for_name", callbackFactory.getFastSingletonMethod("for_name", IRubyObject.class));
        result.defineFastMethod("public?", callbackFactory.getFastMethod("public_p"));
        result.defineFastMethod("protected?", callbackFactory.getFastMethod("protected_p"));
        result.defineFastMethod("private?", callbackFactory.getFastMethod("private_p"));
        result.defineFastMethod("final?", callbackFactory.getFastMethod("final_p"));
        result.defineFastMethod("interface?", callbackFactory.getFastMethod("interface_p"));
        result.defineFastMethod("array?", callbackFactory.getFastMethod("array_p"));
        result.defineFastMethod("name", callbackFactory.getFastMethod("name"));
        result.defineFastMethod("simple_name", callbackFactory.getFastMethod("simple_name"));
        result.defineFastMethod("to_s", callbackFactory.getFastMethod("name"));
        result.defineFastMethod("superclass", callbackFactory.getFastMethod("superclass"));
        result.defineFastMethod("<=>", callbackFactory.getFastMethod("op_cmp", IRubyObject.class));
        result.defineFastMethod("java_instance_methods", callbackFactory.getFastMethod("java_instance_methods"));
        result.defineFastMethod("java_class_methods", callbackFactory.getFastMethod("java_class_methods"));
        result.defineFastMethod("java_method", callbackFactory.getFastOptMethod("java_method"));
        result.defineFastMethod("constructors", callbackFactory.getFastMethod("constructors"));
        result.defineFastMethod("constructor", callbackFactory.getFastOptMethod("constructor"));
        result.defineFastMethod("array_class", callbackFactory.getFastMethod("array_class"));
        result.defineFastMethod("new_array", callbackFactory.getFastMethod("new_array", IRubyObject.class));
        result.defineFastMethod("fields", callbackFactory.getFastMethod("fields"));
        result.defineFastMethod("field", callbackFactory.getFastMethod("field", IRubyObject.class));
        result.defineFastMethod("interfaces", callbackFactory.getFastMethod("interfaces"));
        result.defineFastMethod("primitive?", callbackFactory.getFastMethod("primitive_p"));
        result.defineFastMethod("assignable_from?", callbackFactory.getFastMethod("assignable_from_p", IRubyObject.class));
        result.defineFastMethod("component_type", callbackFactory.getFastMethod("component_type"));
        result.defineFastMethod("declared_instance_methods", callbackFactory.getFastMethod("declared_instance_methods"));
        result.defineFastMethod("declared_class_methods", callbackFactory.getFastMethod("declared_class_methods"));
        result.defineFastMethod("declared_fields", callbackFactory.getFastMethod("declared_fields"));
        result.defineFastMethod("declared_field", callbackFactory.getFastMethod("declared_field", IRubyObject.class));
        result.defineFastMethod("declared_constructors", callbackFactory.getFastMethod("declared_constructors"));
        result.defineFastMethod("declared_constructor", callbackFactory.getFastOptMethod("declared_constructor"));
        result.defineFastMethod("declared_classes", callbackFactory.getFastMethod("declared_classes"));
        result.defineFastMethod("declared_method", callbackFactory.getFastOptMethod("declared_method"));
        result.defineFastMethod("define_instance_methods_for_proxy", callbackFactory.getFastMethod("define_instance_methods_for_proxy", IRubyObject.class));
        result.getMetaClass().undefineMethod("new");
        result.getMetaClass().undefineMethod("allocate");
        return result;
    }

    public static synchronized JavaClass for_name(IRubyObject recv, IRubyObject name) {
        String className = name.asSymbol();
        Class klass = recv.getRuntime().getJavaSupport().loadJavaClass(className);
        return JavaClass.get(recv.getRuntime(), klass);
    }

    private Set getPublicFieldNames(boolean isStatic) {
        int mask = 9;
        int want = isStatic ? 9 : 1;
        HashSet<String> names = new HashSet<String>();
        names.add("class");
        Field[] fields = ((Class)this.getValue()).getFields();
        int i = fields.length;
        while (--i >= 0) {
            if ((fields[i].getModifiers() & mask) != want) continue;
            names.add(fields[i].getName());
        }
        return names;
    }

    private Map getMethodsClumped(boolean isStatic, Set assignedNames) {
        System.out.println("JC.gmc");
        HashMap<String, RubyArray> map = new HashMap<String, RubyArray>();
        if (((Class)this.getValue()).isInterface()) {
            return map;
        }
        Method[] methods = this.javaClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (isStatic != Modifier.isStatic(methods[i].getModifiers())) continue;
            String key = methods[i].getName();
            RubyArray methodsWithName = (RubyArray)map.get(key);
            if (methodsWithName == null) {
                methodsWithName = RubyArray.newArrayLight(this.getRuntime());
                map.put(key, methodsWithName);
                assignedNames.add(key);
            }
            methodsWithName.append(JavaMethod.create(this.getRuntime(), methods[i]));
        }
        return map;
    }

    private Map getPropertysClumped(Set assignedNames) {
        BeanInfo info;
        System.out.println("JC.gpc");
        HashMap map = new HashMap();
        try {
            info = Introspector.getBeanInfo(this.javaClass());
        }
        catch (IntrospectionException e) {
            return map;
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        System.out.println("got bean info for class " + this.javaClass().getName() + ": " + descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            Method writeMethod;
            Method readMethod = descriptors[i].getReadMethod();
            if (readMethod != null) {
                String key = readMethod.getName();
                ArrayList<String> aliases = (ArrayList<String>)map.get(key);
                if (aliases == null) {
                    aliases = new ArrayList<String>();
                    map.put(key, aliases);
                }
                if (readMethod.getReturnType() == Boolean.class || readMethod.getReturnType() == Boolean.TYPE) {
                    aliases.add(descriptors[i].getName() + "?");
                }
                if (!assignedNames.contains(descriptors[i].getName())) {
                    aliases.add(descriptors[i].getName());
                }
            }
            if ((writeMethod = descriptors[i].getWriteMethod()) == null) continue;
            String key = writeMethod.getName();
            ArrayList<String> aliases = (ArrayList<String>)map.get(key);
            if (aliases == null) {
                aliases = new ArrayList<String>();
                map.put(key, aliases);
            }
            if (assignedNames.contains(descriptors[i].getName())) continue;
            aliases.add(descriptors[i].getName() + "=");
        }
        return map;
    }

    private void define_instance_method_for_proxy(final RubyClass proxy, List names, final RubyArray methods) {
        Callback method;
        final RubyModule javaUtilities = this.getRuntime().getModule("JavaUtilities");
        if (methods.size() > 1) {
            method = new Callback(){
                private IntHashMap matchingMethods = new IntHashMap();

                @Override
                public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                    int len = args.length;
                    IRubyObject[] argsArray = new IRubyObject[len + 1];
                    argsArray[0] = self.getInstanceVariable("@java_object");
                    int argsTypeHash = 0;
                    for (int j = 0; j < len; ++j) {
                        argsArray[j + 1] = Java.ruby_to_java(proxy, args[j], Block.NULL_BLOCK);
                        argsTypeHash += 3 * args[j].getMetaClass().id;
                    }
                    IRubyObject match = (IRubyObject)this.matchingMethods.get(argsTypeHash);
                    if (match == null) {
                        match = Java.matching_method_internal(javaUtilities, methods, argsArray, 1, len);
                        this.matchingMethods.put(argsTypeHash, match);
                    }
                    return Java.java_to_ruby(self, ((JavaMethod)match).invoke(argsArray), Block.NULL_BLOCK);
                }

                @Override
                public Arity getArity() {
                    return Arity.optional();
                }
            };
        } else {
            final JavaMethod METHOD = (JavaMethod)methods.eltInternal(0);
            method = new Callback(){

                @Override
                public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                    int len = args.length;
                    IRubyObject[] argsArray = new IRubyObject[len + 1];
                    argsArray[0] = self.getInstanceVariable("@java_object");
                    for (int j = 0; j < len; ++j) {
                        argsArray[j + 1] = Java.ruby_to_java(proxy, args[j], Block.NULL_BLOCK);
                    }
                    return Java.java_to_ruby(self, METHOD.invoke(argsArray), Block.NULL_BLOCK);
                }

                @Override
                public Arity getArity() {
                    return Arity.optional();
                }
            };
        }
        for (String methodName : names) {
            if (methodName.equals("class")) continue;
            proxy.defineFastMethod(methodName, method);
            String rubyCasedName = JavaClass.getRubyCasedName(methodName);
            if (rubyCasedName == null) continue;
            proxy.defineAlias(rubyCasedName, methodName);
        }
    }

    public IRubyObject define_instance_methods_for_proxy(IRubyObject arg) {
        assert (arg instanceof RubyClass);
        System.out.println("JC.define_instance_methods_for_proxy");
        Set assignedNames = this.getPublicFieldNames(false);
        Map methodsClump = this.getMethodsClumped(false, assignedNames);
        Map aliasesClump = this.getPropertysClumped(assignedNames);
        RubyClass proxy = (RubyClass)arg;
        proxy.defineFastMethod("__jsend!", __jsend_method);
        for (String name : methodsClump.keySet()) {
            RubyArray methods = (RubyArray)methodsClump.get(name);
            ArrayList<String> aliases = (ArrayList<String>)aliasesClump.get(name);
            if (aliases == null) {
                aliases = new ArrayList<String>();
            }
            aliases.add(name);
            this.define_instance_method_for_proxy(proxy, aliases, methods);
        }
        return this.getRuntime().getNil();
    }

    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.javaClass().getModifiers()));
    }

    public RubyBoolean protected_p() {
        return this.getRuntime().newBoolean(Modifier.isProtected(this.javaClass().getModifiers()));
    }

    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(Modifier.isPrivate(this.javaClass().getModifiers()));
    }

    public Class javaClass() {
        return (Class)this.getValue();
    }

    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.javaClass().getModifiers()));
    }

    public RubyBoolean interface_p() {
        return this.getRuntime().newBoolean(this.javaClass().isInterface());
    }

    public RubyBoolean array_p() {
        return this.getRuntime().newBoolean(this.javaClass().isArray());
    }

    public RubyString name() {
        return this.getRuntime().newString(this.javaClass().getName());
    }

    private static String getSimpleName(Class class_) {
        if (class_.isArray()) {
            return JavaClass.getSimpleName(class_.getComponentType()) + "[]";
        }
        String className = class_.getName();
        int i = className.lastIndexOf(36);
        if (i != -1) {
            while (++i < className.length() && Character.isDigit(className.charAt(i))) {
            }
            return className.substring(i);
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public RubyString simple_name() {
        return this.getRuntime().newString(JavaClass.getSimpleName(this.javaClass()));
    }

    public IRubyObject superclass() {
        Class superclass = this.javaClass().getSuperclass();
        if (superclass == null) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), superclass);
    }

    public RubyFixnum op_cmp(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("<=> requires JavaClass (" + other.getType() + " given)");
        }
        JavaClass otherClass = (JavaClass)other;
        if (this.javaClass() == otherClass.javaClass()) {
            return this.getRuntime().newFixnum(0L);
        }
        if (otherClass.javaClass().isAssignableFrom(this.javaClass())) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().newFixnum(1L);
    }

    public RubyArray java_instance_methods() {
        return this.java_methods(this.javaClass().getMethods(), false);
    }

    public RubyArray declared_instance_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), false);
    }

    private RubyArray java_methods(Method[] methods, boolean isStatic) {
        RubyArray result = this.getRuntime().newArray(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (isStatic != Modifier.isStatic(method.getModifiers())) continue;
            result.append(JavaMethod.create(this.getRuntime(), method));
        }
        return result;
    }

    public RubyArray java_class_methods() {
        return this.java_methods(this.javaClass().getMethods(), true);
    }

    public RubyArray declared_class_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), true);
    }

    public JavaMethod java_method(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asSymbol();
        Class[] argumentTypes = this.buildArgumentTypes(args);
        return JavaMethod.create(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    public JavaMethod declared_method(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asSymbol();
        Class[] argumentTypes = this.buildArgumentTypes(args);
        return JavaMethod.createDeclared(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    private Class[] buildArgumentTypes(IRubyObject[] args) throws ClassNotFoundException {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError(args.length, 1);
        }
        Class[] argumentTypes = new Class[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            JavaClass type = JavaClass.for_name(this, args[i]);
            argumentTypes[i - 1] = type.javaClass();
        }
        return argumentTypes;
    }

    public RubyArray constructors() {
        if (this.constructors == null) {
            this.constructors = this.buildConstructors(this.javaClass().getConstructors());
        }
        return this.constructors;
    }

    public RubyArray declared_classes() {
        if (Ruby.isSecurityRestricted()) {
            return this.getRuntime().newArray(0);
        }
        Class<?>[] classes = this.javaClass().getDeclaredClasses();
        ArrayList accessibleClasses = new ArrayList();
        for (int i = 0; i < classes.length; ++i) {
            if (!Modifier.isPublic(classes[i].getModifiers())) continue;
            accessibleClasses.add(classes[i]);
        }
        return this.buildClasses(accessibleClasses.toArray(new Class[accessibleClasses.size()]));
    }

    private RubyArray buildClasses(Class[] classes) {
        RubyArray result = this.getRuntime().newArray(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            result.append(new JavaClass(this.getRuntime(), classes[i]));
        }
        return result;
    }

    public RubyArray declared_constructors() {
        return this.buildConstructors(this.javaClass().getDeclaredConstructors());
    }

    private RubyArray buildConstructors(Constructor[] constructors) {
        RubyArray result = this.getRuntime().newArray(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            result.append(new JavaConstructor(this.getRuntime(), constructors[i]));
        }
        return result;
    }

    public JavaConstructor constructor(IRubyObject[] args) {
        try {
            Class[] parameterTypes = this.buildClassArgs(args);
            Constructor constructor = this.javaClass().getConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    public JavaConstructor declared_constructor(IRubyObject[] args) {
        try {
            Class[] parameterTypes = this.buildClassArgs(args);
            Constructor constructor = this.javaClass().getDeclaredConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    private Class[] buildClassArgs(IRubyObject[] args) {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            String name = args[i].asSymbol();
            parameterTypes[i] = this.getRuntime().getJavaSupport().loadJavaClass(name);
        }
        return parameterTypes;
    }

    public JavaClass array_class() {
        return JavaClass.get(this.getRuntime(), Array.newInstance(this.javaClass(), 0).getClass());
    }

    public JavaObject new_array(IRubyObject lengthArgument) {
        if (lengthArgument instanceof RubyInteger) {
            int length = (int)((RubyInteger)lengthArgument).getLongValue();
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), length));
        }
        if (lengthArgument instanceof RubyArray) {
            List list = ((RubyArray)lengthArgument).getList();
            int length = list.size();
            if (length == 0) {
                throw this.getRuntime().newArgumentError("empty dimensions specifier for java array");
            }
            int[] dimensions = new int[length];
            int i = length;
            while (--i >= 0) {
                IRubyObject dimensionLength = (IRubyObject)list.get(i);
                if (!(dimensionLength instanceof RubyInteger)) {
                    throw this.getRuntime().newTypeError(dimensionLength, this.getRuntime().getClass("Integer"));
                }
                dimensions[i] = (int)((RubyInteger)dimensionLength).getLongValue();
            }
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), dimensions));
        }
        throw this.getRuntime().newArgumentError("invalid length or dimensions specifier for java array - must be Integer or Array of Integer");
    }

    public RubyArray fields() {
        return this.buildFieldResults(this.javaClass().getFields());
    }

    public RubyArray declared_fields() {
        return this.buildFieldResults(this.javaClass().getDeclaredFields());
    }

    private RubyArray buildFieldResults(Field[] fields) {
        RubyArray result = this.getRuntime().newArray(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            result.append(new JavaField(this.getRuntime(), fields[i]));
        }
        return result;
    }

    public JavaField field(IRubyObject name) {
        String stringName = name.asSymbol();
        try {
            Field field = this.javaClass().getField(stringName);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException nsfe) {
            throw this.undefinedFieldError(stringName);
        }
    }

    public JavaField declared_field(IRubyObject name) {
        String stringName = name.asSymbol();
        try {
            Field field = this.javaClass().getDeclaredField(stringName);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException nsfe) {
            throw this.undefinedFieldError(stringName);
        }
    }

    private RaiseException undefinedFieldError(String name) {
        return this.getRuntime().newNameError("undefined field '" + name + "' for class '" + this.javaClass().getName() + "'", name);
    }

    public RubyArray interfaces() {
        Class<?>[] interfaces = this.javaClass().getInterfaces();
        RubyArray result = this.getRuntime().newArray(interfaces.length);
        for (int i = 0; i < interfaces.length; ++i) {
            result.append(JavaClass.get(this.getRuntime(), interfaces[i]));
        }
        return result;
    }

    public RubyBoolean primitive_p() {
        return this.getRuntime().newBoolean(this.isPrimitive());
    }

    public RubyBoolean assignable_from_p(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("assignable_from requires JavaClass (" + other.getType() + " given)");
        }
        Class otherClass = ((JavaClass)other).javaClass();
        return JavaClass.assignable(this.javaClass(), otherClass) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    static boolean assignable(Class thisClass, Class otherClass) {
        if (!thisClass.isPrimitive() && otherClass == Void.TYPE || thisClass.isAssignableFrom(otherClass)) {
            return true;
        }
        otherClass = JavaUtil.primitiveToWrapper(otherClass);
        if ((thisClass = JavaUtil.primitiveToWrapper(thisClass)).isAssignableFrom(otherClass)) {
            return true;
        }
        if (Number.class.isAssignableFrom(thisClass)) {
            if (Number.class.isAssignableFrom(otherClass)) {
                return true;
            }
            if (otherClass.equals(Character.class)) {
                return true;
            }
        }
        return thisClass.equals(Character.class) && Number.class.isAssignableFrom(otherClass);
    }

    private boolean isPrimitive() {
        return this.javaClass().isPrimitive();
    }

    public JavaClass component_type() {
        if (!this.javaClass().isArray()) {
            throw this.getRuntime().newTypeError("not a java array-class");
        }
        return JavaClass.get(this.getRuntime(), this.javaClass().getComponentType());
    }

    static {
        RESERVED_NAMES.put("__id__", new AssignedName("__id__", 0));
        RESERVED_NAMES.put("__send__", new AssignedName("__send__", 0));
        RESERVED_NAMES.put("class", new AssignedName("class", 0));
        RESERVED_NAMES.put("initialize", new AssignedName("initialize", 0));
        RESERVED_NAMES.put("object_id", new AssignedName("object_id", 0));
        RESERVED_NAMES.put("private", new AssignedName("private", 0));
        RESERVED_NAMES.put("protected", new AssignedName("protected", 0));
        RESERVED_NAMES.put("public", new AssignedName("public", 0));
        RESERVED_NAMES.put("id", new AssignedName("id", 4));
        STATIC_RESERVED_NAMES = new HashMap(RESERVED_NAMES);
        STATIC_RESERVED_NAMES.put("new", new AssignedName("new", 0));
        INSTANCE_RESERVED_NAMES = new HashMap(RESERVED_NAMES);
        JAVA_PROPERTY_CHOPPER = Pattern.compile("(get|set|is)([A-Z0-9])(.*)");
        CAMEL_CASE_SPLITTER = Pattern.compile("([a-z])([A-Z])");
        __jsend_method = new Callback(){

            @Override
            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                String name = args[0].asSymbol();
                RubyMethod method = (RubyMethod)self.getMetaClass().newMethod(self, name, true);
                int v = RubyNumeric.fix2int(method.arity());
                IRubyObject[] newArgs = new IRubyObject[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                if (DEBUG) {
                    System.out.println("__jsend method => '" + name + "'; arity = " + v + ", args.length = " + newArgs.length);
                }
                if (v < 0 || v == newArgs.length) {
                    if (DEBUG) {
                        System.out.println("  calling self");
                    }
                    return self.callMethod(self.getRuntime().getCurrentContext(), name, newArgs, CallType.FUNCTIONAL, block);
                }
                if (DEBUG) {
                    System.out.println("  calling super");
                }
                return self.callMethod(self.getRuntime().getCurrentContext(), self.getMetaClass().getSuperClass(), name, newArgs, CallType.SUPER, block);
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        };
    }

    private static class ConstantField {
        static final int CONSTANT = 25;
        Field field;

        ConstantField(Field field) {
            this.field = field;
        }

        void install(RubyModule proxy) {
            if (proxy.getConstantAt(this.field.getName()) == null) {
                JavaField javaField = new JavaField(proxy.getRuntime(), this.field);
                RubyString name = javaField.name();
                proxy.const_set(name, Java.java_to_ruby(proxy, javaField.static_value(), Block.NULL_BLOCK));
            }
        }

        static boolean isConstant(Field field) {
            return (field.getModifiers() & 0x19) == 25 && Character.isUpperCase(field.getName().charAt(0));
        }
    }

    private class InstanceMethodInvoker
    extends MethodCallback {
        InstanceMethodInvoker() {
        }

        InstanceMethodInvoker(String name) {
            super(name, 4);
        }

        @Override
        void install(RubyClass proxy) {
            if (this.haveLocalMethod) {
                proxy.defineFastMethod(this.name, this, this.visibility);
                if (this.aliases != null && this.isPublic()) {
                    Iterator iter = this.aliases.iterator();
                    while (iter.hasNext()) {
                        proxy.defineAlias((String)iter.next(), this.name);
                    }
                    this.aliases = null;
                }
            }
        }

        @Override
        public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            this.logMessage(self, args);
            if (this.javaMethod == null && this.javaMethods == null) {
                this.createJavaMethods(self.getRuntime());
            }
            int len = args.length;
            IRubyObject[] convertedArgs = new IRubyObject[len + 1];
            convertedArgs[0] = self.getInstanceVariable("@java_object");
            int i = len;
            while (--i >= 0) {
                convertedArgs[i + 1] = Java.ruby_to_java(self, args[i], Block.NULL_BLOCK);
            }
            if (this.javaMethods == null) {
                return Java.java_to_ruby(self, this.javaMethod.invoke(convertedArgs), Block.NULL_BLOCK);
            }
            int argsTypeHash = 0;
            int i2 = len;
            while (--i2 >= 0) {
                argsTypeHash += 3 * args[i2].getMetaClass().id;
            }
            IRubyObject match = (IRubyObject)this.matchingMethods.get(argsTypeHash);
            if (match == null) {
                RubyArray methods = (RubyArray)this.javaMethods.get(len);
                if (methods == null) {
                    this.raiseNoMatchingMethodError(self, convertedArgs, 1);
                }
                match = Java.matching_method_internal(JavaClass.this.JAVA_UTILITIES, methods, convertedArgs, 1, len);
                this.matchingMethods.put(argsTypeHash, match);
            }
            return Java.java_to_ruby(self, ((JavaMethod)match).invoke(convertedArgs), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.OPTIONAL;
        }
    }

    private class StaticMethodInvoker
    extends MethodCallback {
        StaticMethodInvoker() {
        }

        StaticMethodInvoker(String name) {
            super(name, 2);
        }

        @Override
        void install(RubyClass proxy) {
            if (this.haveLocalMethod) {
                RubyClass singleton = proxy.getSingletonClass();
                singleton.defineFastMethod(this.name, this, this.visibility);
                if (this.aliases != null && this.isPublic()) {
                    Iterator iter = this.aliases.iterator();
                    while (iter.hasNext()) {
                        singleton.defineAlias((String)iter.next(), this.name);
                    }
                    this.aliases = null;
                }
            }
        }

        @Override
        public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            this.logMessage(self, args);
            if (this.javaMethod == null && this.javaMethods == null) {
                this.createJavaMethods(self.getRuntime());
            }
            int len = args.length;
            IRubyObject[] convertedArgs = new IRubyObject[len];
            int i = len;
            while (--i >= 0) {
                convertedArgs[i] = Java.ruby_to_java(self, args[i], Block.NULL_BLOCK);
            }
            if (this.javaMethods == null) {
                return Java.java_to_ruby(self, this.javaMethod.invoke_static(convertedArgs), Block.NULL_BLOCK);
            }
            int argsTypeHash = 0;
            int i2 = len;
            while (--i2 >= 0) {
                argsTypeHash += 3 * args[i2].getMetaClass().id;
            }
            IRubyObject match = (IRubyObject)this.matchingMethods.get(argsTypeHash);
            if (match == null) {
                RubyArray methods = (RubyArray)this.javaMethods.get(len);
                if (methods == null) {
                    this.raiseNoMatchingMethodError(self, convertedArgs, 0);
                }
                match = Java.matching_method_internal(JavaClass.this.JAVA_UTILITIES, methods, convertedArgs, 0, len);
            }
            return Java.java_to_ruby(self, ((JavaMethod)match).invoke_static(convertedArgs), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.OPTIONAL;
        }
    }

    private static abstract class MethodCallback
    extends NamedCallback {
        boolean haveLocalMethod;
        List methods;
        List aliases;
        IntHashMap javaMethods;
        IntHashMap matchingMethods;
        JavaMethod javaMethod;

        MethodCallback() {
        }

        MethodCallback(String name, int type) {
            super(name, type);
        }

        void addMethod(Method method, Class javaClass) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.add(method);
            this.haveLocalMethod |= javaClass == method.getDeclaringClass();
        }

        void addAlias(String alias) {
            if (this.aliases == null) {
                this.aliases = new ArrayList();
            }
            if (!this.aliases.contains(alias)) {
                this.aliases.add(alias);
            }
        }

        @Override
        boolean hasLocalMethod() {
            return this.haveLocalMethod;
        }

        void createJavaMethods(Ruby runtime) {
            if (this.methods != null) {
                if (this.methods.size() == 1) {
                    this.javaMethod = JavaMethod.create(runtime, (Method)this.methods.get(0));
                } else {
                    this.javaMethods = new IntHashMap();
                    this.matchingMethods = new IntHashMap();
                    for (Method method : this.methods) {
                        int arity = method.getParameterTypes().length;
                        RubyArray methodsForArity = (RubyArray)this.javaMethods.get(arity);
                        if (methodsForArity == null) {
                            methodsForArity = RubyArray.newArrayLight(runtime);
                            this.javaMethods.put(arity, methodsForArity);
                        }
                        methodsForArity.append(JavaMethod.create(runtime, method));
                    }
                }
                this.methods = null;
            }
        }

        void raiseNoMatchingMethodError(IRubyObject proxy, IRubyObject[] args, int start) {
            int len = args.length;
            ArrayList<Object> argTypes = new ArrayList<Object>(len - start);
            for (int i = start; i < len; ++i) {
                argTypes.add(((JavaClass)((JavaObject)args[i]).java_class()).getValue());
            }
            throw proxy.getRuntime().newNameError("no " + this.name + " with arguments matching " + argTypes + " on object " + proxy.callMethod(proxy.getRuntime().getCurrentContext(), "inspect"), null);
        }
    }

    private class InstanceFieldSetter
    extends FieldCallback {
        InstanceFieldSetter() {
        }

        InstanceFieldSetter(String name, Field field) {
            super(name, 3, field);
        }

        @Override
        void install(RubyClass proxy) {
            proxy.defineFastMethod(this.name, this, this.visibility);
        }

        @Override
        public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            this.logMessage(self, args);
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(self, this.javaField.set_value(self.getInstanceVariable("@java_object"), Java.ruby_to_java(self, args[0], Block.NULL_BLOCK)), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    private class InstanceFieldGetter
    extends FieldCallback {
        InstanceFieldGetter() {
        }

        InstanceFieldGetter(String name, Field field) {
            super(name, 3, field);
        }

        @Override
        void install(RubyClass proxy) {
            proxy.defineFastMethod(this.name, this, this.visibility);
        }

        @Override
        public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            this.logMessage(self, args);
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(self, this.javaField.value(self.getInstanceVariable("@java_object")), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    private class StaticFieldSetter
    extends FieldCallback {
        StaticFieldSetter() {
        }

        StaticFieldSetter(String name, Field field) {
            super(name, 1, field);
        }

        @Override
        void install(RubyClass proxy) {
            proxy.getSingletonClass().defineFastMethod(this.name, this, this.visibility);
        }

        @Override
        public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            this.logMessage(self, args);
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(self, this.javaField.set_static_value(Java.ruby_to_java(self, args[0], Block.NULL_BLOCK)), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    private class StaticFieldGetter
    extends FieldCallback {
        StaticFieldGetter() {
        }

        StaticFieldGetter(String name, Field field) {
            super(name, 1, field);
        }

        @Override
        void install(RubyClass proxy) {
            proxy.getSingletonClass().defineFastMethod(this.name, this, this.visibility);
        }

        @Override
        public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
            this.logMessage(self, args);
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(self, this.javaField.static_value(), Block.NULL_BLOCK);
        }

        @Override
        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    private static abstract class FieldCallback
    extends NamedCallback {
        Field field;
        JavaField javaField;

        FieldCallback() {
        }

        FieldCallback(String name, int type, Field field) {
            super(name, type);
            this.field = field;
        }
    }

    private static abstract class NamedCallback
    implements Callback {
        static final int STATIC_FIELD = 1;
        static final int STATIC_METHOD = 2;
        static final int INSTANCE_FIELD = 3;
        static final int INSTANCE_METHOD = 4;
        String name;
        int type;
        Visibility visibility = Visibility.PUBLIC;
        boolean isProtected;

        NamedCallback() {
        }

        NamedCallback(String name, int type) {
            this.name = name;
            this.type = type;
        }

        abstract void install(RubyClass var1);

        boolean hasLocalMethod() {
            return true;
        }

        boolean isPublic() {
            return this.visibility == Visibility.PUBLIC;
        }

        boolean isProtected() {
            return this.visibility == Visibility.PROTECTED;
        }

        void logMessage(IRubyObject self, IRubyObject[] args) {
            String type;
            if (!DEBUG) {
                return;
            }
            switch (this.type) {
                case 1: {
                    type = "static field";
                    break;
                }
                case 2: {
                    type = "static method";
                    break;
                }
                case 3: {
                    type = "instance field";
                    break;
                }
                case 4: {
                    type = "instance method";
                    break;
                }
                default: {
                    type = "?";
                }
            }
            StringBuffer b = new StringBuffer(type).append(" => '").append(this.name).append("'; args.length = ").append(args.length);
            for (int i = 0; i < args.length; ++i) {
                b.append("\n   arg[").append(i).append("] = ").append(args[i]);
            }
            System.out.println(b);
        }
    }

    private static class AssignedName {
        static final int RESERVED = 0;
        static final int METHOD = 1;
        static final int FIELD = 2;
        static final int PROTECTED_METHOD = 3;
        static final int WEAKLY_RESERVED = 4;
        static final int ALIAS = 5;
        static final int PROTECTED_FIELD = 6;
        String name;
        int type;

        AssignedName() {
        }

        AssignedName(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

