/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;

public class FutureThread
implements ThreadLike {
    private Future future;
    private Runnable runnable;
    public RubyThread rubyThread;
    private static ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory());

    public FutureThread(RubyThread rubyThread, RubyRunnable runnable) {
        this.rubyThread = rubyThread;
        this.runnable = runnable;
    }

    @Override
    public void start() {
        this.future = executor.submit(this.runnable);
    }

    @Override
    public void interrupt() {
        this.future.cancel(true);
    }

    @Override
    public boolean isAlive() {
        return this.future != null && !this.future.isDone();
    }

    @Override
    public void join() throws InterruptedException, ExecutionException {
        this.future.get();
    }

    @Override
    public void join(long millis) throws InterruptedException, ExecutionException, TimeoutException {
        this.future.get(millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void setPriority(int priority) {
    }

    @Override
    public boolean isCurrent() {
        return this.rubyThread == this.rubyThread.getRuntime().getCurrentContext().getThread();
    }

    @Override
    public boolean isInterrupted() {
        return this.future.isCancelled();
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

