/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyTCPServer
extends RubyTCPSocket {
    private static ObjectAllocator TCPSERVER_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyTCPServer(runtime, klass);
        }
    };
    private ServerSocketChannel ssc;
    private InetSocketAddress socket_address;

    static void createTCPServer(Ruby runtime) {
        RubyClass rb_cTCPServer = runtime.defineClass("TCPServer", runtime.getClass("TCPSocket"), TCPSERVER_ALLOCATOR);
        CallbackFactory cfact = runtime.callbackFactory(RubyTCPServer.class);
        rb_cTCPServer.defineFastMethod("initialize", cfact.getFastMethod("initialize", IRubyObject.class, IRubyObject.class));
        rb_cTCPServer.defineFastMethod("peeraddr", cfact.getFastOptMethod("peeraddr"));
        rb_cTCPServer.defineFastMethod("getpeername", cfact.getFastOptMethod("getpeername"));
        rb_cTCPServer.defineFastMethod("accept", cfact.getFastMethod("accept"));
        rb_cTCPServer.defineFastMethod("close", cfact.getFastMethod("close"));
        rb_cTCPServer.defineFastMethod("listen", cfact.getFastMethod("listen", IRubyObject.class));
        rb_cTCPServer.getMetaClass().defineFastMethod("open", cfact.getFastOptSingletonMethod("open"));
        runtime.getObject().setConstant("TCPserver", rb_cTCPServer);
    }

    public RubyTCPServer(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @Override
    public IRubyObject initialize(IRubyObject hostname, IRubyObject port) {
        if (hostname.isNil()) {
            hostname = this.getRuntime().newString("0.0.0.0");
        }
        String shost = hostname.convertToString().toString();
        try {
            InetAddress addr = InetAddress.getByName(shost);
            this.ssc = ServerSocketChannel.open();
            this.socket_address = new InetSocketAddress(addr, RubyNumeric.fix2int(port));
            this.ssc.socket().bind(this.socket_address);
            this.setChannel(this.ssc);
        }
        catch (UnknownHostException e) {
            throw RubyTCPServer.sockerr(this, "initialize: name or service not known");
        }
        catch (BindException e) {
            throw this.getRuntime().newErrnoEADDRINUSEError();
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    public IRubyObject accept() {
        RubyTCPSocket socket = new RubyTCPSocket(this.getRuntime(), this.getRuntime().getClass("TCPSocket"));
        try {
            socket.setChannel(this.ssc.accept());
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(this, "problem when accepting");
        }
        return socket;
    }

    @Override
    public IRubyObject close() {
        try {
            this.ssc.close();
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(this, "problem when closing");
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject listen(IRubyObject backlog) {
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject peeraddr(IRubyObject[] args) {
        throw this.getRuntime().newNotImplementedError("not supported");
    }

    public IRubyObject getpeername(IRubyObject[] args) {
        throw this.getRuntime().newNotImplementedError("not supported");
    }

    public static IRubyObject open(IRubyObject recv, IRubyObject[] args) {
        return recv.callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }
}

