/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class Generator {
    public static void createGenerator(Ruby runtime) throws IOException {
        RubyClass cGen = runtime.defineClass("Generator", runtime.getObject(), runtime.getObject().getAllocator());
        cGen.includeModule(runtime.getModule("Enumerable"));
        CallbackFactory callbackFactory = runtime.callbackFactory(Generator.class);
        cGen.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("new_instance"));
        cGen.defineMethod("initialize", callbackFactory.getOptSingletonMethod("initialize"));
        cGen.defineMethod("yield", callbackFactory.getSingletonMethod("yield", IRubyObject.class));
        cGen.defineFastMethod("end?", callbackFactory.getFastSingletonMethod("end_p"));
        cGen.defineFastMethod("next?", callbackFactory.getFastSingletonMethod("next_p"));
        cGen.defineFastMethod("index", callbackFactory.getFastSingletonMethod("index"));
        cGen.defineAlias("pos", "index");
        cGen.defineMethod("next", callbackFactory.getSingletonMethod("next"));
        cGen.defineMethod("current", callbackFactory.getSingletonMethod("current"));
        cGen.defineMethod("rewind", callbackFactory.getSingletonMethod("rewind"));
        cGen.defineMethod("each", callbackFactory.getSingletonMethod("each"));
    }

    public static IRubyObject new_instance(IRubyObject self, IRubyObject[] args, Block block) {
        RubyObject result = new RubyObject(self.getRuntime(), (RubyClass)self);
        result.dataWrapStruct(new GeneratorData(result));
        result.callMethod(self.getRuntime().getCurrentContext(), "initialize", args, block);
        return result;
    }

    public static IRubyObject initialize(IRubyObject self, IRubyObject[] args, Block block) {
        GeneratorData d = (GeneratorData)self.dataGetStruct();
        self.setInstanceVariable("@queue", self.getRuntime().newArray());
        self.setInstanceVariable("@index", self.getRuntime().newFixnum(0L));
        if (Arity.checkArgumentCount(self.getRuntime(), args, 0, 1) == 1) {
            d.setEnum(args[0]);
        } else {
            d.setProc(self.getRuntime().newProc(false, Block.NULL_BLOCK));
        }
        return self;
    }

    public static IRubyObject yield(IRubyObject self, IRubyObject value, Block block) {
        self.getInstanceVariable("@queue").callMethod(self.getRuntime().getCurrentContext(), "<<", value);
        GeneratorData d = (GeneratorData)self.dataGetStruct();
        d.doWait();
        return self;
    }

    public static IRubyObject end_p(IRubyObject self) {
        GeneratorData d = (GeneratorData)self.dataGetStruct();
        return d.isEnd() ? self.getRuntime().getTrue() : self.getRuntime().getFalse();
    }

    public static IRubyObject next_p(IRubyObject self) {
        GeneratorData d = (GeneratorData)self.dataGetStruct();
        return !d.isEnd() ? self.getRuntime().getTrue() : self.getRuntime().getFalse();
    }

    public static IRubyObject index(IRubyObject self) {
        return self.getInstanceVariable("@index");
    }

    public static IRubyObject next(IRubyObject self, Block block) {
        GeneratorData d = (GeneratorData)self.dataGetStruct();
        if (d.isEnd()) {
            throw self.getRuntime().newEOFError();
        }
        d.generate();
        self.setInstanceVariable("@index", self.getInstanceVariable("@index").callMethod(self.getRuntime().getCurrentContext(), 1, "+", self.getRuntime().newFixnum(1L)));
        return self.getInstanceVariable("@queue").callMethod(self.getRuntime().getCurrentContext(), "shift");
    }

    public static IRubyObject current(IRubyObject self, Block block) {
        if (self.getInstanceVariable("@queue").callMethod(self.getRuntime().getCurrentContext(), 13, "empty?").isTrue()) {
            throw self.getRuntime().newEOFError();
        }
        return self.getInstanceVariable("@queue").callMethod(self.getRuntime().getCurrentContext(), "first");
    }

    public static IRubyObject rewind(IRubyObject self, Block block) {
        if (self.getInstanceVariable("@index").callMethod(self.getRuntime().getCurrentContext(), "nonzero?").isTrue()) {
            GeneratorData d = (GeneratorData)self.dataGetStruct();
            self.setInstanceVariable("@queue", self.getRuntime().newArray());
            self.setInstanceVariable("@index", self.getRuntime().newFixnum(0L));
            d.start();
        }
        return self;
    }

    public static IRubyObject each(IRubyObject self, Block block) {
        Generator.rewind(self, Block.NULL_BLOCK);
        ThreadContext ctx = self.getRuntime().getCurrentContext();
        while (Generator.next_p(self).isTrue()) {
            block.yield(ctx, Generator.next(self, Block.NULL_BLOCK));
        }
        return self;
    }

    static class GeneratorData
    implements Runnable {
        private IRubyObject gen;
        private Object mutex = new Object();
        private IRubyObject enm;
        private RubyProc proc;
        private Thread t;
        private boolean end;
        private IterBlockCallback ibc;
        private boolean available = false;

        public GeneratorData(IRubyObject gen) {
            this.gen = gen;
        }

        public void setEnum(IRubyObject enm) {
            this.proc = null;
            this.enm = enm;
            this.start();
        }

        public void setProc(RubyProc proc) {
            this.proc = proc;
            this.enm = null;
            this.start();
        }

        public void start() {
            this.end = false;
            this.ibc = new IterBlockCallback();
            this.t = new Thread(this);
            this.t.setDaemon(true);
            this.t.start();
            this.generate();
        }

        public boolean isEnd() {
            return this.end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doWait() {
            this.available = true;
            if (this.proc != null) {
                boolean inter = true;
                Object object = this.mutex;
                synchronized (object) {
                    this.mutex.notifyAll();
                    while (inter) {
                        try {
                            this.mutex.wait();
                            inter = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generate() {
            if (this.proc == null) {
                boolean inter = true;
                Object object = this.mutex;
                synchronized (object) {
                    while (!this.ibc.haveValue() && !this.end) {
                        this.mutex.notifyAll();
                        inter = true;
                        while (inter) {
                            try {
                                this.mutex.wait();
                                inter = false;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (!this.end && this.proc == null) {
                        this.gen.callMethod(this.gen.getRuntime().getCurrentContext(), "yield", this.ibc.pop());
                    }
                }
            }
            Object object = this.mutex;
            synchronized (object) {
                while (!this.available && !this.end) {
                    boolean inter = true;
                    this.mutex.notifyAll();
                    while (inter) {
                        try {
                            this.mutex.wait(20L);
                            inter = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.available = false;
            }
        }

        @Override
        public void run() {
            if (this.enm != null) {
                ThreadContext context = this.gen.getRuntime().getCurrentContext();
                this.enm.callMethod(context, "each", new CallBlock(this.enm, this.enm.getMetaClass().getRealClass(), Arity.noArguments(), this.ibc, context));
            } else {
                this.proc.call(new IRubyObject[]{this.gen});
            }
            this.end = true;
        }

        private class IterBlockCallback
        implements BlockCallback {
            private IRubyObject obj;

            private IterBlockCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
                boolean inter = true;
                Object object = GeneratorData.this.mutex;
                synchronized (object) {
                    GeneratorData.this.mutex.notifyAll();
                    while (inter) {
                        try {
                            GeneratorData.this.mutex.wait();
                            inter = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.obj = iargs.length > 1 ? GeneratorData.this.gen.getRuntime().newArrayNoCopy(iargs) : iargs[0];
                    GeneratorData.this.mutex.notifyAll();
                    return GeneratorData.this.gen.getRuntime().getNil();
                }
            }

            public boolean haveValue() {
                return this.obj != null;
            }

            public IRubyObject pop() {
                IRubyObject a = this.obj;
                this.obj = null;
                return a;
            }
        }
    }

    public static class Service
    implements Library {
        @Override
        public void load(Ruby runtime) throws IOException {
            Generator.createGenerator(runtime);
        }
    }
}

