/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;

public class ModuleNodeCompiler
implements NodeCompiler {
    @Override
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        final ModuleNode moduleNode = (ModuleNode)node;
        final Colon3Node cpathNode = moduleNode.getCPath();
        ClosureCallback bodyCallback = new ClosureCallback(){

            @Override
            public void compile(Compiler context) {
                if (moduleNode.getBodyNode() != null) {
                    NodeCompilerFactory.getCompiler(moduleNode.getBodyNode()).compile(moduleNode.getBodyNode(), context);
                }
                context.loadNil();
            }
        };
        ClosureCallback pathCallback = new ClosureCallback(){

            @Override
            public void compile(Compiler context) {
                if (cpathNode instanceof Colon2Node) {
                    Node leftNode = ((Colon2Node)cpathNode).getLeftNode();
                    if (leftNode != null) {
                        NodeCompilerFactory.getCompiler(leftNode).compile(leftNode, context);
                    } else {
                        context.loadNil();
                    }
                } else if (cpathNode instanceof Colon3Node) {
                    context.loadObject();
                } else {
                    context.loadNil();
                }
            }
        };
        context.defineModule(moduleNode.getCPath().getName(), moduleNode.getScope(), pathCallback, bodyCallback);
    }
}

