/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.ast.HashNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NodeCompilerFactory;

public class HashNodeCompiler
implements NodeCompiler {
    @Override
    public void compile(Node node, Compiler context) {
        context.lineNumber(node.getPosition());
        HashNode hashNode = (HashNode)node;
        if (hashNode.getListNode() == null || hashNode.getListNode().size() == 0) {
            context.createEmptyHash();
            return;
        }
        ArrayCallback hashCallback = new ArrayCallback(){

            @Override
            public void nextValue(Compiler context, Object sourceArray, int index) {
                ListNode listNode = (ListNode)sourceArray;
                int keyIndex = index * 2;
                NodeCompilerFactory.getCompiler(listNode.get(keyIndex)).compile(listNode.get(keyIndex), context);
                NodeCompilerFactory.getCompiler(listNode.get(keyIndex + 1)).compile(listNode.get(keyIndex + 1), context);
            }
        };
        context.createNewHash(hashNode.getListNode(), hashCallback, hashNode.getListNode().size() / 2);
    }
}

