/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.HashMap;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isExclusive;
    private static ObjectAllocator RANGE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyRange(runtime, klass);
        }
    };
    private static final ObjectMarshal RANGE_MARSHAL = new ObjectMarshal(){

        @Override
        public void marshalTo(Ruby runtime, Object obj, RubyClass type, MarshalStream marshalStream) throws IOException {
            RubyRange range = (RubyRange)obj;
            HashMap<String, IRubyObject> iVars = new HashMap<String, IRubyObject>(range.getInstanceVariables());
            iVars.put("begin", range.begin);
            iVars.put("end", range.end);
            iVars.put("excl", range.isExclusive ? runtime.getTrue() : runtime.getFalse());
            marshalStream.dumpInstanceVars(iVars);
        }

        @Override
        public Object unmarshalFrom(Ruby runtime, RubyClass type, UnmarshalStream unmarshalStream) throws IOException {
            RubyRange range = (RubyRange)type.allocate();
            unmarshalStream.registerLinkTarget(range);
            unmarshalStream.defaultInstanceVarsUnmarshal(range);
            range.begin = range.getInstanceVariable("begin");
            range.end = range.getInstanceVariable("end");
            range.isExclusive = range.getInstanceVariable("excl").isTrue();
            return range;
        }
    };
    private static byte[] DOTDOTDOT = "...".getBytes();
    private static byte[] DOTDOT = "..".getBytes();

    public RubyRange(Ruby runtime, RubyClass impl) {
        super(runtime, impl);
    }

    public void init(IRubyObject aBegin, IRubyObject aEnd, RubyBoolean aIsExclusive) {
        if (!(aBegin instanceof RubyFixnum) || !(aEnd instanceof RubyFixnum)) {
            try {
                aBegin.callMethod(this.getRuntime().getCurrentContext(), 27, "<=>", aEnd);
            }
            catch (RaiseException rExcptn) {
                throw this.getRuntime().newArgumentError("bad value for range");
            }
        }
        this.begin = aBegin;
        this.end = aEnd;
        this.isExclusive = aIsExclusive.isTrue();
    }

    @Override
    public IRubyObject doClone() {
        return RubyRange.newRange(this.getRuntime(), this.begin, this.end, this.isExclusive);
    }

    public static RubyClass createRangeClass(Ruby runtime) {
        RubyClass result = runtime.defineClass("Range", runtime.getObject(), RANGE_ALLOCATOR);
        result.setMarshal(RANGE_MARSHAL);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyRange.class);
        result.includeModule(runtime.getModule("Enumerable"));
        result.defineMethod("==", callbackFactory.getMethod("equal", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("eql?", callbackFactory.getFastMethod("eql_p", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("begin", callbackFactory.getFastMethod("first"));
        result.defineMethod("each", callbackFactory.getMethod("each"));
        result.defineFastMethod("end", callbackFactory.getFastMethod("last"));
        result.defineFastMethod("exclude_end?", callbackFactory.getFastMethod("exclude_end_p"));
        result.defineFastMethod("first", callbackFactory.getFastMethod("first"));
        result.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        result.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        result.defineMethod("inspect", callbackFactory.getMethod("inspect"));
        result.defineFastMethod("last", callbackFactory.getFastMethod("last"));
        result.defineMethod("length", callbackFactory.getMethod("length"));
        result.defineMethod("size", callbackFactory.getMethod("length"));
        result.defineMethod("step", callbackFactory.getOptMethod("step"));
        result.defineMethod("to_s", callbackFactory.getMethod("to_s"));
        result.defineMethod("to_a", callbackFactory.getMethod("to_a"));
        result.defineMethod("include?", callbackFactory.getMethod("include_p", RubyKernel.IRUBY_OBJECT));
        result.defineAlias("member?", "include?");
        result.defineAlias("===", "include?");
        CallbackFactory classCB = runtime.callbackFactory(RubyClass.class);
        result.getMetaClass().defineMethod("new", classCB.getOptMethod("newInstance"));
        return result;
    }

    public long[] getBeginLength(long limit, boolean truncate, boolean isStrict) {
        long beginLong = RubyNumeric.num2long(this.begin);
        long endLong = RubyNumeric.num2long(this.end);
        if (!this.isExclusive) {
            ++endLong;
        }
        if (beginLong < 0L && (beginLong += limit) < 0L) {
            if (isStrict) {
                throw this.getRuntime().newRangeError(this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (truncate && beginLong > limit) {
            if (isStrict) {
                throw this.getRuntime().newRangeError(this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (truncate && endLong > limit) {
            endLong = limit;
        }
        if ((endLong < 0L || !this.isExclusive && endLong == 0L) && (endLong += limit) < 0L) {
            if (isStrict) {
                throw this.getRuntime().newRangeError(this.inspect().toString() + " out of range.");
            }
            return null;
        }
        return new long[]{beginLong, Math.max(endLong - beginLong, 0L)};
    }

    public long[] begLen(long len, int err) {
        long beg = RubyNumeric.num2long(this.begin);
        long end = RubyNumeric.num2long(this.end);
        if (beg < 0L && (beg += len) < 0L) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end + " out of range");
                }
                return null;
            }
            if (end > len) {
                end = len;
            }
        }
        if (end < 0L) {
            end += len;
        }
        if (!this.isExclusive) {
            ++end;
        }
        if ((len = end - beg) < 0L) {
            len = 0L;
        }
        return new long[]{beg, len};
    }

    public static RubyRange newRange(Ruby runtime, IRubyObject begin, IRubyObject end, boolean isExclusive) {
        RubyRange range = new RubyRange(runtime, runtime.getClass("Range"));
        range.init(begin, end, isExclusive ? runtime.getTrue() : runtime.getFalse());
        return range;
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        if (args.length == 3) {
            this.init(args[0], args[1], (RubyBoolean)args[2]);
        } else if (args.length == 2) {
            this.init(args[0], args[1], this.getRuntime().getFalse());
        } else {
            throw this.getRuntime().newArgumentError("Wrong arguments. (anObject, anObject, aBoolean = false) expected");
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject first() {
        return this.begin;
    }

    public IRubyObject last() {
        return this.end;
    }

    @Override
    public RubyFixnum hash() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        long baseHash = this.isExclusive ? 1 : 0;
        long beginHash = ((RubyFixnum)this.begin.callMethod(context, 23, "hash")).getLongValue();
        long endHash = ((RubyFixnum)this.end.callMethod(context, 23, "hash")).getLongValue();
        long hash = baseHash;
        hash ^= beginHash << 1;
        hash ^= endHash << 9;
        return this.getRuntime().newFixnum(hash ^= baseHash << 24);
    }

    private IRubyObject asString(String stringMethod) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        RubyString begStr = (RubyString)this.begin.callMethod(context, stringMethod);
        RubyString endStr = (RubyString)this.end.callMethod(context, stringMethod);
        return begStr.cat(this.isExclusive ? DOTDOTDOT : DOTDOT).concat(endStr);
    }

    public IRubyObject inspect(Block block) {
        return this.asString("inspect");
    }

    public IRubyObject to_s(Block block) {
        return this.asString("to_s");
    }

    public RubyBoolean exclude_end_p() {
        return this.getRuntime().newBoolean(this.isExclusive);
    }

    public RubyFixnum length(Block block) {
        long size = 0L;
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this.begin.callMethod(context, 24, ">", this.end).isTrue()) {
            return this.getRuntime().newFixnum(0L);
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            size = ((RubyNumeric)this.end).getLongValue() - ((RubyNumeric)this.begin).getLongValue();
            if (!this.isExclusive) {
                ++size;
            }
        } else {
            int compareMethod;
            IRubyObject currentObject = this.begin;
            int n = compareMethod = this.isExclusive ? 3 : 26;
            while (currentObject.callMethod(context, compareMethod, MethodIndex.NAMES[compareMethod], this.end).isTrue()) {
                ++size;
                if (currentObject.equals(this.end)) break;
                currentObject = currentObject.callMethod(context, "succ");
            }
        }
        return this.getRuntime().newFixnum(size);
    }

    public IRubyObject equal(IRubyObject obj, Block block) {
        if (!(obj instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)obj;
        boolean result = this.begin.equals(otherRange.begin) && this.end.equals(otherRange.end) && this.isExclusive == otherRange.isExclusive;
        return this.getRuntime().newBoolean(result);
    }

    public IRubyObject eql_p(IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)other;
        if (this.begin != otherRange.begin || this.end != otherRange.end || this.isExclusive != otherRange.isExclusive) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public IRubyObject each(Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long endLong = ((RubyNumeric)this.end).getLongValue();
            long i = ((RubyNumeric)this.begin).getLongValue();
            if (!this.isExclusive) {
                ++endLong;
            }
            while (i < endLong) {
                block.yield(context, this.getRuntime().newFixnum(i));
                ++i;
            }
        } else if (this.begin instanceof RubyString) {
            ((RubyString)this.begin).upto(this.end, this.isExclusive, block);
        } else if (this.begin.isKindOf(this.getRuntime().getClass("Numeric"))) {
            if (!this.isExclusive) {
                this.end = this.end.callMethod(context, 1, "+", RubyFixnum.one(this.getRuntime()));
            }
            while (this.begin.callMethod(context, 3, "<", this.end).isTrue()) {
                block.yield(context, this.begin);
                this.begin = this.begin.callMethod(context, 1, "+", RubyFixnum.one(this.getRuntime()));
            }
        } else {
            IRubyObject v = this.begin;
            if (this.isExclusive) {
                while (v.callMethod(context, 3, "<", this.end).isTrue() && !v.equals(this.end)) {
                    block.yield(context, v);
                    v = v.callMethod(context, "succ");
                }
            } else {
                while (v.callMethod(context, 26, "<=", this.end).isTrue()) {
                    block.yield(context, v);
                    if (!v.equals(this.end)) {
                        v = v.callMethod(context, "succ");
                        continue;
                    }
                    break;
                }
            }
        }
        return this;
    }

    public IRubyObject step(IRubyObject[] args, Block block) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        IRubyObject currentObject = this.begin;
        int compareMethod = this.isExclusive ? 3 : 26;
        int stepSize = (int)(args.length == 0 ? 1L : args[0].convertToInteger().getLongValue());
        if (stepSize <= 0) {
            throw this.getRuntime().newArgumentError("step can't be negative");
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this.begin instanceof RubyNumeric && this.end instanceof RubyNumeric) {
            RubyFixnum stepNum = this.getRuntime().newFixnum(stepSize);
            while (currentObject.callMethod(context, compareMethod, MethodIndex.NAMES[compareMethod], this.end).isTrue()) {
                block.yield(context, currentObject);
                currentObject = currentObject.callMethod(context, 1, "+", stepNum);
            }
        } else {
            while (currentObject.callMethod(context, compareMethod, MethodIndex.NAMES[compareMethod], this.end).isTrue()) {
                block.yield(context, currentObject);
                for (int i = 0; i < stepSize; ++i) {
                    currentObject = currentObject.callMethod(context, "succ");
                }
            }
        }
        return this;
    }

    public RubyArray to_a(Block block) {
        IRubyObject currentObject = this.begin;
        String compareMethod = this.isExclusive ? "<" : "<=";
        RubyArray array = this.getRuntime().newArray();
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (currentObject.callMethod(context, compareMethod, this.end).isTrue()) {
            array.append(currentObject);
            if (currentObject.equals(this.end)) break;
            currentObject = currentObject.callMethod(context, "succ");
        }
        return array;
    }

    private boolean r_lt(IRubyObject a, IRubyObject b) {
        IRubyObject r = a.callMethod(this.getRuntime().getCurrentContext(), 27, "<=>", b);
        if (r.isNil()) {
            return false;
        }
        return RubyComparable.cmpint(r, a, b) < 0;
    }

    private boolean r_le(IRubyObject a, IRubyObject b) {
        IRubyObject r = a.callMethod(this.getRuntime().getCurrentContext(), 27, "<=>", b);
        if (r.isNil()) {
            return false;
        }
        return RubyComparable.cmpint(r, a, b) <= 0;
    }

    public RubyBoolean include_p(IRubyObject obj, Block block) {
        if (this.r_le(this.begin, obj) && (this.isExclusive ? this.r_lt(obj, this.end) : this.r_le(obj, this.end))) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }
}

