/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyHash
extends RubyObject
implements Map {
    private static final ObjectAllocator HASH_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyHash(runtime, klass);
        }
    };
    public static final byte AREF_SWITCHVALUE = 1;
    public static final byte ASET_SWITCHVALUE = 2;
    public static final byte NIL_P_SWITCHVALUE = 3;
    public static final byte EQUALEQUAL_SWITCHVALUE = 4;
    public static final byte EMPTY_P_SWITCHVALUE = 5;
    public static final byte TO_S_SWITCHVALUE = 6;
    public static final byte TO_A_SWITCHVALUE = 7;
    public static final byte HASH_SWITCHVALUE = 8;
    public static final byte LENGTH_SWITCHVALUE = 9;
    public static final byte TO_HASH_SWITCHVALUE = 10;
    public static final byte EQL_P_SWITCHVALUE = 11;
    private RubyHashEntry[] table;
    private int size = 0;
    private int threshold;
    private int iterLevel = 0;
    private boolean deleted = false;
    private boolean procDefault = false;
    private IRubyObject ifNone;
    private static final int[] MRI_PRIMES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055, 0};
    private static final int JAVASOFT_INITIAL_CAPACITY = 8;
    private static final int MRI_INITIAL_CAPACITY = MRI_PRIMES[0];
    private static final int INITIAL_THRESHOLD = 6;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int HASH_SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int MIN_CAPA = 8;
    private static final int ST_DEFAULT_MAX_DENSITY = 5;
    private static boolean MRI_HASH = true;
    private static boolean MRI_HASH_RESIZE = true;
    public static long collisions = 0L;
    public static final int ST_CONTINUE = 0;
    public static final int ST_STOP = 1;
    public static final int ST_DELETE = 2;
    public static final int ST_CHECK = 3;
    private static final boolean EQUAL_CHECK_DEFAULT_VALUE = false;

    public static RubyClass createHashClass(Ruby runtime) {
        RubyClass hashc = runtime.defineClass("Hash", runtime.getObject(), HASH_ALLOCATOR);
        hashc.index = 10;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyHash.class);
        hashc.includeModule(runtime.getModule("Enumerable"));
        hashc.getMetaClass().defineMethod("[]", callbackFactory.getOptSingletonMethod("create"));
        hashc.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        hashc.defineFastMethod("initialize_copy", callbackFactory.getFastMethod("replace", RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("rehash", callbackFactory.getFastMethod("rehash"));
        hashc.defineFastMethod("to_hash", callbackFactory.getFastMethod("to_hash"));
        hashc.defineFastMethod("to_a", callbackFactory.getFastMethod("to_a"));
        hashc.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        hashc.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        hashc.defineFastMethod("==", callbackFactory.getFastMethod("equal", RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("[]", callbackFactory.getFastMethod("aref", RubyKernel.IRUBY_OBJECT));
        hashc.defineMethod("fetch", callbackFactory.getOptMethod("fetch"));
        hashc.defineFastMethod("[]=", callbackFactory.getFastMethod("aset", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("store", callbackFactory.getFastMethod("aset", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        hashc.defineMethod("default", callbackFactory.getOptMethod("default_value_get"));
        hashc.defineFastMethod("default=", callbackFactory.getFastMethod("default_value_set", RubyKernel.IRUBY_OBJECT));
        hashc.defineMethod("default_proc", callbackFactory.getMethod("default_proc"));
        hashc.defineFastMethod("index", callbackFactory.getFastMethod("index", RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("indexes", callbackFactory.getFastOptMethod("indices"));
        hashc.defineFastMethod("indices", callbackFactory.getFastOptMethod("indices"));
        hashc.defineFastMethod("size", callbackFactory.getFastMethod("rb_size"));
        hashc.defineFastMethod("length", callbackFactory.getFastMethod("rb_size"));
        hashc.defineFastMethod("empty?", callbackFactory.getFastMethod("empty_p"));
        hashc.defineMethod("each", callbackFactory.getMethod("each"));
        hashc.defineMethod("each_value", callbackFactory.getMethod("each_value"));
        hashc.defineMethod("each_key", callbackFactory.getMethod("each_key"));
        hashc.defineMethod("each_pair", callbackFactory.getMethod("each_pair"));
        hashc.defineMethod("sort", callbackFactory.getMethod("sort"));
        hashc.defineFastMethod("keys", callbackFactory.getFastMethod("keys"));
        hashc.defineFastMethod("values", callbackFactory.getFastMethod("rb_values"));
        hashc.defineFastMethod("values_at", callbackFactory.getFastOptMethod("values_at"));
        hashc.defineFastMethod("shift", callbackFactory.getFastMethod("shift"));
        hashc.defineMethod("delete", callbackFactory.getMethod("delete", RubyKernel.IRUBY_OBJECT));
        hashc.defineMethod("delete_if", callbackFactory.getMethod("delete_if"));
        hashc.defineMethod("select", callbackFactory.getOptMethod("select"));
        hashc.defineMethod("reject", callbackFactory.getMethod("reject"));
        hashc.defineMethod("reject!", callbackFactory.getMethod("reject_bang"));
        hashc.defineFastMethod("clear", callbackFactory.getFastMethod("rb_clear"));
        hashc.defineFastMethod("invert", callbackFactory.getFastMethod("invert"));
        hashc.defineMethod("update", callbackFactory.getMethod("update", RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("replace", callbackFactory.getFastMethod("replace", RubyKernel.IRUBY_OBJECT));
        hashc.defineMethod("merge!", callbackFactory.getMethod("update", RubyKernel.IRUBY_OBJECT));
        hashc.defineMethod("merge", callbackFactory.getMethod("merge", RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("include?", callbackFactory.getFastMethod("has_key", RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("member?", callbackFactory.getFastMethod("has_key", RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("has_key?", callbackFactory.getFastMethod("has_key", RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("has_value?", callbackFactory.getFastMethod("has_value", RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("key?", callbackFactory.getFastMethod("has_key", RubyKernel.IRUBY_OBJECT));
        hashc.defineFastMethod("value?", callbackFactory.getFastMethod("has_value", RubyKernel.IRUBY_OBJECT));
        return hashc;
    }

    @Override
    public int getNativeTypeIndex() {
        return 10;
    }

    @Override
    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        if (context.getRuntime().getTraceFunction() != null) {
            return super.callMethod(context, rubyclass, name, args, callType, block);
        }
        switch (this.getRuntime().getSelectorTable().table[rubyclass.index][methodIndex]) {
            case 1: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.aref(args[0]);
            }
            case 2: {
                if (args.length != 2) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 2 + ")");
                }
                return this.aset(args[0], args[1]);
            }
            case 3: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.nil_p();
            }
            case 4: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.equal(args[0]);
            }
            case 5: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.empty_p();
            }
            case 6: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_s();
            }
            case 7: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_a();
            }
            case 8: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.hash();
            }
            case 9: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.rb_size();
            }
            case 10: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_hash();
            }
            case 11: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.obj_equal(args[0]);
            }
        }
        return super.callMethod(context, rubyclass, name, args, callType, block);
    }

    public static IRubyObject create(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyClass klass = (RubyClass)recv;
        if (args.length == 1 && args[0] instanceof RubyHash) {
            RubyHash otherHash = (RubyHash)args[0];
            return new RubyHash(recv.getRuntime(), klass, otherHash.internalCopyTable(), otherHash.size);
        }
        if ((args.length & 1) != 0) {
            throw recv.getRuntime().newArgumentError("odd number of args for Hash");
        }
        RubyHash hash = (RubyHash)klass.allocate();
        for (int i = 0; i < args.length; i += 2) {
            hash.aset(args[i], args[i + 1]);
        }
        return hash;
    }

    public static final RubyHash newHash(Ruby runtime) {
        return new RubyHash(runtime);
    }

    public static final RubyHash newHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
        assert (defaultValue != null);
        return new RubyHash(runtime, valueMap, defaultValue);
    }

    private RubyHash(Ruby runtime, RubyClass klass, RubyHashEntry[] newTable, int newSize) {
        super(runtime, klass);
        this.ifNone = runtime.getNil();
        this.threshold = 6;
        this.table = newTable;
        this.size = newSize;
    }

    public RubyHash(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
        this.ifNone = runtime.getNil();
        this.alloc();
    }

    public RubyHash(Ruby runtime) {
        this(runtime, runtime.getNil());
    }

    public RubyHash(Ruby runtime, IRubyObject defaultValue) {
        super(runtime, runtime.getHash());
        this.ifNone = defaultValue;
        this.alloc();
    }

    public RubyHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
        super(runtime, runtime.getHash());
        this.ifNone = runtime.getNil();
        this.alloc();
        for (Map.Entry e : valueMap.entrySet()) {
            this.internalPut((IRubyObject)e.getKey(), (IRubyObject)e.getValue());
        }
    }

    private final void alloc() {
        this.threshold = 6;
        this.table = new RubyHashEntry[MRI_HASH_RESIZE ? MRI_INITIAL_CAPACITY : 8];
    }

    private static int JavaSoftHashValue(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int JavaSoftBucketIndex(int h, int length) {
        return h & length - 1;
    }

    private static int MRIHashValue(int h) {
        return h & Integer.MAX_VALUE;
    }

    private static int MRIBucketIndex(int h, int length) {
        return h % length;
    }

    private final void resize(int newCapacity) {
        RubyHashEntry[] oldTable = this.table;
        RubyHashEntry[] newTable = new RubyHashEntry[newCapacity];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHashEntry next = entry.next;
                int i = RubyHash.bucketIndex(entry.hash, newCapacity);
                entry.next = newTable[i];
                newTable[i] = entry;
                entry = next;
            }
        }
        this.table = newTable;
    }

    private final void JavaSoftCheckResize() {
        if (this.size > this.threshold) {
            int oldCapacity = this.table.length;
            if (oldCapacity == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            int newCapacity = this.table.length << 1;
            this.resize(newCapacity);
            this.threshold = newCapacity - (newCapacity >> 2);
        }
    }

    private final void MRICheckResize() {
        if (this.size / this.table.length > 5) {
            int forSize = this.table.length + 1;
            int i = 0;
            int newCapacity = 8;
            while (i < MRI_PRIMES.length) {
                if (newCapacity > forSize) {
                    this.resize(MRI_PRIMES[i]);
                    return;
                }
                ++i;
                newCapacity <<= 1;
            }
            return;
        }
    }

    private static int hashValue(int h) {
        return MRI_HASH ? RubyHash.MRIHashValue(h) : RubyHash.JavaSoftHashValue(h);
    }

    private static int bucketIndex(int h, int length) {
        return MRI_HASH ? RubyHash.MRIBucketIndex(h, length) : RubyHash.JavaSoftBucketIndex(h, length);
    }

    private void checkResize() {
        if (MRI_HASH_RESIZE) {
            this.MRICheckResize();
        } else {
            this.JavaSoftCheckResize();
        }
    }

    private final void internalPut(IRubyObject key, IRubyObject value) {
        this.checkResize();
        int hash = RubyHash.hashValue(key.hashCode());
        int i = RubyHash.bucketIndex(hash, this.table.length);
        RubyHashEntry entry = this.table[i];
        while (entry != null) {
            IRubyObject k;
            if (entry.hash == hash && ((k = entry.key) == key || key.eql(k))) {
                entry.value = value;
                return;
            }
            entry = entry.next;
        }
        this.table[i] = new RubyHashEntry(hash, key, value, this.table[i]);
        ++this.size;
    }

    private final void internalPutDirect(IRubyObject key, IRubyObject value) {
        this.checkResize();
        int hash = RubyHash.hashValue(key.hashCode());
        int i = RubyHash.bucketIndex(hash, this.table.length);
        this.table[i] = new RubyHashEntry(hash, key, value, this.table[i]);
        ++this.size;
    }

    private final IRubyObject internalGet(IRubyObject key) {
        int hash = RubyHash.hashValue(key.hashCode());
        RubyHashEntry entry = this.table[RubyHash.bucketIndex(hash, this.table.length)];
        while (entry != null) {
            IRubyObject k;
            if (entry.hash == hash && ((k = entry.key) == key || key.eql(k))) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private final RubyHashEntry internalGetEntry(IRubyObject key) {
        int hash = RubyHash.hashValue(key.hashCode());
        RubyHashEntry entry = this.table[RubyHash.bucketIndex(hash, this.table.length)];
        while (entry != null) {
            IRubyObject k;
            if (entry.hash == hash && ((k = entry.key) == key || key.eql(k))) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private final RubyHashEntry internalDelete(IRubyObject key) {
        IRubyObject k;
        int hash = RubyHash.hashValue(key.hashCode());
        int i = RubyHash.bucketIndex(hash, this.table.length);
        RubyHashEntry entry = this.table[i];
        if (entry == null) {
            return null;
        }
        if (entry.hash == hash && ((k = entry.key) == key || key.eql(k))) {
            this.table[i] = entry.next;
            --this.size;
            return entry;
        }
        while (entry.next != null) {
            RubyHashEntry tmp = entry.next;
            if (tmp.hash == hash && ((k = tmp.key) == key || key.eql(k))) {
                entry.next = entry.next.next;
                --this.size;
                return tmp;
            }
            entry = entry.next;
        }
        return null;
    }

    private final RubyHashEntry internalDeleteSafe(IRubyObject key) {
        int hash = RubyHash.hashValue(key.hashCode());
        RubyHashEntry entry = this.table[RubyHash.bucketIndex(hash, this.table.length)];
        if (entry == null) {
            return null;
        }
        while (entry != null) {
            IRubyObject k;
            if (entry.key != NEVER && entry.hash == hash && ((k = entry.key) == key || key.eql(k))) {
                entry.key = RubyHash.NEVER;
                --this.size;
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private final RubyHashEntry internalDeleteEntry(RubyHashEntry entry) {
        RubyHashEntry prev;
        int hash = RubyHash.hashValue(entry.key.hashCode());
        int i = RubyHash.bucketIndex(hash, this.table.length);
        RubyHashEntry e = prev = this.table[i];
        while (e != null) {
            RubyHashEntry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                --this.size;
                if (this.iterLevel > 0) {
                    if (prev == e) {
                        this.table[i] = next;
                    } else {
                        prev.next = next;
                    }
                } else {
                    e.key = RubyHash.NEVER;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    private final void internalCleanupSafe() {
        for (int i = 0; i < this.table.length; ++i) {
            RubyHashEntry entry = this.table[i];
            while (entry != null && entry.key == NEVER) {
                this.table[i] = entry = entry.next;
            }
            if (entry == null) continue;
            RubyHashEntry prev = entry;
            entry = entry.next;
            while (entry != null) {
                if (entry.key == NEVER) {
                    prev.next = entry.next;
                } else {
                    prev = prev.next;
                }
                entry = prev.next;
            }
        }
    }

    private final RubyHashEntry[] internalCopyTable() {
        RubyHashEntry[] newTable = new RubyHashEntry[this.table.length];
        for (int i = 0; i < this.table.length; ++i) {
            RubyHashEntry entry = this.table[i];
            while (entry != null) {
                if (entry.key != NEVER) {
                    newTable[i] = new RubyHashEntry(entry.hash, entry.key, entry.value, newTable[i]);
                }
                entry = entry.next;
            }
        }
        return newTable;
    }

    private void rehashOccured() {
        throw this.getRuntime().newRuntimeError("rehash occurred during iteration");
    }

    private final int hashForEachEntry(RubyHashEntry entry, Callback callback) {
        if (entry.key == NEVER) {
            return 0;
        }
        RubyHashEntry[] ltable = this.table;
        int status = callback.call(this, entry);
        if (ltable != this.table) {
            this.rehashOccured();
        }
        switch (status) {
            case 2: {
                this.internalDeleteSafe(entry.key);
                this.deleted = true;
            }
            case 0: {
                break;
            }
            case 1: {
                return 1;
            }
        }
        return 3;
    }

    private final boolean internalForEach(Callback callback) {
        int length = this.table.length;
        for (int i = 0; i < length; ++i) {
            RubyHashEntry last = null;
            RubyHashEntry entry = this.table[i];
            while (entry != null) {
                switch (this.hashForEachEntry(entry, callback)) {
                    case 3: {
                        RubyHashEntry tmp = null;
                        if (i < length) {
                            tmp = this.table[i];
                            while (tmp != null && tmp != entry) {
                                tmp = tmp.next;
                            }
                        }
                        if (tmp == null) {
                            return true;
                        }
                    }
                    case 0: {
                        last = entry;
                        entry = entry.next;
                        break;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        RubyHashEntry tmp = entry;
                        if (last == null) {
                            this.table[i] = entry.next;
                        } else {
                            last.next = entry.next;
                        }
                        entry = entry.next;
                        --this.size;
                    }
                }
            }
        }
        return false;
    }

    public final void forEach(Callback callback) {
        try {
            this.preIter();
            if (this.internalForEach(callback)) {
                this.rehashOccured();
            }
        }
        finally {
            this.postIter();
        }
    }

    private final void preIter() {
        ++this.iterLevel;
    }

    private final void postIter() {
        --this.iterLevel;
        if (this.deleted) {
            this.internalCleanupSafe();
            this.deleted = false;
        }
    }

    private final RubyHashEntry checkIter(RubyHashEntry[] ltable, RubyHashEntry node) {
        while (node != null && node.key == NEVER) {
            node = node.next;
        }
        if (ltable != this.table) {
            this.rehashOccured();
        }
        return node;
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        this.modify();
        if (block.isGiven()) {
            if (args.length > 0) {
                throw this.getRuntime().newArgumentError("wrong number of arguments");
            }
            this.ifNone = this.getRuntime().newProc(false, block);
            this.procDefault = true;
        } else {
            Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
            if (args.length == 1) {
                this.ifNone = args[0];
            }
        }
        return this;
    }

    public IRubyObject default_value_get(IRubyObject[] args, Block unusedBlock) {
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        if (this.procDefault) {
            if (args.length == 0) {
                return this.getRuntime().getNil();
            }
            return this.ifNone.callMethod(this.getRuntime().getCurrentContext(), "call", new IRubyObject[]{this, args[0]});
        }
        return this.ifNone;
    }

    public IRubyObject default_value_set(IRubyObject defaultValue) {
        this.modify();
        this.ifNone = defaultValue;
        this.procDefault = false;
        return this.ifNone;
    }

    public IRubyObject default_proc(Block unusedBlock) {
        return this.procDefault ? this.ifNone : this.getRuntime().getNil();
    }

    public void modify() {
        this.testFrozen("hash");
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify hash");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject inspect() {
        Ruby runtime = this.getRuntime();
        if (!runtime.registerInspecting(this)) {
            return runtime.newString("{...}");
        }
        try {
            String sep = ", ";
            String arrow = "=>";
            StringBuffer sb = new StringBuffer("{");
            boolean firstEntry = true;
            ThreadContext context = runtime.getCurrentContext();
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    if (!firstEntry) {
                        sb.append(", ");
                    }
                    sb.append(entry.key.callMethod(context, "inspect")).append("=>");
                    sb.append(entry.value.callMethod(context, "inspect"));
                    firstEntry = false;
                    entry = entry.next;
                }
            }
            sb.append("}");
            RubyString rubyString = runtime.newString(sb.toString());
            return rubyString;
        }
        finally {
            this.postIter();
            runtime.unregisterInspecting(this);
        }
    }

    public RubyFixnum rb_size() {
        return this.getRuntime().newFixnum(this.size);
    }

    public RubyBoolean empty_p() {
        return this.size == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyArray to_a() {
        Ruby runtime = this.getRuntime();
        RubyArray result = RubyArray.newArray(runtime, this.size);
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    result.append(RubyArray.newArray(runtime, entry.key, entry.value));
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        result.setTaint(this.isTaint());
        return result;
    }

    @Override
    public IRubyObject to_s() {
        if (!this.getRuntime().registerInspecting(this)) {
            return this.getRuntime().newString("{...}");
        }
        try {
            IRubyObject iRubyObject = this.to_a().to_s();
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    public RubyHash rehash() {
        this.modify();
        RubyHashEntry[] oldTable = this.table;
        RubyHashEntry[] newTable = new RubyHashEntry[oldTable.length];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHashEntry next = entry.next;
                if (entry.key != NEVER) {
                    entry.hash = entry.key.hashCode();
                    int i = RubyHash.bucketIndex(entry.hash, newTable.length);
                    entry.next = newTable[i];
                    newTable[i] = entry;
                }
                entry = next;
            }
        }
        this.table = newTable;
        return this;
    }

    public RubyHash to_hash() {
        return this;
    }

    @Override
    public RubyHash convertToHash() {
        return this;
    }

    public final void fastASet(IRubyObject key, IRubyObject value) {
        this.internalPut(key, value);
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        this.modify();
        if (!(key instanceof RubyString)) {
            this.internalPut(key, value);
            return value;
        }
        RubyHashEntry entry = null;
        entry = this.internalGetEntry(key);
        if (entry != null) {
            entry.value = value;
        } else {
            RubyString realKey = ((RubyString)key).strDup();
            realKey.setFrozen(true);
            this.internalPutDirect(realKey, value);
        }
        return value;
    }

    public final IRubyObject fastARef(IRubyObject key) {
        return this.internalGet(key);
    }

    public IRubyObject aref(IRubyObject key) {
        IRubyObject value = this.internalGet(key);
        return value == null ? this.callMethod(this.getRuntime().getCurrentContext(), "default", key) : value;
    }

    public IRubyObject fetch(IRubyObject[] args, Block block) {
        IRubyObject value;
        if (Arity.checkArgumentCount(this.getRuntime(), args, 1, 2) == 2 && block.isGiven()) {
            this.getRuntime().getWarnings().warn("block supersedes default value argument");
        }
        if ((value = this.internalGet(args[0])) == null) {
            if (block.isGiven()) {
                return block.yield(this.getRuntime().getCurrentContext(), args[0]);
            }
            if (args.length == 1) {
                throw this.getRuntime().newIndexError("key not found");
            }
            return args[1];
        }
        return value;
    }

    public RubyBoolean has_key(IRubyObject key) {
        return this.internalGetEntry(key) == null ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyBoolean has_value(IRubyObject value) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    if (entry.value.equalInternal(context, value).isTrue()) {
                        RubyBoolean rubyBoolean = runtime.getTrue();
                        return rubyBoolean;
                    }
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return runtime.getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyHash each(Block block) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    block.yield(context, RubyArray.newArray(runtime, entry.key, entry.value), null, null, false);
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyHash each_pair(Block block) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    block.yield(context, RubyArray.newArray(runtime, entry.key, entry.value), null, null, true);
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyHash each_value(Block block) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    block.yield(context, entry.value);
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyHash each_key(Block block) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    block.yield(context, entry.key);
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return this;
    }

    public RubyArray sort(Block block) {
        return this.to_a().sort_bang(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject index(IRubyObject value) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    if (entry.value.equalInternal(context, value).isTrue()) {
                        IRubyObject iRubyObject = entry.key;
                        return iRubyObject;
                    }
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return this.getRuntime().getNil();
    }

    public RubyArray indices(IRubyObject[] indices) {
        RubyArray values = RubyArray.newArray(this.getRuntime(), indices.length);
        for (int i = 0; i < indices.length; ++i) {
            values.append(this.aref(indices[i]));
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyArray keys() {
        Ruby runtime = this.getRuntime();
        RubyArray keys = RubyArray.newArray(runtime, this.size);
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    keys.append(entry.key);
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyArray rb_values() {
        RubyArray values = RubyArray.newArray(this.getRuntime(), this.size);
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    values.append(entry.value);
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject equal(IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyHash)) {
            if (!other.respondsTo("to_hash")) {
                return this.getRuntime().getFalse();
            }
            return other.equalInternal(this.getRuntime().getCurrentContext(), this);
        }
        RubyHash otherHash = (RubyHash)other;
        if (this.size != otherHash.size) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    IRubyObject value = otherHash.internalGet(entry.key);
                    if (value == null) {
                        RubyBoolean rubyBoolean = runtime.getFalse();
                        return rubyBoolean;
                    }
                    if (!entry.value.equalInternal(context, value).isTrue()) {
                        RubyBoolean rubyBoolean = runtime.getFalse();
                        return rubyBoolean;
                    }
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return runtime.getTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject shift() {
        this.modify();
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                if (entry == null || (entry = this.checkIter(ltable, entry)) == null) continue;
                RubyArray result = RubyArray.newArray(this.getRuntime(), entry.key, entry.value);
                this.internalDeleteSafe(entry.key);
                this.deleted = true;
                RubyArray rubyArray = result;
                return rubyArray;
            }
        }
        finally {
            this.postIter();
        }
        if (this.procDefault) {
            return this.ifNone.callMethod(this.getRuntime().getCurrentContext(), "call", new IRubyObject[]{this, this.getRuntime().getNil()});
        }
        return this.ifNone;
    }

    public IRubyObject delete(IRubyObject key, Block block) {
        this.modify();
        if (this.iterLevel > 0) {
            RubyHashEntry entry = this.internalDeleteSafe(key);
            if (entry != null) {
                this.deleted = true;
                return entry.value;
            }
        } else {
            RubyHashEntry entry = this.internalDelete(key);
            if (entry != null) {
                return entry.value;
            }
        }
        if (block.isGiven()) {
            return block.yield(this.getRuntime().getCurrentContext(), key);
        }
        return this.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject select(IRubyObject[] args, Block block) {
        if (args.length > 0) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for 0)");
        }
        RubyArray result = this.getRuntime().newArray();
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    if (block.yield(context, runtime.newArray(entry.key, entry.value)).isTrue()) {
                        result.append(runtime.newArray(entry.key, entry.value));
                    }
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyHash delete_if(Block block) {
        this.modify();
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    if (block.yield(context, RubyArray.newArray(runtime, entry.key, entry.value), null, null, true).isTrue()) {
                        this.delete(entry.key, block);
                    }
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return this;
    }

    public RubyHash reject(Block block) {
        return ((RubyHash)this.dup()).delete_if(block);
    }

    public IRubyObject reject_bang(Block block) {
        int n = this.size;
        this.delete_if(block);
        if (n == this.size) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    public RubyHash rb_clear() {
        this.modify();
        if (this.size > 0) {
            this.alloc();
            this.size = 0;
            this.deleted = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyHash invert() {
        RubyHash result = RubyHash.newHash(this.getRuntime());
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    result.aset(entry.value, entry.key);
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyHash update(IRubyObject other, Block block) {
        this.modify();
        RubyHash otherHash = other.convertToHash();
        try {
            otherHash.preIter();
            RubyHashEntry[] ltable = otherHash.table;
            if (block.isGiven()) {
                Ruby runtime = this.getRuntime();
                ThreadContext context = runtime.getCurrentContext();
                for (int i = 0; i < ltable.length; ++i) {
                    RubyHashEntry entry = ltable[i];
                    while (entry != null && (entry = otherHash.checkIter(ltable, entry)) != null) {
                        IRubyObject value = this.internalGet(entry.key) != null ? block.yield(context, RubyArray.newArrayNoCopy(runtime, new IRubyObject[]{entry.key, this.aref(entry.key), entry.value})) : entry.value;
                        this.aset(entry.key, value);
                        entry = entry.next;
                    }
                }
            } else {
                for (int i = 0; i < ltable.length; ++i) {
                    RubyHashEntry entry = ltable[i];
                    while (entry != null && (entry = otherHash.checkIter(ltable, entry)) != null) {
                        this.aset(entry.key, entry.value);
                        entry = entry.next;
                    }
                }
            }
        }
        finally {
            otherHash.postIter();
        }
        return this;
    }

    public RubyHash merge(IRubyObject other, Block block) {
        return ((RubyHash)this.dup()).update(other, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyHash replace(IRubyObject other) {
        RubyHash otherHash = other.convertToHash();
        if (this == otherHash) {
            return this;
        }
        this.rb_clear();
        try {
            otherHash.preIter();
            RubyHashEntry[] ltable = otherHash.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = otherHash.checkIter(ltable, entry)) != null) {
                    this.aset(entry.key, entry.value);
                    entry = entry.next;
                }
            }
        }
        finally {
            otherHash.postIter();
        }
        this.ifNone = otherHash.ifNone;
        this.procDefault = otherHash.procDefault;
        return this;
    }

    public RubyArray values_at(IRubyObject[] args) {
        RubyArray result = RubyArray.newArray(this.getRuntime(), args.length);
        for (int i = 0; i < args.length; ++i) {
            result.append(this.aref(args[i]));
        }
        return result;
    }

    public boolean hasDefaultProc() {
        return this.procDefault;
    }

    public IRubyObject getIfNone() {
        return this.ifNone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void marshalTo(RubyHash hash, MarshalStream output) throws IOException {
        output.writeInt(hash.size);
        try {
            hash.preIter();
            RubyHashEntry[] ltable = hash.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = hash.checkIter(ltable, entry)) != null) {
                    output.dumpObject(entry.key);
                    output.dumpObject(entry.value);
                    entry = entry.next;
                }
            }
        }
        finally {
            hash.postIter();
        }
        if (!hash.ifNone.isNil()) {
            output.dumpObject(hash.ifNone);
        }
    }

    public static RubyHash unmarshalFrom(UnmarshalStream input, boolean defaultValue) throws IOException {
        RubyHash result = RubyHash.newHash(input.getRuntime());
        input.registerLinkTarget(result);
        int size = input.unmarshalInt();
        for (int i = 0; i < size; ++i) {
            result.aset(input.unmarshalObject(), input.unmarshalObject());
        }
        if (defaultValue) {
            result.default_value_set(input.unmarshalObject());
        }
        return result;
    }

    @Override
    public Class getJavaClass() {
        return Map.class;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalGet(JavaUtil.convertJavaToRuby(this.getRuntime(), key)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        IRubyObject element = JavaUtil.convertJavaToRuby(runtime, value);
        try {
            this.preIter();
            RubyHashEntry[] ltable = this.table;
            for (int i = 0; i < ltable.length; ++i) {
                RubyHashEntry entry = ltable[i];
                while (entry != null && (entry = this.checkIter(ltable, entry)) != null) {
                    if (entry.value.equalInternal(context, element).isTrue()) {
                        boolean bl = true;
                        return bl;
                    }
                    entry = entry.next;
                }
            }
        }
        finally {
            this.postIter();
        }
        return false;
    }

    public Object get(Object key) {
        return JavaUtil.convertRubyToJava(this.internalGet(JavaUtil.convertJavaToRuby(this.getRuntime(), key)));
    }

    public Object put(Object key, Object value) {
        this.internalPut(JavaUtil.convertJavaToRuby(this.getRuntime(), key), JavaUtil.convertJavaToRuby(this.getRuntime(), value));
        return value;
    }

    public Object remove(Object key) {
        RubyHashEntry entry;
        IRubyObject rubyKey = JavaUtil.convertJavaToRuby(this.getRuntime(), key);
        if (this.iterLevel > 0) {
            entry = this.internalDeleteSafe(rubyKey);
            this.deleted = true;
        } else {
            entry = this.internalDelete(rubyKey);
        }
        return entry != null ? entry.value : null;
    }

    public void putAll(Map map) {
        Ruby runtime = this.getRuntime();
        for (Object key : map.keySet()) {
            this.internalPut(JavaUtil.convertJavaToRuby(runtime, key), JavaUtil.convertJavaToRuby(runtime, map.get(key)));
        }
    }

    @Override
    public void clear() {
        this.rb_clear();
    }

    public Set keySet() {
        return new KeySet();
    }

    public Set directKeySet() {
        return new DirectKeySet();
    }

    public Collection values() {
        return new Values();
    }

    public Collection directValues() {
        return new DirectValues();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public Set directEntrySet() {
        return new DirectEntrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RubyHash)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.equal((RubyHash)other).isTrue();
    }

    private final class DirectEntrySet
    extends AbstractSet {
        private DirectEntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new DirectEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof RubyHashEntry)) {
                return false;
            }
            RubyHashEntry entry = (RubyHashEntry)o;
            if (entry.key == RubyObject.NEVER) {
                return false;
            }
            RubyHashEntry candidate = RubyHash.this.internalGetEntry(entry.key);
            return candidate != null && candidate.equals(entry);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof RubyHashEntry)) {
                return false;
            }
            return RubyHash.this.internalDeleteEntry((RubyHashEntry)o) != null;
        }

        @Override
        public int size() {
            return RubyHash.this.size;
        }

        @Override
        public void clear() {
            RubyHash.this.clear();
        }
    }

    private final class DirectEntryIterator
    extends RubyHashIterator {
        private DirectEntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private final class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof ConversionMapEntry)) {
                return false;
            }
            ConversionMapEntry entry = (ConversionMapEntry)o;
            if (entry.entry.key == RubyObject.NEVER) {
                return false;
            }
            RubyHashEntry candidate = RubyHash.this.internalGetEntry(entry.entry.key);
            return candidate != null && candidate.equals(entry.entry);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof ConversionMapEntry)) {
                return false;
            }
            return RubyHash.this.internalDeleteEntry(((ConversionMapEntry)o).entry) != null;
        }

        @Override
        public int size() {
            return RubyHash.this.size;
        }

        @Override
        public void clear() {
            RubyHash.this.clear();
        }
    }

    private final class EntryIterator
    extends RubyHashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return new ConversionMapEntry(this.runtime, this.nextEntry());
        }
    }

    static final class ConversionMapEntry
    implements Map.Entry {
        private final RubyHashEntry entry;
        private final Ruby runtime;

        public ConversionMapEntry(Ruby runtime, RubyHashEntry entry) {
            this.entry = entry;
            this.runtime = runtime;
        }

        public Object getKey() {
            return JavaUtil.convertRubyToJava(this.entry.key, Object.class);
        }

        public Object getValue() {
            return JavaUtil.convertRubyToJava(this.entry.value, Object.class);
        }

        public Object setValue(Object value) {
            return this.entry.value = JavaUtil.convertJavaToRuby(this.runtime, value);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof RubyHashEntry)) {
                return false;
            }
            RubyHashEntry otherEntry = (RubyHashEntry)other;
            return this.entry.key != RubyObject.NEVER && this.entry.key == otherEntry.key && this.entry.key.eql(otherEntry.key) && (this.entry.value == otherEntry.value || this.entry.value.equals(otherEntry.value));
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }
    }

    private final class DirectValues
    extends Values {
        private DirectValues() {
        }

        @Override
        public Iterator iterator() {
            return new DirectValueIterator();
        }
    }

    private final class DirectValueIterator
    extends RubyHashIterator {
        private DirectValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return RubyHash.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return RubyHash.this.containsValue(o);
        }

        @Override
        public void clear() {
            RubyHash.this.clear();
        }
    }

    private final class ValueIterator
    extends RubyHashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return JavaUtil.convertRubyToJava(this.nextEntry().value);
        }
    }

    private final class DirectKeySet
    extends KeySet {
        private DirectKeySet() {
        }

        @Override
        public Iterator iterator() {
            return new DirectKeyIterator();
        }
    }

    private final class DirectKeyIterator
    extends RubyHashIterator {
        private DirectKeyIterator() {
        }

        public Object next() {
            return this.nextEntry().key;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return RubyHash.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return RubyHash.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return RubyHash.this.remove(o) != null;
        }

        @Override
        public void clear() {
            RubyHash.this.clear();
        }
    }

    private final class KeyIterator
    extends RubyHashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return JavaUtil.convertRubyToJava(this.nextEntry().key);
        }
    }

    private abstract class RubyHashIterator
    implements Iterator {
        RubyHashEntry entry;
        RubyHashEntry current;
        int index;
        RubyHashEntry[] iterTable;
        Ruby runtime;

        public RubyHashIterator() {
            this.runtime = RubyHash.this.getRuntime();
            this.iterTable = RubyHash.this.table;
            if (RubyHash.this.size > 0) {
                this.seekNextValidEntry();
            }
        }

        private final void seekNextValidEntry() {
            while (true) {
                if (this.index < this.iterTable.length && (this.entry = this.iterTable[this.index++]) == null) {
                    continue;
                }
                while (this.entry != null && this.entry.key == RubyObject.NEVER) {
                    this.entry = this.entry.next;
                }
                if (this.entry != null || this.index >= this.iterTable.length) break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.entry != null;
        }

        public final RubyHashEntry nextEntry() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            RubyHashEntry e = this.current = this.entry;
            this.entry = RubyHash.this.checkIter(this.iterTable, this.entry.next);
            if (this.entry == null) {
                this.seekNextValidEntry();
            }
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            RubyHash.this.internalDeleteSafe(this.current.key);
            RubyHash.this.deleted = true;
        }
    }

    public static abstract class Callback {
        public abstract int call(RubyHash var1, RubyHashEntry var2);
    }

    static final class RubyHashEntry
    implements Map.Entry {
        private IRubyObject key;
        private IRubyObject value;
        private RubyHashEntry next;
        private int hash;

        RubyHashEntry(int h, IRubyObject k, IRubyObject v, RubyHashEntry e) {
            this.key = k;
            this.value = v;
            this.next = e;
            this.hash = h;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getJavaifiedKey() {
            return JavaUtil.convertRubyToJava(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public Object getJavaifiedValue() {
            return JavaUtil.convertRubyToJava(this.value);
        }

        public Object setValue(Object value) {
            IRubyObject oldValue = this.value;
            if (!(value instanceof IRubyObject)) {
                throw new UnsupportedOperationException("directEntrySet() doesn't support setValue for non IRubyObject instance entries, convert them manually or use entrySet() instead");
            }
            this.value = (IRubyObject)value;
            return oldValue;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof RubyHashEntry)) {
                return false;
            }
            RubyHashEntry otherEntry = (RubyHashEntry)other;
            return this.key == otherEntry.key && this.key != RubyObject.NEVER && this.key.eql(otherEntry.key) && (this.value == otherEntry.value || this.value.equals(otherEntry.value));
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

