/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigDecimal;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyBigDecimal
extends RubyNumeric {
    private static final ObjectAllocator BIGDECIMAL_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyBigDecimal(runtime, klass);
        }
    };
    private BigDecimal value;

    public static RubyClass createBigDecimal(Ruby runtime) {
        RubyClass result = runtime.defineClass("BigDecimal", runtime.getClass("Numeric"), BIGDECIMAL_ALLOCATOR);
        result.setConstant("ROUND_DOWN", RubyNumeric.int2fix(runtime, 1L));
        result.setConstant("SIGN_POSITIVE_INFINITE", RubyNumeric.int2fix(runtime, 3L));
        result.setConstant("EXCEPTION_OVERFLOW", RubyNumeric.int2fix(runtime, 1L));
        result.setConstant("SIGN_POSITIVE_ZERO", RubyNumeric.int2fix(runtime, 1L));
        result.setConstant("EXCEPTION_ALL", RubyNumeric.int2fix(runtime, 255L));
        result.setConstant("ROUND_CEILING", RubyNumeric.int2fix(runtime, 2L));
        result.setConstant("ROUND_UP", RubyNumeric.int2fix(runtime, 0L));
        result.setConstant("SIGN_NEGATIVE_FINITE", RubyNumeric.int2fix(runtime, -2L));
        result.setConstant("EXCEPTION_UNDERFLOW", RubyNumeric.int2fix(runtime, 4L));
        result.setConstant("SIGN_NaN", RubyNumeric.int2fix(runtime, 0L));
        result.setConstant("BASE", RubyNumeric.int2fix(runtime, 10000L));
        result.setConstant("ROUND_HALF_DOWN", RubyNumeric.int2fix(runtime, 5L));
        result.setConstant("ROUND_MODE", RubyNumeric.int2fix(runtime, 256L));
        result.setConstant("SIGN_POSITIVE_FINITE", RubyNumeric.int2fix(runtime, 2L));
        result.setConstant("EXCEPTION_INFINITY", RubyNumeric.int2fix(runtime, 1L));
        result.setConstant("ROUND_HALF_EVEN", RubyNumeric.int2fix(runtime, 6L));
        result.setConstant("ROUND_HALF_UP", RubyNumeric.int2fix(runtime, 4L));
        result.setConstant("SIGN_NEGATIVE_INFINITE", RubyNumeric.int2fix(runtime, -3L));
        result.setConstant("EXCEPTION_ZERODIVIDE", RubyNumeric.int2fix(runtime, 1L));
        result.setConstant("SIGN_NEGATIVE_ZERO", RubyNumeric.int2fix(runtime, -1L));
        result.setConstant("EXCEPTION_NaN", RubyNumeric.int2fix(runtime, 2L));
        result.setConstant("ROUND_FLOOR", RubyNumeric.int2fix(runtime, 3L));
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyBigDecimal.class);
        runtime.getModule("Kernel").defineModuleFunction("BigDecimal", callbackFactory.getOptSingletonMethod("newBigDecimal"));
        result.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        result.getMetaClass().defineFastMethod("ver", callbackFactory.getFastSingletonMethod("ver"));
        result.getMetaClass().defineMethod("_load", callbackFactory.getSingletonMethod("_load", RubyKernel.IRUBY_OBJECT));
        result.getMetaClass().defineFastMethod("double_fig", callbackFactory.getFastSingletonMethod("double_fig"));
        result.getMetaClass().defineFastMethod("limit", callbackFactory.getFastSingletonMethod("limit", RubyKernel.IRUBY_OBJECT));
        result.getMetaClass().defineFastMethod("mode", callbackFactory.getFastSingletonMethod("mode", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        result.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        result.defineFastMethod("%", callbackFactory.getFastMethod("mod", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("modulo", callbackFactory.getFastMethod("mod", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("*", callbackFactory.getFastOptMethod("mult"));
        result.defineFastMethod("mult", callbackFactory.getFastOptMethod("mult"));
        result.defineFastMethod("**", callbackFactory.getFastMethod("power", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("power", callbackFactory.getFastMethod("power", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("+", callbackFactory.getFastOptMethod("add"));
        result.defineFastMethod("add", callbackFactory.getFastOptMethod("add"));
        result.defineFastMethod("-", callbackFactory.getFastOptMethod("sub"));
        result.defineFastMethod("sub", callbackFactory.getFastOptMethod("sub"));
        result.defineFastMethod("/", callbackFactory.getFastOptMethod("div"));
        result.defineFastMethod("div", callbackFactory.getFastOptMethod("div"));
        result.defineFastMethod("quo", callbackFactory.getFastOptMethod("div"));
        result.defineFastMethod("<=>", callbackFactory.getFastMethod("spaceship", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("==", callbackFactory.getFastMethod("eql_p", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("===", callbackFactory.getFastMethod("eql_p", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("eql?", callbackFactory.getFastMethod("eql_p", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("!=", callbackFactory.getFastMethod("ne", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("<", callbackFactory.getFastMethod("lt", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("<=", callbackFactory.getFastMethod("le", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod(">", callbackFactory.getFastMethod("gt", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod(">=", callbackFactory.getFastMethod("ge", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("abs", callbackFactory.getFastMethod("abs"));
        result.defineFastMethod("ceil", callbackFactory.getFastMethod("ceil", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("coerce", callbackFactory.getFastMethod("coerce", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("divmod", callbackFactory.getFastMethod("divmod", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("exponent", callbackFactory.getFastMethod("exponent"));
        result.defineFastMethod("finite?", callbackFactory.getFastMethod("finite_p"));
        result.defineFastMethod("fix", callbackFactory.getFastMethod("fix"));
        result.defineFastMethod("floor", callbackFactory.getFastMethod("floor", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("frac", callbackFactory.getFastMethod("frac"));
        result.defineFastMethod("infinite?", callbackFactory.getFastMethod("infinite_p"));
        result.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        result.defineFastMethod("nan?", callbackFactory.getFastMethod("nan_p"));
        result.defineFastMethod("nonzero?", callbackFactory.getFastMethod("nonzero_p"));
        result.defineFastMethod("precs", callbackFactory.getFastMethod("precs"));
        result.defineFastMethod("remainder", callbackFactory.getFastMethod("remainder", RubyKernel.IRUBY_OBJECT));
        result.defineFastMethod("round", callbackFactory.getFastOptMethod("round"));
        result.defineFastMethod("sign", callbackFactory.getFastMethod("sign"));
        result.defineFastMethod("split", callbackFactory.getFastMethod("split"));
        result.defineFastMethod("sqrt", callbackFactory.getFastOptMethod("sqrt"));
        result.defineFastMethod("to_f", callbackFactory.getFastMethod("to_f"));
        result.defineFastMethod("to_i", callbackFactory.getFastMethod("to_i"));
        result.defineFastMethod("to_int", callbackFactory.getFastMethod("to_int"));
        result.defineFastMethod("to_s", callbackFactory.getFastOptMethod("to_s"));
        result.defineFastMethod("truncate", callbackFactory.getFastOptMethod("truncate"));
        result.defineFastMethod("zero?", callbackFactory.getFastMethod("zero_p"));
        result.setClassVar("VpPrecLimit", RubyFixnum.zero(runtime));
        return result;
    }

    public RubyBigDecimal(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value) {
        super(runtime, runtime.getClass("BigDecimal"));
        this.value = value;
    }

    public static RubyBigDecimal newInstance(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        RubyClass klass = (RubyClass)recv;
        RubyBigDecimal result = (RubyBigDecimal)klass.allocate();
        result.callInit(args, Block.NULL_BLOCK);
        return result;
    }

    public static RubyBigDecimal newBigDecimal(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyBigDecimal.newInstance(recv.getRuntime().getClass("BigDecimal"), args, Block.NULL_BLOCK);
    }

    public static IRubyObject ver(IRubyObject recv) {
        return recv.getRuntime().newString("1.0.1");
    }

    public static IRubyObject _load(IRubyObject recv, IRubyObject p1, Block block) {
        return recv.getRuntime().getNil();
    }

    public static IRubyObject double_fig(IRubyObject recv) {
        return recv.getRuntime().newFixnum(20L);
    }

    public static IRubyObject limit(IRubyObject recv, IRubyObject arg1) {
        RubyModule c = (RubyModule)recv;
        IRubyObject nCur = c.getClassVar("VpPrecLimit");
        if (arg1.isNil()) {
            return nCur;
        }
        c.setClassVar("VpPrecLimit", arg1);
        return nCur;
    }

    public static IRubyObject mode(IRubyObject recv, IRubyObject mode, IRubyObject value) {
        System.err.println("unimplemented: mode");
        return recv.getRuntime().getNil();
    }

    private RubyBigDecimal getVpValue(IRubyObject v, boolean must) {
        if (v instanceof RubyBigDecimal) {
            return (RubyBigDecimal)v;
        }
        if (v instanceof RubyFixnum || v instanceof RubyBignum) {
            String s = v.toString();
            return RubyBigDecimal.newInstance(this.getRuntime().getClass("BigDecimal"), new IRubyObject[]{this.getRuntime().newString(s)}, Block.NULL_BLOCK);
        }
        if (must) {
            throw this.getRuntime().newTypeError(RubyBigDecimal.trueFalseNil(v.getMetaClass().getName() + " can't be coerced into BigDecimal"));
        }
        return null;
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        String ss = args[0].convertToString().toString();
        try {
            this.value = new BigDecimal(ss);
        }
        catch (NumberFormatException e) {
            this.value = new BigDecimal("0");
        }
        return this;
    }

    private RubyBigDecimal setResult() {
        return this.setResult(0);
    }

    private RubyBigDecimal setResult(int scale) {
        int prec = RubyFixnum.fix2int(this.getRuntime().getClass("BigDecimal").getClassVar("VpPrecLimit"));
        int prec2 = Math.max(scale, prec);
        if (prec2 > 0 && this.value.scale() > prec2 - this.exp()) {
            this.value = this.value.setScale(prec2 - this.exp(), 4);
        }
        return this;
    }

    public IRubyObject mod(IRubyObject arg) {
        System.err.println("unimplemented: mod");
        return this;
    }

    public IRubyObject mult(IRubyObject[] args) {
        RubyBigDecimal val = this.getVpValue(args[0], false);
        if (val == null) {
            return this.callCoerced("*", args[0]);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.multiply(val.value)).setResult();
    }

    public IRubyObject power(IRubyObject arg) {
        BigDecimal val = this.value;
        int times = RubyNumeric.fix2int(arg.convertToInteger());
        for (int i = 0; i < times; ++i) {
            val = val.multiply(val);
        }
        return new RubyBigDecimal(this.getRuntime(), val).setResult();
    }

    public IRubyObject add(IRubyObject[] args) {
        RubyBigDecimal val = this.getVpValue(args[0], false);
        if (val == null) {
            return this.callCoerced("+", args[0]);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.add(val.value)).setResult();
    }

    public IRubyObject sub(IRubyObject[] args) {
        RubyBigDecimal val = this.getVpValue(args[0], false);
        if (val == null) {
            return this.callCoerced("-", args[0]);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(val.value)).setResult();
    }

    public IRubyObject div(IRubyObject[] args) {
        RubyBigDecimal val;
        int scale = 0;
        if (Arity.checkArgumentCount(this.getRuntime(), args, 1, 2) == 2) {
            scale = RubyNumeric.fix2int(args[1]);
        }
        if ((val = this.getVpValue(args[0], false)) == null) {
            return this.callCoerced("/", args[0]);
        }
        if (scale == 0) {
            return new RubyBigDecimal(this.getRuntime(), this.value.divide(val.value, 200, 4)).setResult();
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.divide(val.value, 200, 4)).setResult(scale);
    }

    private IRubyObject cmp(IRubyObject r, char op) {
        int e = 0;
        RubyBigDecimal rb = this.getVpValue(r, false);
        if (rb == null) {
            IRubyObject ee = this.callCoerced("<=>", r);
            if (ee.isNil()) {
                return this.getRuntime().getNil();
            }
            e = RubyNumeric.fix2int(ee);
        } else {
            e = this.value.compareTo(rb.value);
        }
        switch (op) {
            case '*': {
                return this.getRuntime().newFixnum(e);
            }
            case '=': {
                return e == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '!': {
                return e != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'G': {
                return e >= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '>': {
                return e > 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'L': {
                return e <= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '<': {
                return e < 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject spaceship(IRubyObject arg) {
        return this.cmp(arg, '*');
    }

    @Override
    public IRubyObject eql_p(IRubyObject arg) {
        return this.cmp(arg, '=');
    }

    public IRubyObject ne(IRubyObject arg) {
        return this.cmp(arg, '!');
    }

    public IRubyObject lt(IRubyObject arg) {
        return this.cmp(arg, '<');
    }

    public IRubyObject le(IRubyObject arg) {
        return this.cmp(arg, 'L');
    }

    public IRubyObject gt(IRubyObject arg) {
        return this.cmp(arg, '>');
    }

    public IRubyObject ge(IRubyObject arg) {
        return this.cmp(arg, 'G');
    }

    @Override
    public IRubyObject abs() {
        return new RubyBigDecimal(this.getRuntime(), this.value.abs()).setResult();
    }

    public IRubyObject ceil(IRubyObject arg) {
        System.err.println("unimplemented: ceil");
        return this;
    }

    @Override
    public IRubyObject coerce(IRubyObject other) {
        RubyArray obj = other instanceof RubyFloat ? this.getRuntime().newArray(other, this.to_f()) : this.getRuntime().newArray(this.getVpValue(other, true), this);
        return obj;
    }

    @Override
    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public long getLongValue() {
        return this.value.longValue();
    }

    public RubyNumeric multiplyWith(RubyInteger value) {
        return (RubyNumeric)this.mult(new IRubyObject[]{value});
    }

    public RubyNumeric multiplyWith(RubyFloat value) {
        return (RubyNumeric)this.mult(new IRubyObject[]{value});
    }

    public RubyNumeric multiplyWith(RubyBignum value) {
        return (RubyNumeric)this.mult(new IRubyObject[]{value});
    }

    @Override
    public IRubyObject divmod(IRubyObject arg) {
        System.err.println("unimplemented: divmod");
        return this.getRuntime().getNil();
    }

    public IRubyObject exponent() {
        return this.getRuntime().newFixnum(this.exp());
    }

    private int exp() {
        return this.value.abs().unscaledValue().toString().length() - this.value.abs().scale();
    }

    public IRubyObject finite_p() {
        System.err.println("unimplemented: finite?");
        return this.getRuntime().getTrue();
    }

    public IRubyObject fix() {
        System.err.println("unimplemented: fix");
        return this;
    }

    public IRubyObject floor(IRubyObject arg) {
        System.err.println("unimplemented: floor");
        return this;
    }

    public IRubyObject frac() {
        System.err.println("unimplemented: frac");
        return this;
    }

    public IRubyObject infinite_p() {
        System.err.println("unimplemented: infinite?");
        return this.getRuntime().getFalse();
    }

    @Override
    public IRubyObject inspect() {
        StringBuffer val = new StringBuffer("#<BigDecimal:").append(Integer.toHexString(System.identityHashCode(this))).append(",");
        val.append("'").append(this.callMethod(this.getRuntime().getCurrentContext(), 14, "to_s")).append("'").append(",");
        int len = this.value.abs().unscaledValue().toString().length();
        int pow = len / 4;
        val.append(len).append("(").append((pow + 1) * 4).append(")").append(">");
        return this.getRuntime().newString(val.toString());
    }

    public IRubyObject nan_p() {
        System.err.println("unimplemented: nan?");
        return this.getRuntime().getFalse();
    }

    @Override
    public IRubyObject nonzero_p() {
        return this.value.signum() != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject precs() {
        System.err.println("unimplemented: precs");
        return this.getRuntime().getNil();
    }

    @Override
    public IRubyObject remainder(IRubyObject arg) {
        System.err.println("unimplemented: remainder");
        return this;
    }

    public IRubyObject round(IRubyObject[] args) {
        System.err.println("unimplemented: round");
        return this;
    }

    public IRubyObject sign() {
        System.err.println("unimplemented: sign");
        return this.getRuntime().newFixnum(this.value.signum());
    }

    public IRubyObject split() {
        System.err.println("unimplemented: split");
        return this.getRuntime().getNil();
    }

    public IRubyObject sqrt(IRubyObject[] args) {
        System.err.println("unimplemented: sqrt");
        return new RubyBigDecimal(this.getRuntime(), new BigDecimal(Math.sqrt(this.value.doubleValue()))).setResult();
    }

    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value.doubleValue());
    }

    public IRubyObject to_i() {
        return RubyNumeric.int2fix(this.getRuntime(), this.value.longValue());
    }

    @Override
    public IRubyObject to_int() {
        return RubyNumeric.int2fix(this.getRuntime(), this.value.longValue());
    }

    private String removeTrailingZeroes(String in) {
        while (in.length() > 0 && in.charAt(in.length() - 1) == '0') {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }

    private String toSpecialString(BigDecimal abs) {
        if (abs.compareTo(BigDecimal.valueOf(0L)) == 0) {
            return "0.0";
        }
        return null;
    }

    public IRubyObject to_s(IRubyObject[] args) {
        boolean engineering = true;
        boolean pos_sign = false;
        boolean pos_space = false;
        int groups = 0;
        if (args.length != 0 && !args[0].isNil()) {
            String format = args[0].toString();
            int start = 0;
            int end = format.length();
            if (format.length() > 0 && format.charAt(0) == '+') {
                pos_sign = true;
                ++start;
            } else if (format.length() > 0 && format.charAt(0) == ' ') {
                pos_sign = true;
                pos_space = true;
                ++start;
            }
            if (format.length() > 0 && format.charAt(format.length() - 1) == 'F') {
                engineering = false;
                --end;
            } else if (format.length() > 0 && format.charAt(format.length() - 1) == 'E') {
                engineering = true;
                --end;
            }
            String nums = format.substring(start, end);
            if (nums.length() > 0) {
                groups = Integer.parseInt(nums);
            }
        }
        String out = null;
        BigDecimal abs = this.value.abs();
        String unscaled = abs.unscaledValue().toString();
        out = this.toSpecialString(abs);
        if (null != out) {
            return this.getRuntime().newString(out);
        }
        if (engineering) {
            int exponent = this.exp();
            int signum = this.value.signum();
            StringBuffer build = new StringBuffer();
            build.append(signum == -1 ? "-" : (signum == 1 ? (pos_sign ? (pos_space ? " " : "+") : "") : ""));
            build.append("0.");
            if (0 == groups) {
                String s = this.removeTrailingZeroes(unscaled);
                if ("".equals(s)) {
                    build.append("0");
                } else {
                    build.append(s);
                }
            } else {
                String sep = "";
                for (int index = 0; index < unscaled.length(); index += groups) {
                    int next = index + groups;
                    if (next > unscaled.length()) {
                        next = unscaled.length();
                    }
                    build.append(sep).append(unscaled.substring(index, next));
                    sep = " ";
                }
            }
            build.append("E").append(exponent);
            out = build.toString();
        } else {
            int ix = abs.toString().indexOf(46);
            String whole = unscaled;
            String after = null;
            if (ix != -1) {
                whole = unscaled.substring(0, ix);
                after = unscaled.substring(ix);
            }
            int signum = this.value.signum();
            StringBuffer build = new StringBuffer();
            build.append(signum == -1 ? "-" : (signum == 1 ? (pos_sign ? (pos_space ? " " : "+") : "") : ""));
            if (0 == groups) {
                build.append(whole);
                if (null != after) {
                    build.append(".").append(after);
                }
            } else {
                int next;
                int index;
                String sep = "";
                for (index = 0; index < whole.length(); index += groups) {
                    next = index + groups;
                    if (next > whole.length()) {
                        next = whole.length();
                    }
                    build.append(sep).append(whole.substring(index, next));
                    sep = " ";
                }
                if (null != after) {
                    System.out.println("AFTER: " + after);
                    build.append(".");
                    sep = "";
                    for (index = 0; index < after.length(); index += groups) {
                        next = index + groups;
                        if (next > after.length()) {
                            next = after.length();
                        }
                        build.append(sep).append(after.substring(index, next));
                        sep = " ";
                    }
                }
            }
            out = build.toString();
        }
        return this.getRuntime().newString(out);
    }

    public IRubyObject truncate(IRubyObject[] args) {
        System.err.println("unimplemented: truncate");
        return this;
    }

    @Override
    public IRubyObject zero_p() {
        return this.value.signum() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }
}

