/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyIO;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyArgsFile
extends RubyObject {
    private IRubyObject currentFile = null;
    private int currentLineNumber;

    public RubyArgsFile(Ruby runtime) {
        super(runtime, runtime.getObject());
    }

    public void setCurrentLineNumber(int newLineNumber) {
        this.currentLineNumber = newLineNumber;
    }

    public void initArgsFile() {
        this.getRuntime().getModule("Enumerable").extend_object(this);
        this.getRuntime().defineReadonlyVariable("$<", this);
        this.getRuntime().defineGlobalConstant("ARGF", this);
        CallbackFactory callbackFactory = this.getRuntime().callbackFactory(RubyArgsFile.class);
        this.getMetaClass().defineFastMethod("read", callbackFactory.getFastOptMethod("read"));
        this.getMetaClass().defineFastMethod("getc", callbackFactory.getFastMethod("getc"));
        this.getMetaClass().defineFastMethod("readchar", callbackFactory.getFastMethod("readchar"));
        this.getMetaClass().defineFastMethod("seek", callbackFactory.getFastOptMethod("seek"));
        this.getMetaClass().defineFastMethod("pos=", callbackFactory.getFastMethod("set_pos", IRubyObject.class));
        this.getMetaClass().defineFastMethod("tell", callbackFactory.getFastMethod("tell"));
        this.getMetaClass().defineFastMethod("pos", callbackFactory.getFastMethod("tell"));
        this.getMetaClass().defineFastMethod("rewind", callbackFactory.getFastMethod("rewind"));
        this.getMetaClass().defineFastMethod("eof", callbackFactory.getFastMethod("eof"));
        this.getMetaClass().defineFastMethod("eof?", callbackFactory.getFastMethod("eof"));
        this.getMetaClass().defineFastMethod("binmode", callbackFactory.getFastMethod("binmode"));
        this.getMetaClass().defineFastMethod("fileno", callbackFactory.getFastMethod("fileno"));
        this.getMetaClass().defineFastMethod("to_i", callbackFactory.getFastMethod("fileno"));
        this.getMetaClass().defineFastMethod("to_io", callbackFactory.getFastMethod("to_io"));
        this.getMetaClass().defineMethod("each_byte", callbackFactory.getMethod("each_byte"));
        this.getMetaClass().defineMethod("each", callbackFactory.getOptMethod("each_line"));
        this.getMetaClass().defineMethod("each_line", callbackFactory.getOptMethod("each_line"));
        this.getMetaClass().defineFastMethod("path", callbackFactory.getFastMethod("filename"));
        this.getMetaClass().defineFastMethod("filename", callbackFactory.getFastMethod("filename"));
        this.getMetaClass().defineFastMethod("file", callbackFactory.getFastMethod("file"));
        this.getMetaClass().defineFastMethod("skip", callbackFactory.getFastMethod("skip"));
        this.getMetaClass().defineFastMethod("close", callbackFactory.getFastMethod("close_m"));
        this.getMetaClass().defineFastMethod("closed?", callbackFactory.getFastMethod("closed_p"));
        this.getMetaClass().defineFastMethod("gets", callbackFactory.getFastOptMethod("gets"));
        this.getMetaClass().defineFastMethod("readline", callbackFactory.getFastOptMethod("readline"));
        this.getMetaClass().defineFastMethod("readlines", callbackFactory.getFastOptMethod("readlines"));
        this.getMetaClass().defineFastMethod("lineno", callbackFactory.getFastMethod("lineno"));
        this.getMetaClass().defineFastMethod("lineno=", callbackFactory.getFastMethod("set_lineno", IRubyObject.class));
        this.getMetaClass().defineFastMethod("to_a", callbackFactory.getFastOptMethod("readlines"));
        this.getMetaClass().defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        this.getRuntime().defineReadonlyVariable("$FILENAME", this.getRuntime().newString("-"));
    }

    protected boolean nextArgsFile() {
        RubyArray args = (RubyArray)this.getRuntime().getGlobalVariables().get("$*");
        if (args.getLength() == 0) {
            if (this.currentFile == null) {
                this.currentFile = this.getRuntime().getGlobalVariables().get("$stdin");
                ((RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer("-"));
                this.currentLineNumber = 0;
                return true;
            }
            return false;
        }
        String filename = ((RubyString)args.shift()).toString();
        ((RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer(filename));
        this.currentFile = filename.equals("-") ? this.getRuntime().getGlobalVariables().get("$stdin") : new RubyFile(this.getRuntime(), filename);
        return true;
    }

    public IRubyObject fileno() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)this.currentFile).fileno();
    }

    public IRubyObject to_io() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream");
        }
        return this.currentFile;
    }

    public IRubyObject internalGets(IRubyObject[] args) {
        if (this.currentFile == null && !this.nextArgsFile()) {
            return this.getRuntime().getNil();
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject line = this.currentFile.callMethod(context, "gets", args);
        while (line instanceof RubyNil) {
            this.currentFile.callMethod(context, "close");
            if (!this.nextArgsFile()) {
                this.currentFile = null;
                return line;
            }
            line = this.currentFile.callMethod(context, "gets", args);
        }
        ++this.currentLineNumber;
        this.getRuntime().getGlobalVariables().set("$.", this.getRuntime().newFixnum(this.currentLineNumber));
        return line;
    }

    public IRubyObject gets(IRubyObject[] args) {
        IRubyObject result = this.internalGets(args);
        if (!result.isNil()) {
            this.getRuntime().getCurrentContext().setLastline(result);
        }
        return result;
    }

    public IRubyObject readline(IRubyObject[] args) {
        IRubyObject line = this.gets(args);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    public RubyArray readlines(IRubyObject[] args) {
        IRubyObject line;
        IRubyObject[] separatorArgument;
        if (args.length > 0) {
            if (!args[0].isKindOf(this.getRuntime().getNilClass()) && !args[0].isKindOf(this.getRuntime().getString())) {
                throw this.getRuntime().newTypeError(args[0], this.getRuntime().getString());
            }
            separatorArgument = new IRubyObject[]{args[0]};
        } else {
            separatorArgument = IRubyObject.NULL_ARRAY;
        }
        RubyArray result = this.getRuntime().newArray();
        while (!(line = this.internalGets(separatorArgument)).isNil()) {
            result.append(line);
        }
        return result;
    }

    public IRubyObject each_byte(Block block) {
        IRubyObject bt;
        ThreadContext ctx = this.getRuntime().getCurrentContext();
        while (!(bt = this.getc()).isNil()) {
            block.yield(ctx, bt);
        }
        return this;
    }

    public IRubyObject each_line(IRubyObject[] args, Block block) {
        IRubyObject nextLine = this.internalGets(args);
        while (!nextLine.isNil()) {
            block.yield(this.getRuntime().getCurrentContext(), nextLine);
            nextLine = this.internalGets(args);
        }
        return this;
    }

    public IRubyObject file() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            return this.getRuntime().getNil();
        }
        return this.currentFile;
    }

    public IRubyObject skip() {
        this.currentFile = null;
        return this;
    }

    public IRubyObject close_m() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            return this;
        }
        this.currentFile = null;
        this.currentLineNumber = 0;
        return this;
    }

    public IRubyObject closed_p() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            return this;
        }
        return ((RubyIO)this.currentFile).closed();
    }

    public IRubyObject binmode() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)this.currentFile).binmode();
    }

    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.currentLineNumber);
    }

    public IRubyObject tell() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream to tell");
        }
        return ((RubyIO)this.currentFile).pos();
    }

    public IRubyObject rewind() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream to rewind");
        }
        return ((RubyIO)this.currentFile).rewind();
    }

    public IRubyObject eof() {
        if (this.currentFile != null && !this.nextArgsFile()) {
            return this.getRuntime().getTrue();
        }
        return ((RubyIO)this.currentFile).eof();
    }

    public IRubyObject set_pos(IRubyObject offset) {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream to set position");
        }
        return ((RubyIO)this.currentFile).pos_set(offset);
    }

    public IRubyObject seek(IRubyObject[] args) {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream to seek");
        }
        return ((RubyIO)this.currentFile).seek(args);
    }

    public IRubyObject set_lineno(IRubyObject line) {
        this.currentLineNumber = RubyNumeric.fix2int(line);
        return this.getRuntime().getNil();
    }

    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    public IRubyObject getc() {
        IRubyObject bt;
        while (true) {
            if (this.currentFile == null && !this.nextArgsFile()) {
                return this.getRuntime().getNil();
            }
            bt = !(this.currentFile instanceof RubyFile) ? this.currentFile.callMethod(this.getRuntime().getCurrentContext(), "getc") : ((RubyIO)this.currentFile).getc();
            if (!bt.isNil()) break;
            this.currentFile = null;
        }
        return bt;
    }

    public IRubyObject read(IRubyObject[] args) {
        IRubyObject str;
        IRubyObject length;
        long len = 0L;
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 2);
        if (args.length > 0) {
            length = args[0];
            str = args.length > 1 ? args[1] : this.getRuntime().getNil();
        } else {
            length = this.getRuntime().getNil();
            str = this.getRuntime().getNil();
        }
        if (!length.isNil()) {
            len = RubyNumeric.num2long(length);
        }
        if (!str.isNil()) {
            str = str.convertToString();
            ((RubyString)str).modify();
            ((RubyString)str).getByteList().length(0);
            args[1] = this.getRuntime().getNil();
        }
        while (true) {
            if (this.currentFile == null && !this.nextArgsFile()) {
                return str;
            }
            IRubyObject tmp = !(this.currentFile instanceof RubyIO) ? this.currentFile.callMethod(this.getRuntime().getCurrentContext(), "read", args) : ((RubyIO)this.currentFile).read(args);
            if (str.isNil()) {
                str = tmp;
            } else if (!tmp.isNil()) {
                ((RubyString)str).append(tmp);
            }
            if (tmp.isNil() || length.isNil()) {
                this.currentFile = null;
                continue;
            }
            if (args.length < 1 || (long)((RubyString)str).getByteList().length() >= len) break;
            args[0] = this.getRuntime().newFixnum(len -= (long)((RubyString)str).getByteList().length());
        }
        return str;
    }

    public RubyString filename() {
        return (RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME");
    }

    @Override
    public IRubyObject to_s() {
        return this.getRuntime().newString("ARGF");
    }
}

