/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;

public class NormalizedFile
extends File {
    private static final long serialVersionUID = 7630618150344842227L;

    public NormalizedFile(String pathname) {
        super(pathname);
    }

    public NormalizedFile(URI uri) {
        super(uri);
    }

    public NormalizedFile(File parent, String child) {
        super(parent, child);
    }

    public NormalizedFile(String parent, String child) {
        super(parent, child);
    }

    @Override
    public String getAbsolutePath() {
        return super.getAbsolutePath().replace(File.separatorChar, '/');
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return super.getCanonicalPath().replace(File.separatorChar, '/');
    }

    @Override
    public String getPath() {
        return super.getPath().replace(File.separatorChar, '/');
    }

    @Override
    public String toString() {
        return super.toString().replace(File.separatorChar, '/');
    }

    @Override
    public File getAbsoluteFile() {
        return new NormalizedFile(this.getAbsolutePath());
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return new NormalizedFile(this.getCanonicalPath());
    }

    @Override
    public String getParent() {
        return super.getParent().replace(File.separatorChar, '/');
    }

    @Override
    public File getParentFile() {
        return new NormalizedFile(this.getParent());
    }

    public static File[] listRoots() {
        File[] roots = File.listRoots();
        File[] smartRoots = new NormalizedFile[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            smartRoots[i] = new NormalizedFile(roots[i].getPath());
        }
        return smartRoots;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File file = File.createTempFile(prefix, suffix, directory);
        return new NormalizedFile(file.getPath());
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        return new NormalizedFile(file.getPath());
    }

    @Override
    public String[] list() {
        return super.list();
    }

    @Override
    public String[] list(FilenameFilter filter) {
        String[] files = super.list(filter);
        if (files == null) {
            return null;
        }
        String[] smartFiles = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            smartFiles[i] = files[i].replace(File.separatorChar, '/');
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles() {
        File[] files = super.listFiles();
        if (files == null) {
            return null;
        }
        File[] smartFiles = new NormalizedFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            smartFiles[i] = new NormalizedFile(files[i].getPath());
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        File[] files = super.listFiles(filter);
        if (files == null) {
            return null;
        }
        File[] smartFiles = new NormalizedFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            smartFiles[i] = new NormalizedFile(files[i].getPath());
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        File[] files = super.listFiles(filter);
        if (files == null) {
            return null;
        }
        File[] smartFiles = new NormalizedFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            smartFiles[i] = new NormalizedFile(files[i].getPath());
        }
        return smartFiles;
    }

    public static String getFileProperty(String property) {
        String value = System.getProperty(property);
        return value.replace(File.separatorChar, '/');
    }
}

