/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jruby.util.ByteList;

public class Dir {
    public static final boolean DOSISH;
    public static final boolean CASEFOLD_FILESYSTEM;
    public static final int FNM_NOESCAPE = 1;
    public static final int FNM_PATHNAME = 2;
    public static final int FNM_DOTMATCH = 4;
    public static final int FNM_CASEFOLD = 8;
    public static final int FNM_SYSCASE;
    public static final int FNM_NOMATCH = 1;
    public static final int FNM_ERROR = 2;
    public static final byte[] EMPTY;
    public static final byte[] SLASH;
    public static final byte[] STAR;
    public static final byte[] DOUBLE_STAR;
    public static final GlobFunc push_pattern;
    public static final GlobFunc glob_caller;

    private static boolean isdirsep(byte c) {
        return DOSISH ? c == 92 || c == 47 : c == 47;
    }

    private static int rb_path_next(byte[] _s, int s, int len) {
        while (s < len && !Dir.isdirsep(_s[s])) {
            ++s;
        }
        return s;
    }

    public static int fnmatch(byte[] _pat, int pstart, int plen, byte[] string, int sstart, int slen, int flags) {
        boolean period;
        int s = sstart;
        int pat = pstart;
        int len = plen;
        boolean escape = (flags & 1) == 0;
        boolean pathname = (flags & 2) != 0;
        boolean bl = period = (flags & 4) == 0;
        block6: while (pat < len) {
            byte c = _pat[pat++];
            switch (c) {
                case 63: {
                    if (s >= slen || pathname && Dir.isdirsep(string[s]) || period && string[s] == 46 && (s == 0 || pathname && Dir.isdirsep(string[s - 1]))) {
                        return 1;
                    }
                    ++s;
                    continue block6;
                }
                case 42: {
                    while (pat < len && (c = _pat[pat++]) == 42) {
                    }
                    if (s < slen && period && string[s] == 46 && (s == 0 || pathname && Dir.isdirsep(string[s - 1]))) {
                        return 1;
                    }
                    if (pat > len || pat == len && c == 42) {
                        if (pathname && Dir.rb_path_next(string, s, slen) < slen) {
                            return 1;
                        }
                        return 0;
                    }
                    if (pathname && Dir.isdirsep(c)) {
                        if ((s = Dir.rb_path_next(string, s, slen)) < slen) {
                            ++s;
                            continue block6;
                        }
                        return 1;
                    }
                    char test = (char)((escape && c == 92 && pat < len ? _pat[pat] : c) & 0xFF);
                    test = Character.toLowerCase(test);
                    --pat;
                    while (s < slen) {
                        if ((c == 63 || c == 91 || Character.toLowerCase((char)string[s]) == test) && Dir.fnmatch(_pat, pat, plen, string, s, slen, flags | 4) == 0) {
                            return 0;
                        }
                        if (pathname && Dir.isdirsep(string[s])) break;
                        ++s;
                    }
                    return 1;
                }
                case 91: {
                    if (s >= slen || pathname && Dir.isdirsep(string[s]) || period && string[s] == 46 && (s == 0 || pathname && Dir.isdirsep(string[s - 1]))) {
                        return 1;
                    }
                    if ((pat = Dir.range(_pat, pat, plen, (char)(string[s] & 0xFF), flags)) == -1) {
                        return 1;
                    }
                    ++s;
                    continue block6;
                }
                case 92: {
                    if (!escape || DOSISH && (pat >= len || "*?[]\\".indexOf((char)_pat[pat]) == -1)) break;
                    c = pat >= len ? (byte)92 : _pat[pat++];
                }
            }
            if (s >= slen) {
                return 1;
            }
            if (!(DOSISH && pathname && Dir.isdirsep(c) && Dir.isdirsep(string[s]) || Character.toLowerCase((char)c) == Character.toLowerCase((char)string[s]))) {
                return 1;
            }
            ++s;
        }
        return s >= slen ? 0 : 1;
    }

    public static int range(byte[] _pat, int pat, int len, char test, int flags) {
        boolean not;
        boolean ok = false;
        boolean escape = (flags & 1) == 0;
        boolean bl = not = _pat[pat] == 33 || _pat[pat] == 94;
        if (not) {
            ++pat;
        }
        test = Character.toLowerCase(test);
        while (_pat[pat] != 93) {
            char cend;
            if (escape && _pat[pat] == 92) {
                ++pat;
            }
            if (pat >= len) {
                return -1;
            }
            char cstart = cend = (char)(_pat[pat++] & 0xFF);
            if (_pat[pat] == 45 && _pat[pat + 1] != 93) {
                if (escape && _pat[++pat] == 92) {
                    ++pat;
                }
                if (pat >= len) {
                    return -1;
                }
                cend = (char)(_pat[pat++] & 0xFF);
            }
            if (Character.toLowerCase(cstart) > test || test > Character.toLowerCase(cend)) continue;
            ok = true;
        }
        return ok == not ? -1 : pat + 1;
    }

    public static List push_glob(String cwd, byte[] str, int p, int pend, int flags) {
        int status = 0;
        boolean noescape = (flags & 1) != 0;
        ArrayList ary = new ArrayList();
        while (p < pend) {
            int maxnest = 0;
            int nest = 0;
            while (p < pend && str[p] == 0) {
                ++p;
            }
            int buf = p;
            while (p < pend && str[p] != 0) {
                if (str[p] == 123) {
                    ++nest;
                    ++maxnest;
                } else if (str[p] == 125) {
                    --nest;
                } else if (!noescape && str[p] == 92 && ++p == pend) break;
                ++p;
            }
            if (!(maxnest == 0 ? (status = Dir.push_globs(cwd, ary, str, buf, pend, flags)) != 0 : nest == 0 && (status = Dir.push_braces(cwd, ary, str, buf, pend, flags)) != 0)) continue;
            break;
        }
        return ary;
    }

    private static int push_braces(String cwd, List ary, byte[] str, int _s, int slen, int flags) {
        ByteList buf = new ByteList(20);
        int nest = 0;
        int status = 0;
        int p = 0;
        int s = 0;
        s = p = _s;
        int rbrace = -1;
        int lbrace = -1;
        while (p < slen) {
            if (str[p] == 123) {
                lbrace = p;
                break;
            }
            ++p;
        }
        while (p < slen) {
            if (str[p] == 123) {
                ++nest;
            } else if (str[p] == 125 && --nest == 0) {
                rbrace = p;
                break;
            }
            ++p;
        }
        if (lbrace != -1 && rbrace != -1) {
            p = lbrace;
            while (str[p] != 125) {
                int t;
                for (p = t = p + 1; p < slen && str[p] != 125 && str[p] != 44; ++p) {
                    if (str[p] != 123) continue;
                    nest = 1;
                    while (str[++p] != 125 || --nest != 0) {
                        if (str[p] != 123) continue;
                        ++nest;
                    }
                }
                buf.length(0);
                buf.append(str, s, lbrace - s);
                buf.append(str, t, p - t);
                buf.append(str, rbrace + 1, slen - (rbrace + 1));
                status = Dir.push_braces(cwd, ary, buf.bytes, 0, buf.realSize, flags);
                if (status == 0) continue;
                break;
            }
        } else {
            status = Dir.push_globs(cwd, ary, str, s, slen, flags);
        }
        return status;
    }

    private static int push_globs(String cwd, List ary, byte[] str, int s, int slen, int flags) {
        return Dir.rb_glob2(cwd, str, s, slen, flags, push_pattern, ary);
    }

    private static int rb_glob2(String cwd, byte[] _path, int path, int plen, int flags, GlobFunc func, List arg) {
        GlobArgs args = new GlobArgs();
        args.func = func;
        args.v = arg;
        return Dir.glob_helper(cwd, _path, path, plen, -1, flags |= FNM_SYSCASE, glob_caller, args);
    }

    private static boolean has_magic(byte[] str, int s, int send, int slen, int flags) {
        boolean nocase;
        int p = s;
        int open = 0;
        boolean escape = (flags & 1) == 0;
        boolean bl = nocase = (flags & 8) != 0;
        block6: while (p < slen) {
            byte c = str[p++];
            switch (c) {
                case 42: 
                case 63: {
                    return true;
                }
                case 91: {
                    ++open;
                    continue block6;
                }
                case 93: {
                    if (open <= 0) continue block6;
                    return true;
                }
                case 92: {
                    if (!escape || p != slen) break;
                    return false;
                }
                default: {
                    if (FNM_SYSCASE != 0 || !Character.isLetter((char)(c & 0xFF)) || !nocase) break;
                    return true;
                }
            }
            if (send == -1 || p < send) continue;
            break;
        }
        return false;
    }

    private static int remove_backslashes(byte[] pa, int p, int len) {
        int pend = len;
        int t = p;
        while (p < pend && (pa[p] != 92 || ++p != pend)) {
            pa[t++] = pa[p++];
        }
        return t;
    }

    private static int strchr(byte[] _s, int s, byte ch) {
        int e = _s.length;
        for (int i = s; i < e; ++i) {
            if (_s[i] != ch) continue;
            return i - s;
        }
        return -1;
    }

    private static byte[] extract_path(byte[] _p, int p, int pend) {
        int len = pend - p;
        if (!(len <= 1 || _p[pend - 1] != 47 || DOSISH && len >= 2 && _p[pend - 2] == 58)) {
            --len;
        }
        byte[] alloc = new byte[len];
        System.arraycopy(_p, p, alloc, 0, len);
        return alloc;
    }

    private static byte[] extract_elem(byte[] _p, int p, int pend) {
        int _pend = Dir.strchr(_p, p, (byte)47);
        _pend = _pend == -1 || _pend + p > pend ? pend : (_pend += p);
        return Dir.extract_path(_p, p, _pend);
    }

    private static boolean BASE(byte[] base) {
        return DOSISH ? !(base.length <= 0 || Dir.isdirsep(base[0]) && base.length < 2 || base.length > 2 && base[1] == 58 && Dir.isdirsep(base[2]) && base.length < 4) : base.length > 0 && (!Dir.isdirsep(base[0]) || base.length >= 2);
    }

    private static int glob_helper(String cwd, byte[] _path, int path, int plen, int sub, int flags, GlobFunc func, GlobArgs arg) {
        int p;
        int status = 0;
        ByteList buf = new ByteList(20);
        byte[] newpath = null;
        ArrayList<ByteList> link = new ArrayList<ByteList>();
        int n = p = sub != -1 ? sub : path;
        if (!Dir.has_magic(_path, p, -1, plen, flags)) {
            if (DOSISH || (flags & 1) == 0) {
                newpath = new byte[plen];
                System.arraycopy(_path, 0, newpath, 0, plen);
                if (sub != -1) {
                    p = sub - path;
                    plen = Dir.remove_backslashes(newpath, p, plen);
                    sub = p;
                } else {
                    plen = Dir.remove_backslashes(newpath, 0, plen);
                    _path = newpath;
                }
            }
            if (_path[path] == 47 || DOSISH && path + 2 < plen && _path[path + 1] == 58 && Dir.isdirsep(_path[path + 2])) {
                if (new File(new String(_path, path, plen - path)).exists()) {
                    status = func.call(_path, path, plen, arg);
                }
            } else if (new File(cwd, new String(_path, path, plen - path)).exists()) {
                status = func.call(_path, path, plen, arg);
            }
            return status;
        }
        while (p != -1 && status == 0) {
            int m;
            block20: {
                File st;
                block22: {
                    byte[] magic;
                    boolean recursive;
                    byte[] base;
                    block21: {
                        if (_path[p] == 47) {
                            ++p;
                        }
                        if (!Dir.has_magic(_path, p, (m = Dir.strchr(_path, p, (byte)47)) == -1 ? m : p + m, plen, flags)) break block20;
                        base = Dir.extract_path(_path, path, p);
                        recursive = false;
                        byte[] dir = path == p ? new byte[]{46} : base;
                        magic = Dir.extract_elem(_path, p, plen);
                        st = dir[0] == 47 || DOSISH && 2 < dir.length && dir[1] == 58 && Dir.isdirsep(dir[2]) ? new File(new String(dir)) : new File(cwd, new String(dir));
                        if (!st.isDirectory()) break;
                        if (m == -1 || !Arrays.equals(magic, DOUBLE_STAR)) break block21;
                        int n2 = base.length;
                        recursive = true;
                        buf.length(0);
                        buf.append(base);
                        buf.append(_path, p + (base.length > 0 ? m : m + 1), plen - (p + (base.length > 0 ? m : m + 1)));
                        status = Dir.glob_helper(cwd, buf.bytes, 0, buf.realSize, n2, flags, func, arg);
                        if (status != 0) break block22;
                    }
                    String[] dirp = st.list();
                    for (int i = 0; i < dirp.length; ++i) {
                        byte[] bs;
                        if (recursive) {
                            bs = dirp[i].getBytes();
                            if (Dir.fnmatch(STAR, 0, 1, bs, 0, bs.length, flags) != 0) continue;
                            buf.length(0);
                            buf.append(base);
                            buf.append(Dir.BASE(base) ? SLASH : EMPTY);
                            buf.append(dirp[i].getBytes());
                            st = buf.bytes[0] == 47 || DOSISH && 2 < buf.realSize && buf.bytes[1] == 58 && Dir.isdirsep(buf.bytes[2]) ? new File(new String(buf.bytes, 0, buf.realSize)) : new File(cwd, new String(buf.bytes, 0, buf.realSize));
                            if (!st.isDirectory()) continue;
                            int t = buf.realSize;
                            buf.append(SLASH);
                            buf.append(DOUBLE_STAR);
                            buf.append(_path, p + m, plen - (p + m));
                            status = Dir.glob_helper(cwd, buf.bytes, 0, buf.realSize, t, flags, func, arg);
                            if (status == 0) continue;
                            break;
                        }
                        bs = dirp[i].getBytes();
                        if (Dir.fnmatch(magic, 0, magic.length, bs, 0, bs.length, flags) != 0) continue;
                        buf.length(0);
                        buf.append(base);
                        buf.append(Dir.BASE(base) ? SLASH : EMPTY);
                        buf.append(dirp[i].getBytes());
                        if (m == -1) {
                            status = func.call(buf.bytes, 0, buf.realSize, arg);
                            if (status == 0) continue;
                            break;
                        }
                        link.add(buf);
                        buf = new ByteList(20);
                    }
                }
                if (link.size() > 0) {
                    Iterator iter = link.iterator();
                    while (iter.hasNext()) {
                        if (status != 0) continue;
                        ByteList b = (ByteList)iter.next();
                        st = b.bytes[0] == 47 || DOSISH && 2 < b.realSize && b.bytes[1] == 58 && Dir.isdirsep(b.bytes[2]) ? new File(new String(b.bytes, 0, b.realSize)) : new File(cwd, new String(b.bytes, 0, b.realSize));
                        if (!st.isDirectory()) continue;
                        int len = b.realSize;
                        buf.length(0);
                        buf.append(b);
                        buf.append(_path, p + m, plen - (p + m));
                        status = Dir.glob_helper(cwd, buf.bytes, 0, buf.realSize, len, flags, func, arg);
                    }
                    break;
                }
            }
            p = m == -1 ? m : p + m;
        }
        return status;
    }

    static {
        CASEFOLD_FILESYSTEM = DOSISH = System.getProperty("os.name").indexOf("Windows") != -1;
        FNM_SYSCASE = CASEFOLD_FILESYSTEM ? 8 : 0;
        EMPTY = new byte[0];
        SLASH = new byte[]{47};
        STAR = new byte[]{42};
        DOUBLE_STAR = new byte[]{42, 42};
        push_pattern = new GlobFunc(){

            @Override
            public int call(byte[] ptr, int p, int len, Object ary) {
                ((List)ary).add(new ByteList(ptr, p, len));
                return 0;
            }
        };
        glob_caller = new GlobFunc(){

            @Override
            public int call(byte[] ptr, int p, int len, Object ary) {
                GlobArgs args = (GlobArgs)ary;
                args.c = p;
                return args.func.call(ptr, args.c, len, args.v);
            }
        };
    }

    private static class GlobArgs {
        GlobFunc func;
        int c = -1;
        List v;

        private GlobArgs() {
        }
    }

    private static interface GlobFunc {
        public int call(byte[] var1, int var2, int var3, Object var4);
    }
}

