/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import java.io.File;
import java.io.FileOutputStream;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Opcodes;
import org.jruby.Ruby;
import org.jruby.RubyKernel;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.callback.FastInvocationCallback;
import org.jruby.runtime.callback.InvocationCallback;
import org.jruby.runtime.callback.ReflectionCallback;
import org.jruby.util.CodegenUtils;

public class DumpingInvocationCallbackFactory
extends CallbackFactory
implements Opcodes {
    private static final CodegenUtils cg = CodegenUtils.instance;
    private final Class type;
    private final String typePath;
    private final Ruby runtime;
    private static final String SUPER_CLASS = CodegenUtils.p(InvocationCallback.class);
    private static final String FAST_SUPER_CLASS = CodegenUtils.p(FastInvocationCallback.class);
    private static final String BLOCK_ID = CodegenUtils.ci(Block.class);
    private static final String CALL_SIG = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(Object.class, Object[].class, Block.class));
    private static final String FAST_CALL_SIG = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(Object.class, Object[].class));
    private static final String BLOCK_CALL_SIG = CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(ThreadContext.class, RubyKernel.IRUBY_OBJECT, IRubyObject[].class, Block.class, IRubyObject[][].class));
    private static final String IRUB = CodegenUtils.p(RubyKernel.IRUBY_OBJECT);
    private static final String IRUB_ID = CodegenUtils.ci(RubyKernel.IRUBY_OBJECT);
    private String dumpPath;

    public DumpingInvocationCallbackFactory(Ruby runtime, Class type, String path) {
        this.type = type;
        this.typePath = CodegenUtils.p(type);
        this.runtime = runtime;
        this.dumpPath = path;
    }

    private String getReturnName(String method, Class[] args) throws Exception {
        String t = this.type.getMethod(method, args).getReturnType().getName().replace('.', '/');
        if ("void".equalsIgnoreCase(t)) {
            throw new IllegalArgumentException("Method " + method + " has a void return type. This is not allowed in JRuby.");
        }
        return t;
    }

    private ClassWriter createCtor(String namePath) throws Exception {
        ClassWriter cw = new ClassWriter(true);
        cw.visit(48, 33, namePath, null, SUPER_CLASS, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, SUPER_CLASS, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createCtorFast(String namePath) throws Exception {
        ClassWriter cw = new ClassWriter(true);
        cw.visit(48, 33, namePath, null, FAST_SUPER_CLASS, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, FAST_SUPER_CLASS, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createBlockCtor(String namePath) throws Exception {
        ClassWriter cw = new ClassWriter(true);
        String[] stringArray = new String[1];
        stringArray[0] = CodegenUtils.p(CompiledBlockCallback.class);
        cw.visit(48, 33, namePath, null, CodegenUtils.p(Object.class), stringArray);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, CodegenUtils.p(Object.class), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return cw;
    }

    private Class tryClass(String name) {
        try {
            return Class.forName(name, true, this.runtime.getJRubyClassLoader());
        }
        catch (Exception e) {
            return null;
        }
    }

    private MethodVisitor startCall(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", CALL_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.typePath);
        return mv;
    }

    private MethodVisitor startCallS(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", CALL_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, IRUB);
        return mv;
    }

    private MethodVisitor startCallFast(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", FAST_CALL_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.typePath);
        return mv;
    }

    private MethodVisitor startCallSFast(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", FAST_CALL_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, IRUB);
        return mv;
    }

    private MethodVisitor startBlockCall(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "call", BLOCK_CALL_SIG, null, null);
        mv.visitCode();
        return mv;
    }

    private Class endCall(ClassWriter cw, MethodVisitor mv, String name) {
        mv.visitEnd();
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        String cname = name.replace('.', '/');
        File f = new File(this.dumpPath, cname + ".class");
        f.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(code);
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.runtime.getJRubyClassLoader().defineClass(name, code);
    }

    @Override
    public Callback getMethod(String method) {
        String mname = this.type.getName() + "Invoker" + method + "0";
        String mnamePath = this.typePath + "Invoker" + method + "0";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{Block.class});
                ClassWriter cw = this.createCtor(mnamePath);
                MethodVisitor mv = this.startCall(cw);
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(182, this.typePath, method, "(" + BLOCK_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(1, 3);
                c = this.endCall(cw, mv, mname);
            }
            InvocationCallback ic = (InvocationCallback)c.newInstance();
            ic.setArity(Arity.noArguments());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getMethod(String method, Class arg1) {
        String mname = this.type.getName() + "Invoker" + method + "1";
        String mnamePath = this.typePath + "Invoker" + method + "1";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{arg1, Block.class});
                ClassWriter cw = this.createCtor(mnamePath);
                MethodVisitor mv = this.startCall(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(182, this.typePath, method, "(" + CodegenUtils.ci(arg1) + BLOCK_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(3, 3);
                c = this.endCall(cw, mv, mname);
            }
            InvocationCallback ic = (InvocationCallback)c.newInstance();
            ic.setArity(Arity.singleArgument());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getMethod(String method, Class arg1, Class arg2) {
        String mname = this.type.getName() + "Invoker" + method + "2";
        String mnamePath = this.typePath + "Invoker" + method + "2";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{arg1, arg2, Block.class});
                ClassWriter cw = this.createCtor(mnamePath);
                MethodVisitor mv = this.startCall(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(4);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg2));
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(182, this.typePath, method, "(" + CodegenUtils.ci(arg1) + CodegenUtils.ci(arg2) + BLOCK_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(4, 3);
                c = this.endCall(cw, mv, mname);
            }
            InvocationCallback ic = (InvocationCallback)c.newInstance();
            ic.setArity(Arity.twoArguments());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getMethod(String method, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "Invoker" + method + "3";
        String mnamePath = this.typePath + "Invoker" + method + "3";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{arg1, arg2, arg3, Block.class});
                ClassWriter cw = this.createCtor(mnamePath);
                MethodVisitor mv = this.startCall(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(4);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg2));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(5);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg3));
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(182, this.typePath, method, "(" + CodegenUtils.ci(arg1) + CodegenUtils.ci(arg2) + CodegenUtils.ci(arg3) + BLOCK_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(5, 3);
                c = this.endCall(cw, mv, mname);
            }
            InvocationCallback ic = (InvocationCallback)c.newInstance();
            ic.setArity(Arity.fixed(3));
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getSingletonMethod(String method) {
        String mname = this.type.getName() + "InvokerS" + method + "0";
        String mnamePath = this.typePath + "InvokerS" + method + "0";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{RubyKernel.IRUBY_OBJECT, Block.class});
                ClassWriter cw = this.createCtor(mnamePath);
                MethodVisitor mv = this.startCallS(cw);
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(184, this.typePath, method, "(" + IRUB_ID + BLOCK_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(1, 3);
                c = this.endCall(cw, mv, mname);
            }
            InvocationCallback ic = (InvocationCallback)c.newInstance();
            ic.setArity(Arity.noArguments());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getSingletonMethod(String method, Class arg1) {
        String mname = this.type.getName() + "InvokerS" + method + "1";
        String mnamePath = this.typePath + "InvokerS" + method + "1";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{RubyKernel.IRUBY_OBJECT, arg1, Block.class});
                ClassWriter cw = this.createCtor(mnamePath);
                MethodVisitor mv = this.startCallS(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(184, this.typePath, method, "(" + IRUB_ID + CodegenUtils.ci(arg1) + BLOCK_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(3, 3);
                c = this.endCall(cw, mv, mname);
            }
            InvocationCallback ic = (InvocationCallback)c.newInstance();
            ic.setArity(Arity.singleArgument());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getSingletonMethod(String method, Class arg1, Class arg2) {
        String mname = this.type.getName() + "InvokerS" + method + "2";
        String mnamePath = this.typePath + "InvokerS" + method + "2";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2, Block.class});
                ClassWriter cw = this.createCtor(mnamePath);
                MethodVisitor mv = this.startCallS(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(4);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg2));
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(184, this.typePath, method, "(" + IRUB_ID + CodegenUtils.ci(arg1) + CodegenUtils.ci(arg2) + BLOCK_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(4, 4);
                c = this.endCall(cw, mv, mname);
            }
            InvocationCallback ic = (InvocationCallback)c.newInstance();
            ic.setArity(Arity.twoArguments());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getSingletonMethod(String method, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "InvokerS" + method + "3";
        String mnamePath = this.typePath + "InvokerS" + method + "3";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2, arg3, Block.class});
                ClassWriter cw = this.createCtor(mnamePath);
                MethodVisitor mv = this.startCallS(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(4);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg2));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(5);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg3));
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(184, this.typePath, method, "(" + IRUB_ID + CodegenUtils.ci(arg1) + CodegenUtils.ci(arg2) + CodegenUtils.ci(arg3) + BLOCK_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(5, 3);
                c = this.endCall(cw, mv, mname);
            }
            InvocationCallback ic = (InvocationCallback)c.newInstance();
            ic.setArity(Arity.fixed(3));
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getBlockMethod(String method) {
        return new ReflectionCallback(this.type, method, new Class[]{RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT}, false, true, Arity.fixed(2), false);
    }

    @Override
    public CompiledBlockCallback getBlockCallback(String method) {
        String mname = this.type.getName() + "Block" + method + "xx1";
        String mnamePath = this.typePath + "Block" + method + "xx1";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                ClassWriter cw = this.createBlockCtor(mnamePath);
                MethodVisitor mv = this.startBlockCall(cw);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(25, 3);
                mv.visitVarInsn(25, 4);
                mv.visitVarInsn(25, 5);
                mv.visitMethodInsn(184, this.typePath, method, CodegenUtils.sig(RubyKernel.IRUBY_OBJECT, CodegenUtils.params(ThreadContext.class, RubyKernel.IRUBY_OBJECT, IRubyObject[].class, Block.class, IRubyObject[][].class)));
                mv.visitInsn(176);
                mv.visitMaxs(2, 3);
                c = this.endCall(cw, mv, mname);
            }
            CompiledBlockCallback ic = (CompiledBlockCallback)c.newInstance();
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getOptSingletonMethod(String method) {
        String mname = this.type.getName() + "InvokerS" + method + "xx1";
        String mnamePath = this.typePath + "InvokerS" + method + "xx1";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{RubyKernel.IRUBY_OBJECT, IRubyObject[].class, Block.class});
                ClassWriter cw = this.createCtor(mnamePath);
                MethodVisitor mv = this.startCallS(cw);
                mv.visitVarInsn(25, 2);
                mv.visitTypeInsn(192, "[" + IRUB_ID);
                mv.visitTypeInsn(192, "[" + IRUB_ID);
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(184, this.typePath, method, "(" + IRUB_ID + "[" + IRUB_ID + BLOCK_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(2, 3);
                c = this.endCall(cw, mv, mname);
            }
            InvocationCallback ic = (InvocationCallback)c.newInstance();
            ic.setArity(Arity.optional());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getOptMethod(String method) {
        String mname = this.type.getName() + "Invoker" + method + "xx1";
        String mnamePath = this.typePath + "Invoker" + method + "xx1";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{IRubyObject[].class, Block.class});
                ClassWriter cw = this.createCtor(mnamePath);
                MethodVisitor mv = this.startCall(cw);
                mv.visitVarInsn(25, 2);
                mv.visitTypeInsn(192, "[" + IRUB_ID);
                mv.visitTypeInsn(192, "[" + IRUB_ID);
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(182, this.typePath, method, "([" + IRUB_ID + BLOCK_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(2, 3);
                c = this.endCall(cw, mv, mname);
            }
            InvocationCallback ic = (InvocationCallback)c.newInstance();
            ic.setArity(Arity.optional());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getFastMethod(String method) {
        String mname = this.type.getName() + "Invoker" + method + "0";
        String mnamePath = this.typePath + "Invoker" + method + "0";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, null);
                ClassWriter cw = this.createCtorFast(mnamePath);
                MethodVisitor mv = this.startCallFast(cw);
                mv.visitMethodInsn(182, this.typePath, method, "()L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(1, 3);
                c = this.endCall(cw, mv, mname);
            }
            FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
            ic.setArity(Arity.noArguments());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getFastMethod(String method, Class arg1) {
        String mname = this.type.getName() + "Invoker" + method + "1";
        String mnamePath = this.typePath + "Invoker" + method + "1";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{arg1});
                ClassWriter cw = this.createCtorFast(mnamePath);
                MethodVisitor mv = this.startCallFast(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitMethodInsn(182, this.typePath, method, "(" + CodegenUtils.ci(arg1) + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(3, 3);
                c = this.endCall(cw, mv, mname);
            }
            FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
            ic.setArity(Arity.singleArgument());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getFastMethod(String method, Class arg1, Class arg2) {
        String mname = this.type.getName() + "Invoker" + method + "2";
        String mnamePath = this.typePath + "Invoker" + method + "2";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{arg1, arg2});
                ClassWriter cw = this.createCtorFast(mnamePath);
                MethodVisitor mv = this.startCallFast(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(4);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg2));
                mv.visitMethodInsn(182, this.typePath, method, "(" + CodegenUtils.ci(arg1) + CodegenUtils.ci(arg2) + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(4, 3);
                c = this.endCall(cw, mv, mname);
            }
            FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
            ic.setArity(Arity.twoArguments());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getFastMethod(String method, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "Invoker" + method + "3";
        String mnamePath = this.typePath + "Invoker" + method + "3";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{arg1, arg2, arg3});
                ClassWriter cw = this.createCtorFast(mnamePath);
                MethodVisitor mv = this.startCallFast(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(4);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg2));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(5);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg3));
                mv.visitMethodInsn(182, this.typePath, method, "(" + CodegenUtils.ci(arg1) + CodegenUtils.ci(arg2) + CodegenUtils.ci(arg3) + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(5, 3);
                c = this.endCall(cw, mv, mname);
            }
            FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
            ic.setArity(Arity.fixed(3));
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getFastSingletonMethod(String method) {
        String mname = this.type.getName() + "InvokerS" + method + "0";
        String mnamePath = this.typePath + "InvokerS" + method + "0";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{RubyKernel.IRUBY_OBJECT});
                ClassWriter cw = this.createCtorFast(mnamePath);
                MethodVisitor mv = this.startCallSFast(cw);
                mv.visitMethodInsn(184, this.typePath, method, "(" + IRUB_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(1, 3);
                c = this.endCall(cw, mv, mname);
            }
            FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
            ic.setArity(Arity.noArguments());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getFastSingletonMethod(String method, Class arg1) {
        String mname = this.type.getName() + "InvokerS" + method + "1";
        String mnamePath = this.typePath + "InvokerS" + method + "1";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{RubyKernel.IRUBY_OBJECT, arg1});
                ClassWriter cw = this.createCtorFast(mnamePath);
                MethodVisitor mv = this.startCallSFast(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitMethodInsn(184, this.typePath, method, "(" + IRUB_ID + CodegenUtils.ci(arg1) + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(3, 3);
                c = this.endCall(cw, mv, mname);
            }
            FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
            ic.setArity(Arity.singleArgument());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getFastSingletonMethod(String method, Class arg1, Class arg2) {
        String mname = this.type.getName() + "InvokerS" + method + "2";
        String mnamePath = this.typePath + "InvokerS" + method + "2";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2});
                ClassWriter cw = this.createCtorFast(mnamePath);
                MethodVisitor mv = this.startCallSFast(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(4);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg2));
                mv.visitMethodInsn(184, this.typePath, method, "(" + IRUB_ID + CodegenUtils.ci(arg1) + CodegenUtils.ci(arg2) + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(4, 4);
                c = this.endCall(cw, mv, mname);
            }
            FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
            ic.setArity(Arity.twoArguments());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getFastSingletonMethod(String method, Class arg1, Class arg2, Class arg3) {
        String mname = this.type.getName() + "InvokerS" + method + "3";
        String mnamePath = this.typePath + "InvokerS" + method + "3";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{RubyKernel.IRUBY_OBJECT, arg1, arg2, arg3});
                ClassWriter cw = this.createCtorFast(mnamePath);
                MethodVisitor mv = this.startCallSFast(cw);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(3);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg1));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(4);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg2));
                mv.visitVarInsn(25, 2);
                mv.visitInsn(5);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, CodegenUtils.p(arg3));
                mv.visitMethodInsn(184, this.typePath, method, "(" + IRUB_ID + CodegenUtils.ci(arg1) + CodegenUtils.ci(arg2) + CodegenUtils.ci(arg3) + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(5, 3);
                c = this.endCall(cw, mv, mname);
            }
            FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
            ic.setArity(Arity.fixed(3));
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getFastOptMethod(String method) {
        String mname = this.type.getName() + "Invoker" + method + "xx1";
        String mnamePath = this.typePath + "Invoker" + method + "xx1";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{IRubyObject[].class});
                ClassWriter cw = this.createCtorFast(mnamePath);
                MethodVisitor mv = this.startCallFast(cw);
                mv.visitVarInsn(25, 2);
                mv.visitTypeInsn(192, "[" + IRUB_ID);
                mv.visitTypeInsn(192, "[" + IRUB_ID);
                mv.visitMethodInsn(182, this.typePath, method, "([" + IRUB_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(2, 3);
                c = this.endCall(cw, mv, mname);
            }
            FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
            ic.setArity(Arity.optional());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Callback getFastOptSingletonMethod(String method) {
        String mname = this.type.getName() + "InvokerS" + method + "xx1";
        String mnamePath = this.typePath + "InvokerS" + method + "xx1";
        Class c = this.tryClass(mname);
        try {
            if (c == null) {
                String ret = this.getReturnName(method, new Class[]{RubyKernel.IRUBY_OBJECT, IRubyObject[].class});
                ClassWriter cw = this.createCtorFast(mnamePath);
                MethodVisitor mv = this.startCallSFast(cw);
                mv.visitVarInsn(25, 2);
                mv.visitTypeInsn(192, "[" + IRUB_ID);
                mv.visitTypeInsn(192, "[" + IRUB_ID);
                mv.visitMethodInsn(184, this.typePath, method, "(" + IRUB_ID + "[" + IRUB_ID + ")L" + ret + ";");
                mv.visitInsn(176);
                mv.visitMaxs(2, 3);
                c = this.endCall(cw, mv, mname);
            }
            FastInvocationCallback ic = (FastInvocationCallback)c.newInstance();
            ic.setArity(Arity.optional());
            return ic;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

