/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.HashSet;
import java.util.Set;
import org.jruby.ast.Node;
import org.jruby.compiler.AliasNodeCompiler;
import org.jruby.compiler.AndNodeCompiler;
import org.jruby.compiler.ArrayNodeArgsCompiler;
import org.jruby.compiler.ArrayNodeCompiler;
import org.jruby.compiler.AttrAssignNodeCompiler;
import org.jruby.compiler.BeginNodeCompiler;
import org.jruby.compiler.BignumNodeCompiler;
import org.jruby.compiler.BlockNodeCompiler;
import org.jruby.compiler.BreakNodeCompiler;
import org.jruby.compiler.CallNodeCompiler;
import org.jruby.compiler.ClassNodeCompiler;
import org.jruby.compiler.ClassVarAsgnNodeCompiler;
import org.jruby.compiler.ClassVarNodeCompiler;
import org.jruby.compiler.ConstDeclNodeCompiler;
import org.jruby.compiler.ConstNodeCompiler;
import org.jruby.compiler.DAsgnNodeCompiler;
import org.jruby.compiler.DStrNodeCompiler;
import org.jruby.compiler.DVarNodeCompiler;
import org.jruby.compiler.DefnNodeCompiler;
import org.jruby.compiler.DotNodeCompiler;
import org.jruby.compiler.EvStrNodeCompiler;
import org.jruby.compiler.FCallNodeCompiler;
import org.jruby.compiler.FalseNodeCompiler;
import org.jruby.compiler.FixnumNodeCompiler;
import org.jruby.compiler.FloatNodeCompiler;
import org.jruby.compiler.GlobalAsgnNodeCompiler;
import org.jruby.compiler.GlobalVarNodeCompiler;
import org.jruby.compiler.HashNodeCompiler;
import org.jruby.compiler.IfNodeCompiler;
import org.jruby.compiler.InstAsgnNodeCompiler;
import org.jruby.compiler.InstVarNodeCompiler;
import org.jruby.compiler.IterNodeCompiler;
import org.jruby.compiler.LocalAsgnNodeCompiler;
import org.jruby.compiler.LocalVarNodeCompiler;
import org.jruby.compiler.Match2NodeCompiler;
import org.jruby.compiler.Match3NodeCompiler;
import org.jruby.compiler.MatchNodeCompiler;
import org.jruby.compiler.ModuleNodeCompiler;
import org.jruby.compiler.NewlineNodeCompiler;
import org.jruby.compiler.NilNodeCompiler;
import org.jruby.compiler.NodeCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.NotNodeCompiler;
import org.jruby.compiler.NthRefNodeCompiler;
import org.jruby.compiler.OpAsgnNodeCompiler;
import org.jruby.compiler.OrNodeCompiler;
import org.jruby.compiler.RegexpNodeCompiler;
import org.jruby.compiler.ReturnNodeCompiler;
import org.jruby.compiler.RootNodeCompiler;
import org.jruby.compiler.SValueNodeCompiler;
import org.jruby.compiler.SelfNodeCompiler;
import org.jruby.compiler.SplatNodeCompiler;
import org.jruby.compiler.StringNodeCompiler;
import org.jruby.compiler.SymbolNodeCompiler;
import org.jruby.compiler.TrueNodeCompiler;
import org.jruby.compiler.VCallNodeCompiler;
import org.jruby.compiler.WhileNodeCompiler;
import org.jruby.compiler.YARVNodesCompiler;
import org.jruby.compiler.YieldNodeCompiler;
import org.jruby.compiler.ZArrayNodeCompiler;

public class NodeCompilerFactory {
    public static final boolean SAFE = System.getProperty("jruby.jit.safe", "true").equals("true");
    public static final Set UNSAFE_CALLS = new HashSet();

    public static YARVNodesCompiler getYARVCompiler() {
        return new YARVNodesCompiler();
    }

    public static NodeCompiler getCompiler(Node node) {
        switch (node.nodeId) {
            case 0: {
                return new AliasNodeCompiler();
            }
            case 1: {
                return new AndNodeCompiler();
            }
            case 5: {
                return new ArrayNodeCompiler();
            }
            case 102: {
                return new AttrAssignNodeCompiler();
            }
            case 8: {
                return new BeginNodeCompiler();
            }
            case 9: {
                return new BignumNodeCompiler();
            }
            case 12: {
                return new BlockNodeCompiler();
            }
            case 14: {
                if (SAFE) {
                    throw new NotCompilableException("Can't compile node safely: " + node);
                }
                return new BreakNodeCompiler();
            }
            case 15: {
                return new CallNodeCompiler();
            }
            case 17: {
                return new ClassNodeCompiler();
            }
            case 20: {
                return new ClassVarNodeCompiler();
            }
            case 18: {
                return new ClassVarAsgnNodeCompiler();
            }
            case 23: {
                return new ConstDeclNodeCompiler();
            }
            case 24: {
                return new ConstNodeCompiler();
            }
            case 25: {
                return new DAsgnNodeCompiler();
            }
            case 27: {
                return new DefnNodeCompiler();
            }
            case 29: {
                return new DotNodeCompiler();
            }
            case 31: {
                return new DStrNodeCompiler();
            }
            case 33: {
                return new DVarNodeCompiler();
            }
            case 36: {
                return new EvStrNodeCompiler();
            }
            case 37: {
                return new FalseNodeCompiler();
            }
            case 38: {
                return new FCallNodeCompiler();
            }
            case 39: {
                return new FixnumNodeCompiler();
            }
            case 41: {
                return new FloatNodeCompiler();
            }
            case 43: {
                return new GlobalAsgnNodeCompiler();
            }
            case 44: {
                return new GlobalVarNodeCompiler();
            }
            case 45: {
                return new HashNodeCompiler();
            }
            case 46: {
                return new IfNodeCompiler();
            }
            case 47: {
                return new InstAsgnNodeCompiler();
            }
            case 48: {
                return new InstVarNodeCompiler();
            }
            case 50: {
                return new IterNodeCompiler();
            }
            case 52: {
                return new LocalAsgnNodeCompiler();
            }
            case 53: {
                return new LocalVarNodeCompiler();
            }
            case 56: {
                return new MatchNodeCompiler();
            }
            case 54: {
                return new Match2NodeCompiler();
            }
            case 55: {
                return new Match3NodeCompiler();
            }
            case 57: {
                return new ModuleNodeCompiler();
            }
            case 59: {
                return new NewlineNodeCompiler();
            }
            case 64: {
                return new NthRefNodeCompiler();
            }
            case 61: {
                return new NilNodeCompiler();
            }
            case 63: {
                return new NotNodeCompiler();
            }
            case 66: {
                return new OpAsgnNodeCompiler();
            }
            case 70: {
                return new OrNodeCompiler();
            }
            case 73: {
                return new RegexpNodeCompiler();
            }
            case 77: {
                return new ReturnNodeCompiler();
            }
            case 101: {
                return new RootNodeCompiler();
            }
            case 80: {
                return new SelfNodeCompiler();
            }
            case 81: {
                if (SAFE) {
                    throw new NotCompilableException("Can't compile node safely: " + node);
                }
                return new SplatNodeCompiler();
            }
            case 83: {
                return new StringNodeCompiler();
            }
            case 85: {
                if (SAFE) {
                    throw new NotCompilableException("Can't compile node safely: " + node);
                }
                return new SValueNodeCompiler();
            }
            case 86: {
                return new SymbolNodeCompiler();
            }
            case 88: {
                return new TrueNodeCompiler();
            }
            case 92: {
                return new VCallNodeCompiler();
            }
            case 94: {
                return new WhileNodeCompiler();
            }
            case 96: {
                return new YieldNodeCompiler();
            }
            case 97: {
                return new ZArrayNodeCompiler();
            }
        }
        throw new NotCompilableException("Can't compile node: " + node);
    }

    public static NodeCompiler getArgumentsCompiler(Node node) {
        switch (node.nodeId) {
            case 5: {
                return new ArrayNodeArgsCompiler();
            }
        }
        throw new NotCompilableException("Can't compile argument node: " + node);
    }

    public static NodeCompiler getAssignmentCompiler(Node node) {
        int cfr_ignored_0 = node.nodeId;
        throw new NotCompilableException("Can't compile assignment node: " + node);
    }
}

