/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jruby.ast.CommentNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.evaluator.InstructionBundle;
import org.jruby.evaluator.InstructionContext;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.lexer.yacc.SourcePosition;

public abstract class Node
implements ISourcePositionHolder,
InstructionContext,
Serializable {
    static final long serialVersionUID = -5962822607672530224L;
    static final List EMPTY_LIST = new ArrayList();
    public final int nodeId;
    public InstructionBundle instruction;
    private ISourcePosition position;
    private ArrayList comments;

    public Node(ISourcePosition position, int id) {
        this.position = position;
        this.nodeId = id;
    }

    @Override
    public ISourcePosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(ISourcePosition position) {
        this.position = position;
    }

    public abstract Instruction accept(NodeVisitor var1);

    public abstract List childNodes();

    static void addNode(Node node, List list) {
        if (node != null) {
            list.add(node);
        }
    }

    protected static List createList(Node node) {
        ArrayList list = new ArrayList();
        Node.addNode(node, list);
        return list;
    }

    protected static List createList(Node node1, Node node2) {
        List list = Node.createList(node1);
        Node.addNode(node2, list);
        return list;
    }

    protected static List createList(Node node1, Node node2, Node node3) {
        List list = Node.createList(node1, node2);
        Node.addNode(node3, list);
        return list;
    }

    protected static List createList(Node node1, Node node2, Node node3, Node node4) {
        List list = Node.createList(node1, node2, node3);
        Node.addNode(node4, list);
        return list;
    }

    public String toString() {
        return this.getNodeName() + "[]";
    }

    protected String getNodeName() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(46);
        String nodeType = name.substring(i + 1);
        return nodeType;
    }

    public void addComment(CommentNode comment) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.add(comment);
    }

    public void addComments(Collection comments) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.addAll(comments);
    }

    public Collection getComments() {
        if (this.comments == null) {
            return EMPTY_LIST;
        }
        return this.comments;
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public ISourcePosition getPositionIncludingComments() {
        if (this.position == null || !this.hasComments()) {
            return this.position;
        }
        String fileName = this.position.getFile();
        int startOffset = this.position.getStartOffset();
        int endOffset = this.position.getEndOffset();
        int startLine = this.position.getStartLine();
        int endLine = this.position.getEndLine();
        SourcePosition commentIncludingPos = new SourcePosition(fileName, startLine, endLine, startOffset, endOffset);
        Iterator commentItr = this.comments.iterator();
        while (commentItr.hasNext()) {
            ISourcePosition commentPos = ((CommentNode)commentItr.next()).getPosition();
            commentIncludingPos = SourcePosition.combinePosition(commentIncludingPos, commentPos);
        }
        return commentIncludingPos;
    }
}

