/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.IdUtil;

public class RubyStruct
extends RubyObject {
    private IRubyObject[] values;
    private static ObjectAllocator STRUCT_INSTANCE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyStruct instance = new RubyStruct(runtime, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public RubyStruct(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static RubyClass createStructClass(Ruby runtime) {
        RubyClass structClass = runtime.defineClass("Struct", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        structClass.index = 15;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyStruct.class);
        structClass.includeModule(runtime.getModule("Enumerable"));
        structClass.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        structClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        structClass.defineFastMethod("initialize_copy", callbackFactory.getFastMethod("initialize_copy", RubyKernel.IRUBY_OBJECT));
        structClass.defineMethod("clone", callbackFactory.getMethod("rbClone"));
        structClass.defineFastMethod("==", callbackFactory.getFastMethod("equal", RubyKernel.IRUBY_OBJECT));
        structClass.defineFastMethod("eql?", callbackFactory.getFastMethod("eql_p", RubyKernel.IRUBY_OBJECT));
        structClass.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        structClass.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        structClass.defineFastMethod("to_a", callbackFactory.getFastMethod("to_a"));
        structClass.defineFastMethod("values", callbackFactory.getFastMethod("to_a"));
        structClass.defineFastMethod("size", callbackFactory.getFastMethod("size"));
        structClass.defineFastMethod("length", callbackFactory.getFastMethod("size"));
        structClass.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        structClass.defineMethod("each", callbackFactory.getMethod("each"));
        structClass.defineMethod("each_pair", callbackFactory.getMethod("each_pair"));
        structClass.defineFastMethod("[]", callbackFactory.getFastMethod("aref", RubyKernel.IRUBY_OBJECT));
        structClass.defineFastMethod("[]=", callbackFactory.getFastMethod("aset", RubyKernel.IRUBY_OBJECT, RubyKernel.IRUBY_OBJECT));
        structClass.defineFastMethod("members", callbackFactory.getFastMethod("members"));
        return structClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 15;
    }

    private static IRubyObject getInstanceVariable(RubyClass type, String name) {
        RubyClass structClass = type.getRuntime().getClass("Struct");
        while (type != null && type != structClass) {
            IRubyObject variable = type.getInstanceVariable(name);
            if (variable != null) {
                return variable;
            }
            type = type.getSuperClass();
        }
        return type.getRuntime().getNil();
    }

    private RubyClass classOf() {
        return this.getMetaClass() instanceof MetaClass ? this.getMetaClass().getSuperClass() : this.getMetaClass();
    }

    private void modify() {
        this.testFrozen("Struct is frozen");
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify struct");
        }
    }

    @Override
    public RubyFixnum hash() {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        int h = this.getMetaClass().getRealClass().hashCode();
        for (int i = 0; i < this.values.length; ++i) {
            h = h << 1 | (h < 0 ? 1 : 0);
            h = (int)((long)h ^ RubyNumeric.num2long(this.values[i].callMethod(context, 23, "hash")));
        }
        return runtime.newFixnum(h);
    }

    private IRubyObject setByName(String name, IRubyObject value) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        this.modify();
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (!member.eltInternal(i).asSymbol().equals(name)) continue;
            this.values[i] = value;
            return this.values[i];
        }
        throw this.notStructMemberError(name);
    }

    private IRubyObject getByName(String name) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (!member.eltInternal(i).asSymbol().equals(name)) continue;
            return this.values[i];
        }
        throw this.notStructMemberError(name);
    }

    public static RubyClass newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        int i;
        RubyClass newStruct;
        int i2;
        String name = null;
        Ruby runtime = recv.getRuntime();
        if (args.length > 0 && args[0] instanceof RubyString) {
            name = args[0].toString();
        }
        RubyArray member = runtime.newArray();
        int n = i2 = name == null ? 0 : 1;
        while (i2 < args.length) {
            member.append(RubySymbol.newSymbol(runtime, args[i2].asSymbol()));
            ++i2;
        }
        RubyClass superClass = (RubyClass)recv;
        if (name == null) {
            newStruct = new RubyClass(superClass, STRUCT_INSTANCE_ALLOCATOR);
        } else {
            if (!IdUtil.isConstant(name)) {
                throw runtime.newNameError("identifier " + name + " needs to be constant", name);
            }
            IRubyObject type = superClass.getConstantAt(name);
            if (type != null) {
                runtime.getWarnings().warn(runtime.getCurrentContext().getFramePosition(), "redefining constant Struct::" + name);
            }
            newStruct = superClass.newSubClass(name, STRUCT_INSTANCE_ALLOCATOR, superClass.getCRef(), false);
        }
        newStruct.index = 15;
        newStruct.setInstanceVariable("__size__", member.length());
        newStruct.setInstanceVariable("__member__", member);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyStruct.class);
        newStruct.getSingletonClass().defineMethod("new", callbackFactory.getOptSingletonMethod("newStruct"));
        newStruct.getSingletonClass().defineMethod("[]", callbackFactory.getOptSingletonMethod("newStruct"));
        newStruct.getSingletonClass().defineMethod("members", callbackFactory.getSingletonMethod("members"));
        int n2 = i = name == null ? 0 : 1;
        while (i < args.length) {
            String memberName = args[i].asSymbol();
            newStruct.defineMethod(memberName, callbackFactory.getMethod("get"));
            newStruct.defineMethod(memberName + "=", callbackFactory.getMethod("set", RubyKernel.IRUBY_OBJECT));
            ++i;
        }
        if (block.isGiven()) {
            block.yield(runtime.getCurrentContext(), null, newStruct, newStruct, false);
        }
        return newStruct;
    }

    public static RubyStruct newStruct(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyStruct struct = new RubyStruct(recv.getRuntime(), (RubyClass)recv);
        int size = RubyNumeric.fix2int(RubyStruct.getInstanceVariable((RubyClass)recv, "__size__"));
        struct.values = new IRubyObject[size];
        struct.callInit(args, block);
        return struct;
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        int i;
        this.modify();
        int size = RubyNumeric.fix2int(RubyStruct.getInstanceVariable(this.getMetaClass(), "__size__"));
        if (args.length > size) {
            throw this.getRuntime().newArgumentError("struct size differs (" + args.length + " for " + size + ")");
        }
        for (i = 0; i < args.length; ++i) {
            this.values[i] = args[i];
        }
        for (i = args.length; i < size; ++i) {
            this.values[i] = this.getRuntime().getNil();
        }
        return this.getRuntime().getNil();
    }

    public static RubyArray members(IRubyObject recv, Block block) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable((RubyClass)recv, "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        RubyArray result = recv.getRuntime().newArray(member.getLength());
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            result.append(recv.getRuntime().newString(member.eltInternal(i).asSymbol()));
        }
        return result;
    }

    public RubyArray members() {
        return RubyStruct.members(this.classOf(), Block.NULL_BLOCK);
    }

    public IRubyObject set(IRubyObject value, Block block) {
        String name = this.getRuntime().getCurrentContext().getFrameName();
        if (name.endsWith("=")) {
            name = name.substring(0, name.length() - 1);
        }
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        this.modify();
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (!member.eltInternal(i).asSymbol().equals(name)) continue;
            this.values[i] = value;
            return this.values[i];
        }
        throw this.notStructMemberError(name);
    }

    private RaiseException notStructMemberError(String name) {
        return this.getRuntime().newNameError(name + " is not struct member", name);
    }

    public IRubyObject get(Block block) {
        String name = this.getRuntime().getCurrentContext().getFrameName();
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (!member.eltInternal(i).asSymbol().equals(name)) continue;
            return this.values[i];
        }
        throw this.notStructMemberError(name);
    }

    @Override
    public IRubyObject rbClone(Block block) {
        RubyStruct clone = new RubyStruct(this.getRuntime(), this.getMetaClass());
        clone.values = new IRubyObject[this.values.length];
        System.arraycopy(this.values, 0, clone.values, 0, this.values.length);
        clone.setFrozen(this.isFrozen());
        clone.setTaint(this.isTaint());
        return clone;
    }

    @Override
    public IRubyObject equal(IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass().getRealClass() != other.getMetaClass().getRealClass()) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        RubyStruct otherStruct = (RubyStruct)other;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equalInternal(context, otherStruct.values[i]).isTrue()) continue;
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    public IRubyObject eql_p(IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass() != other.getMetaClass()) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        RubyStruct otherStruct = (RubyStruct)other;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].eqlInternal(context, otherStruct.values[i])) continue;
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @Override
    public IRubyObject to_s() {
        return this.inspect();
    }

    @Override
    public IRubyObject inspect() {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        StringBuffer sb = new StringBuffer(100);
        sb.append("#<struct ").append(this.getMetaClass().getRealClass().getName()).append(' ');
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(member.eltInternal(i).asSymbol()).append("=");
            sb.append(this.values[i].callMethod(this.getRuntime().getCurrentContext(), "inspect"));
        }
        sb.append('>');
        return this.getRuntime().newString(sb.toString());
    }

    public RubyArray to_a() {
        return this.getRuntime().newArray(this.values);
    }

    public RubyFixnum size() {
        return this.getRuntime().newFixnum(this.values.length);
    }

    public IRubyObject each(Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = 0; i < this.values.length; ++i) {
            block.yield(context, this.values[i]);
        }
        return this;
    }

    public IRubyObject each_pair(Block block) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = 0; i < this.values.length; ++i) {
            block.yield(context, this.getRuntime().newArrayNoCopy(new IRubyObject[]{member.eltInternal(i), this.values[i]}));
        }
        return this;
    }

    public IRubyObject aref(IRubyObject key) {
        if (key instanceof RubyString || key instanceof RubySymbol) {
            return this.getByName(key.asSymbol());
        }
        int idx = RubyNumeric.fix2int(key);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        return this.values[idx];
    }

    public IRubyObject aset(IRubyObject key, IRubyObject value) {
        if (key instanceof RubyString || key instanceof RubySymbol) {
            return this.setByName(key.asSymbol(), value);
        }
        int idx = RubyNumeric.fix2int(key);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        this.modify();
        this.values[idx] = value;
        return this.values[idx];
    }

    public static void marshalTo(RubyStruct struct, MarshalStream output) throws IOException {
        output.dumpDefaultObjectHeader('S', struct.getMetaClass());
        List members = ((RubyArray)RubyStruct.getInstanceVariable(struct.classOf(), "__member__")).getList();
        output.writeInt(members.size());
        for (int i = 0; i < members.size(); ++i) {
            RubySymbol name = (RubySymbol)members.get(i);
            output.dumpObject(name);
            output.dumpObject(struct.values[i]);
        }
    }

    public static RubyStruct unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol className;
        Ruby runtime = input.getRuntime();
        RubyClass rbClass = RubyStruct.pathToClass(runtime, (className = (RubySymbol)input.unmarshalObject()).asSymbol());
        if (rbClass == null) {
            throw runtime.newNameError("uninitialized constant " + className, className.asSymbol());
        }
        RubyArray mem = RubyStruct.members(rbClass, Block.NULL_BLOCK);
        int len = input.unmarshalInt();
        IRubyObject[] values = new IRubyObject[len];
        for (int i = 0; i < len; ++i) {
            values[i] = runtime.getNil();
        }
        RubyStruct result = RubyStruct.newStruct(rbClass, values, Block.NULL_BLOCK);
        input.registerLinkTarget(result);
        for (int i = 0; i < len; ++i) {
            IRubyObject slot = input.unmarshalObject();
            if (!mem.eltInternal(i).toString().equals(slot.toString())) {
                throw runtime.newTypeError("struct " + rbClass.getName() + " not compatible (:" + slot + " for :" + mem.eltInternal(i) + ")");
            }
            result.aset(runtime.newFixnum(i), input.unmarshalObject());
        }
        return result;
    }

    private static RubyClass pathToClass(Ruby runtime, String path) {
        return (RubyClass)runtime.getClassFromPath(path);
    }

    @Override
    public IRubyObject initialize_copy(IRubyObject arg) {
        if (this == arg) {
            return this;
        }
        RubyStruct original = (RubyStruct)arg;
        this.values = new IRubyObject[original.values.length];
        System.arraycopy(original.values, 0, this.values, 0, original.values.length);
        return this;
    }
}

