/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNameError
extends RubyException {
    private IRubyObject name;
    private static ObjectAllocator NAMEERROR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyNameError(runtime, klass);
        }
    };

    public static RubyClass createNameErrorClass(Ruby runtime, RubyClass standardErrorClass) {
        RubyClass nameErrorClass = runtime.defineClass("NameError", standardErrorClass, NAMEERROR_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyNameError.class);
        nameErrorClass.getMetaClass().defineFastMethod("new", callbackFactory.getFastOptSingletonMethod("newRubyNameError"));
        nameErrorClass.getMetaClass().defineFastMethod("exception", callbackFactory.getFastOptSingletonMethod("newRubyNameError"));
        nameErrorClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        nameErrorClass.defineFastMethod("name", callbackFactory.getFastMethod("name"));
        return nameErrorClass;
    }

    protected RubyNameError(Ruby runtime, RubyClass exceptionClass) {
        this(runtime, exceptionClass, exceptionClass.getName().toString());
    }

    public RubyNameError(Ruby runtime, RubyClass exceptionClass, String message) {
        this(runtime, exceptionClass, message, null);
    }

    public RubyNameError(Ruby runtime, RubyClass exceptionClass, String message, String name) {
        super(runtime, exceptionClass, message);
        this.name = name == null ? runtime.getNil() : runtime.newString(name);
    }

    public static RubyNameError newRubyNameError(IRubyObject recv, IRubyObject[] args) {
        RubyClass klass = (RubyClass)recv;
        RubyNameError newError = (RubyNameError)klass.allocate();
        newError.callInit(args, Block.NULL_BLOCK);
        return newError;
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        super.initialize(args, block);
        if (args.length > 1) {
            this.name = args[1];
        }
        return this;
    }

    public IRubyObject name() {
        return this.name;
    }
}

