/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyUnboundMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyMethod
extends RubyObject {
    protected RubyModule implementationModule;
    protected String methodName;
    protected RubyModule originModule;
    protected String originName;
    protected DynamicMethod method;
    protected IRubyObject receiver;

    protected RubyMethod(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby runtime) {
        RubyClass methodClass = runtime.defineClass("Method", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyMethod.class);
        methodClass.defineFastMethod("arity", callbackFactory.getFastMethod("arity"));
        methodClass.defineMethod("to_proc", callbackFactory.getMethod("to_proc"));
        methodClass.defineMethod("unbind", callbackFactory.getMethod("unbind"));
        methodClass.defineMethod("call", callbackFactory.getOptMethod("call"));
        methodClass.defineMethod("[]", callbackFactory.getOptMethod("call"));
        methodClass.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        methodClass.defineFastMethod("to_s", callbackFactory.getFastMethod("inspect"));
        return methodClass;
    }

    public static RubyMethod newMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method, IRubyObject receiver) {
        Ruby runtime = implementationModule.getRuntime();
        RubyMethod newMethod = new RubyMethod(runtime, runtime.getClass("Method"));
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method;
        newMethod.receiver = receiver;
        return newMethod;
    }

    public IRubyObject call(IRubyObject[] args, Block block) {
        assert (args != null);
        ThreadContext tc = this.getRuntime().getCurrentContext();
        this.method.getArity().checkArity(this.getRuntime(), args);
        return this.method.call(tc, this.receiver, this.implementationModule, this.methodName, args, false, block);
    }

    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getArity().getValue());
    }

    public IRubyObject to_proc(Block unusedBlock) {
        CallbackFactory f = this.getRuntime().callbackFactory(RubyMethod.class);
        Ruby r = this.getRuntime();
        ThreadContext tc = r.getCurrentContext();
        MethodBlock block = MethodBlock.createMethodBlock(tc, tc.getCurrentScope().cloneScope(), f.getBlockMethod("bmcall"), this, r.getTopSelf());
        while (true) {
            try {
                return f.getSingletonMethod("mproc").execute(this.getRuntime().getNil(), IRubyObject.NULL_ARRAY, block);
            }
            catch (JumpException je) {
                if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                    return (IRubyObject)je.getValue();
                }
                if (je.getJumpType() != JumpException.JumpType.ReturnJump) continue;
                return (IRubyObject)je.getValue();
                if (je.getJumpType() == JumpException.JumpType.RetryJump) continue;
                throw je;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject mproc(IRubyObject recv, Block block) {
        Ruby runtime = recv.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        tc.preMproc();
        try {
            RubyProc rubyProc = RubyKernel.proc(recv, block);
            return rubyProc;
        }
        finally {
            tc.postMproc();
        }
    }

    public static IRubyObject bmcall(IRubyObject blockArg, IRubyObject arg1, IRubyObject self, Block unusedBlock) {
        if (blockArg instanceof RubyArray) {
            return ((RubyMethod)arg1).call(((RubyArray)blockArg).toJavaArray(), Block.NULL_BLOCK);
        }
        return ((RubyMethod)arg1).call(new IRubyObject[]{blockArg}, Block.NULL_BLOCK);
    }

    public RubyUnboundMethod unbind(Block unusedBlock) {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
        unboundMethod.receiver = this;
        unboundMethod.infectBy(this);
        return unboundMethod;
    }

    @Override
    public IRubyObject inspect() {
        String cname = this.getMetaClass().getRealClass().getName();
        RubyString str = this.getRuntime().newString("#<" + cname + ": " + this.originModule.getName() + "#" + this.methodName + ">");
        str.setTaint(this.isTaint());
        return str;
    }
}

