/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class RubyInteger
extends RubyNumeric {
    public static RubyClass createIntegerClass(Ruby runtime) {
        RubyClass integer = runtime.defineClass("Integer", runtime.getClass("Numeric"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyInteger.class);
        integer.getSingletonClass().undefineMethod("allocate");
        integer.getSingletonClass().undefineMethod("new");
        integer.defineFastMethod("integer?", callbackFactory.getFastMethod("int_p"));
        integer.defineMethod("upto", callbackFactory.getMethod("upto", RubyKernel.IRUBY_OBJECT));
        integer.defineMethod("downto", callbackFactory.getMethod("downto", RubyKernel.IRUBY_OBJECT));
        integer.defineMethod("times", callbackFactory.getMethod("times"));
        integer.includeModule(runtime.getModule("Precision"));
        integer.defineFastMethod("succ", callbackFactory.getFastMethod("succ"));
        integer.defineFastMethod("next", callbackFactory.getFastMethod("succ"));
        integer.defineFastMethod("chr", callbackFactory.getFastMethod("chr"));
        integer.defineFastMethod("to_i", callbackFactory.getFastMethod("to_i"));
        integer.defineFastMethod("to_int", callbackFactory.getFastMethod("to_i"));
        integer.defineFastMethod("floor", callbackFactory.getFastMethod("to_i"));
        integer.defineFastMethod("ceil", callbackFactory.getFastMethod("to_i"));
        integer.defineFastMethod("round", callbackFactory.getFastMethod("to_i"));
        integer.defineFastMethod("truncate", callbackFactory.getFastMethod("to_i"));
        integer.getMetaClass().defineFastMethod("induced_from", callbackFactory.getFastSingletonMethod("induced_from", RubyKernel.IRUBY_OBJECT));
        return integer;
    }

    public RubyInteger(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    @Override
    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @Override
    public IRubyObject int_p() {
        return this.getRuntime().getTrue();
    }

    public IRubyObject upto(IRubyObject to, Block block) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
            long fromValue;
            RubyFixnum toFixnum = (RubyFixnum)to;
            long toValue = toFixnum.getLongValue();
            for (long i = fromValue = this.getLongValue(); i <= toValue; ++i) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i));
            }
        } else {
            RubyNumeric i = this;
            while (!i.callMethod(context, 24, ">", to).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, 1, "+", RubyFixnum.one(runtime));
            }
        }
        return this;
    }

    public IRubyObject downto(IRubyObject to, Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
            RubyFixnum toFixnum = (RubyFixnum)to;
            long toValue = toFixnum.getLongValue();
            for (long i = this.getLongValue(); i >= toValue; --i) {
                block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
            }
        } else {
            RubyNumeric i = this;
            while (!i.callMethod(context, 3, "<", to).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, 2, "-", RubyFixnum.one(this.getRuntime()));
            }
        }
        return this;
    }

    public IRubyObject times(Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this instanceof RubyFixnum) {
            long value = this.getLongValue();
            for (long i = 0L; i < value; ++i) {
                block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
            }
        } else {
            RubyNumeric i = RubyFixnum.zero(this.getRuntime());
            while (i.callMethod(context, 3, "<", this).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, 1, "+", RubyFixnum.one(this.getRuntime()));
            }
        }
        return this;
    }

    public IRubyObject succ() {
        if (this instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.getLongValue() + 1L);
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), 1, "+", RubyFixnum.one(this.getRuntime()));
    }

    public RubyString chr() {
        if (this.getLongValue() < 0L || this.getLongValue() > 255L) {
            throw this.getRuntime().newRangeError(this.toString() + " out of char range");
        }
        return this.getRuntime().newString(new String(new char[]{(char)this.getLongValue()}));
    }

    public RubyInteger to_i() {
        return this;
    }

    public static IRubyObject induced_from(IRubyObject recv, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return other;
        }
        if (other instanceof RubyFloat) {
            return other.callMethod(recv.getRuntime().getCurrentContext(), 15, "to_i");
        }
        throw recv.getRuntime().newTypeError("failed to convert " + other.getMetaClass().getName() + " into Integer");
    }
}

