/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class NativeException
extends RubyException {
    private final Throwable cause;
    public static final String CLASS_NAME = "NativeException";
    private final Ruby runtime;

    public NativeException(Ruby runtime, RubyClass rubyClass, Throwable cause) {
        super(runtime, rubyClass, cause.getClass().getName() + ": " + cause.getMessage());
        this.runtime = runtime;
        this.cause = cause;
    }

    public static RubyClass createClass(Ruby runtime, RubyClass baseClass) {
        RubyClass exceptionClass = runtime.defineClass(CLASS_NAME, baseClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(NativeException.class);
        exceptionClass.defineMethod("cause", callbackFactory.getMethod("cause"));
        return exceptionClass;
    }

    public IRubyObject cause(Block unusedBlock) {
        return this.getRuntime().getModule("JavaUtilities").callMethod(this.getRuntime().getCurrentContext(), "wrap", JavaObject.wrap(this.getRuntime(), this.cause));
    }

    @Override
    public IRubyObject backtrace() {
        IRubyObject rubyTrace = super.backtrace();
        if (rubyTrace.isNil()) {
            return rubyTrace;
        }
        RubyArray array = (RubyArray)rubyTrace;
        StackTraceElement[] stackTrace = this.cause.getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement element = stackTrace[i];
            String line = element.getFileName() + ":" + element.getLineNumber() + ":in `" + element.getClassName() + "." + element.getMethodName() + "'";
            RubyString string = this.runtime.newString(line);
            array.unshift(string);
        }
        return rubyTrace;
    }

    @Override
    public void printBacktrace(PrintStream errorStream) {
        super.printBacktrace(errorStream);
        errorStream.println("Complete Java stackTrace");
        this.cause.printStackTrace(errorStream);
    }
}

