/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public class CompiledBlock
extends Block {
    private CompiledBlockCallback callback;

    public CompiledBlock(ThreadContext context, IRubyObject self, Arity arity, DynamicScope dynamicScope, CompiledBlockCallback callback) {
        this(self, context.getCurrentFrame(), context.peekCRef(), Visibility.PUBLIC, context.getRubyClass(), dynamicScope, arity, callback);
    }

    private CompiledBlock(IRubyObject self, Frame frame, SinglyLinkedList cref, Visibility visibility, RubyModule klass, DynamicScope dynamicScope, Arity arity, CompiledBlockCallback callback) {
        super(null, self, frame, cref, visibility, klass, dynamicScope);
        this.arity = arity;
        this.callback = callback;
    }

    protected void pre(ThreadContext context, RubyModule klass) {
        context.preYieldSpecificBlock(this, klass);
    }

    protected void post(ThreadContext context) {
        context.postYield();
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args) {
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext context, IRubyObject args, IRubyObject self, RubyModule klass, boolean aValue) {
        if (klass == null) {
            self = this.self;
            this.frame.setSelf(self);
        }
        IRubyObject[] realArgs = null;
        realArgs = !aValue ? new IRubyObject[]{args} : ArgsUtil.convertToJavaArray(args);
        try {
            this.pre(context, klass);
            IRubyObject iRubyObject = this.callback.call(context, self, realArgs);
            return iRubyObject;
        }
        finally {
            this.post(context);
        }
    }

    public Block cloneBlock() {
        return new CompiledBlock(this.self, this.frame.duplicate(), this.cref, this.visibility, this.klass, this.dynamicScope.cloneScope(), this.arity, this.callback);
    }

    public Arity arity() {
        return this.arity;
    }
}

