/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.Serializable;
import org.jruby.lexer.yacc.ISourcePosition;

public class SourcePosition
implements ISourcePosition,
Serializable {
    private static final long serialVersionUID = 3762529027281400377L;
    private final String file;
    private final int startLine;
    private final int endLine;
    private int startOffset;
    private final int endOffset;

    public SourcePosition() {
        this("", 0, 0);
    }

    public SourcePosition(String file, int startLine, int endLine) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startOffset = 0;
        this.endOffset = 0;
    }

    public SourcePosition(String file, int startLine, int endLine, int startOffset, int endOffset) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public String getFile() {
        return this.file;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SourcePosition)) {
            return false;
        }
        SourcePosition other = (SourcePosition)object;
        return this.file.equals(other.file) && this.endLine == other.endLine;
    }

    public int hashCode() {
        return this.file.hashCode() ^ this.endLine;
    }

    public String toString() {
        return this.file + ":[" + this.startLine + "," + this.endLine + "]:[" + this.getStartOffset() + "," + this.getEndOffset() + "]";
    }

    public void adjustStartOffset(int relativeValue) {
        this.startOffset += relativeValue;
        if (this.startOffset < 0) {
            this.startOffset = 0;
        }
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public ISourcePosition union(ISourcePosition other) {
        return new SourcePosition(this.file, this.startLine, other.getEndLine(), this.startOffset, other.getEndOffset());
    }

    public static SourcePosition combinePosition(ISourcePosition firstPos, ISourcePosition secondPos) {
        String fileName = firstPos.getFile();
        int startOffset = firstPos.getStartOffset();
        int endOffset = firstPos.getEndOffset();
        int startLine = firstPos.getStartLine();
        int endLine = firstPos.getEndLine();
        if (startOffset > secondPos.getStartOffset()) {
            startOffset = secondPos.getStartOffset();
            startLine = secondPos.getStartLine();
        }
        if (endOffset < secondPos.getEndOffset()) {
            endOffset = secondPos.getEndOffset();
            endLine = secondPos.getEndLine();
        }
        SourcePosition combinedPosition = new SourcePosition(fileName, startLine, endLine, startOffset, endOffset);
        return combinedPosition;
    }
}

