/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOOutputStream
extends OutputStream {
    private IRubyObject io;
    private String writeMethod;

    public IOOutputStream(IRubyObject io) {
        if (io.respondsTo("write")) {
            this.writeMethod = "write";
        } else if (io.respondsTo("<<")) {
            this.writeMethod = "<<";
        } else {
            throw new IllegalArgumentException("Object: " + io + " is not a legal argument to this wrapper, cause it doesn't respond to \"write\".");
        }
        this.io = io;
    }

    @Override
    public void write(int bite) throws IOException {
        this.io.callMethod(this.io.getRuntime().getCurrentContext(), this.writeMethod, RubyString.newString(this.io.getRuntime(), new ByteList(new byte[]{(byte)bite}, false)));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.io.callMethod(this.io.getRuntime().getCurrentContext(), this.writeMethod, RubyString.newString(this.io.getRuntime(), new ByteList(b, off, len, false)));
    }

    @Override
    public void close() throws IOException {
        this.io.callMethod(this.io.getRuntime().getCurrentContext(), "close");
    }
}

