/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import org.jruby.util.IOHandler;

public abstract class IOHandlerJavaIO
extends IOHandler {
    protected int ungotc = -1;

    protected IOHandlerJavaIO(Ruby runtime) {
        super(runtime);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ByteList gets(ByteList separatorString) throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        if (separatorString == null) {
            return this.getsEntireStream();
        }
        separator = separatorString == IOHandlerJavaIO.PARAGRAPH_DELIMETER ? ByteList.create("\n\n") : separatorString;
        c = (byte)this.read();
        if (c == -1) {
            return null;
        }
        buffer = new ByteList();
        block0: while (true) {
            if (c != separator.bytes[separator.begin] && c != -1) {
                buffer.append(c);
                c = (byte)this.read();
                continue;
            }
            for (i = 0; i < separator.realSize && c != -1; ++i) {
                if (c == separator.bytes[separator.begin + i]) ** break;
                continue block0;
                buffer.append(c);
                if (i >= separator.realSize - 1) continue;
                c = (byte)this.read();
            }
            break;
        }
        if (separatorString == IOHandlerJavaIO.PARAGRAPH_DELIMETER) {
            while (c == separator.bytes[separator.begin]) {
                c = (byte)this.read();
            }
            this.ungetc(c);
        }
        return buffer;
    }

    @Override
    public ByteList getsEntireStream() throws IOException {
        byte c;
        ByteList result = new ByteList();
        while ((c = (byte)this.read()) != -1) {
            result.append((int)c);
        }
        if (result.realSize == 0) {
            return null;
        }
        return result;
    }

    public int read() throws IOException {
        try {
            if (this.ungotc >= 0) {
                int c = this.ungotc;
                this.ungotc = -1;
                return c;
            }
            return this.sysread();
        }
        catch (EOFException e) {
            return -1;
        }
    }

    @Override
    public int getc() throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        int c = this.read();
        if (c == -1) {
            return c;
        }
        return c & 0xFF;
    }

    @Override
    public ByteList read(int number) throws IOException, IOHandler.BadDescriptorException {
        try {
            if (this.ungotc >= 0) {
                ByteList buf2 = this.sysread(number - 1);
                buf2.prepend((byte)this.ungotc);
                this.ungotc = -1;
                return buf2;
            }
            return this.sysread(number);
        }
        catch (EOFException e) {
            return null;
        }
    }

    @Override
    public void ungetc(int c) {
        if (c >= 0) {
            this.ungotc = c;
        }
    }

    @Override
    public void putc(int c) throws IOException, IOHandler.BadDescriptorException {
        try {
            this.syswrite(c);
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int write(ByteList string) throws IOException, IOHandler.BadDescriptorException {
        return this.syswrite(string);
    }

    protected int sysread(ByteList buf, int length) throws IOException {
        int i;
        if (buf == null) {
            throw new IOException("sysread2: Buf is null");
        }
        for (i = 0; i < length; ++i) {
            int c = this.sysread();
            if (c == -1) {
                if (i > 0) break;
                return -1;
            }
            buf.append(c);
        }
        return i;
    }

    @Override
    public ByteList sysread(int number) throws IOException, IOHandler.BadDescriptorException {
        int s;
        if (!this.isOpen()) {
            throw new IOException("File not open");
        }
        this.checkReadable();
        ByteList buf = new ByteList(number);
        for (int position = 0; position < number; position += s) {
            s = this.sysread(buf, number - position);
            if (s != -1) continue;
            if (position > 0) break;
            throw new EOFException();
        }
        return buf;
    }

    public abstract int sysread() throws IOException;

    public abstract InputStream getInputStream();

    public abstract OutputStream getOutputStream();

    @Override
    public int ready() throws IOException {
        return this.getInputStream().available();
    }
}

