/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

public class CodegenUtils {
    public static final CodegenUtils cg = new CodegenUtils();

    public String c(String p) {
        return p.replace('/', '.');
    }

    public String p(Class n) {
        return n.getName().replace('.', '/');
    }

    public String ci(Class n) {
        if (n.isArray()) {
            if ((n = n.getComponentType()).isPrimitive()) {
                if (n == Byte.TYPE) {
                    return "[B";
                }
                if (n == Boolean.TYPE) {
                    return "[Z";
                }
                if (n == Integer.TYPE) {
                    return "[I";
                }
                if (n == Double.TYPE) {
                    return "[D";
                }
                if (n == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
            }
            return "[" + this.ci(n);
        }
        if (n.isPrimitive()) {
            if (n == Byte.TYPE) {
                return "B";
            }
            if (n == Boolean.TYPE) {
                return "Z";
            }
            if (n == Integer.TYPE) {
                return "I";
            }
            if (n == Double.TYPE) {
                return "D";
            }
            if (n == Long.TYPE) {
                return "J";
            }
            if (n == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
        }
        return "L" + this.p(n) + ";";
    }

    public String sig(Class retval, Class[] params) {
        StringBuffer signature = new StringBuffer("(");
        for (int i = 0; i < params.length; ++i) {
            signature.append(this.ci(params[i]));
        }
        signature.append(")").append(this.ci(retval));
        return signature.toString();
    }

    public String sig(Class retval) {
        StringBuffer signature = new StringBuffer("()");
        signature.append(this.ci(retval));
        return signature.toString();
    }

    public Class[] params() {
        return new Class[0];
    }

    public Class[] params(Class a) {
        return new Class[]{a};
    }

    public Class[] params(Class a, Class b) {
        return new Class[]{a, b};
    }

    public Class[] params(Class a, Class b, Class c) {
        return new Class[]{a, b, c};
    }

    public Class[] params(Class a, Class b, Class c, Class d) {
        return new Class[]{a, b, c, d};
    }

    public Class[] params(Class a, Class b, Class c, Class d, Class e) {
        return new Class[]{a, b, c, d, e};
    }

    public Class[] params(Class a, Class b, Class c, Class d, Class e, Class f) {
        return new Class[]{a, b, c, d, e, f};
    }

    public Class[] params(Class a, Class b, Class c, Class d, Class e, Class f, Class g) {
        return new Class[]{a, b, c, d, e, f, g};
    }

    public Class[] params(Class a, Class b, Class c, Class d, Class e, Class f, Class g, Class h) {
        return new Class[]{a, b, c, d, e, f, g, h};
    }

    public Class[] params(Class a, Class b, Class c, Class d, Class e, Class f, Class g, Class h, Class i) {
        return new Class[]{a, b, c, d, e, f, g, h, i};
    }

    public String cleanJavaIdentifier(String name) {
        char[] characters = name.toCharArray();
        StringBuffer cleanBuffer = new StringBuffer();
        boolean prevWasReplaced = false;
        block14: for (int i = 0; i < characters.length; ++i) {
            if (Character.isJavaIdentifierStart(characters[i])) {
                cleanBuffer.append(characters[i]);
                prevWasReplaced = false;
                continue;
            }
            if (!prevWasReplaced) {
                cleanBuffer.append("_");
            }
            prevWasReplaced = true;
            switch (characters[i]) {
                case '?': {
                    cleanBuffer.append("p_");
                    continue block14;
                }
                case '!': {
                    cleanBuffer.append("b_");
                    continue block14;
                }
                case '<': {
                    cleanBuffer.append("lt_");
                    continue block14;
                }
                case '>': {
                    cleanBuffer.append("gt_");
                    continue block14;
                }
                case '=': {
                    cleanBuffer.append("equal_");
                    continue block14;
                }
                case '[': {
                    if (i + 1 < characters.length && characters[i + 1] == ']') {
                        cleanBuffer.append("aref_");
                        ++i;
                        continue block14;
                    }
                    cleanBuffer.append("lbracket_");
                    continue block14;
                }
                case ']': {
                    cleanBuffer.append("rbracket_");
                    continue block14;
                }
                case '+': {
                    cleanBuffer.append("plus_");
                    continue block14;
                }
                case '-': {
                    cleanBuffer.append("minus_");
                    continue block14;
                }
                case '*': {
                    cleanBuffer.append("times_");
                    continue block14;
                }
                case '/': {
                    cleanBuffer.append("div_");
                    continue block14;
                }
                case '&': {
                    cleanBuffer.append("and_");
                    continue block14;
                }
                default: {
                    cleanBuffer.append(Integer.toHexString(characters[i])).append("_");
                }
            }
        }
        return cleanBuffer.toString();
    }
}

